#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <shellapi.h>
#include <string.h>
#include "appmore.h"

BOOL fWMCloseSeen = TRUE;
FARPROC lpfnOrgCloseWndProc;

long WINAPI WaitForWMCloseWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
    {
    LONG    lRet;

    lRet = CallWindowProc(lpfnOrgCloseWndProc, hWnd, message, wParam, lParam);
    if(message == WM_CLOSE)
	{
	if(IsWindow (hWnd))
	    SetWindowLong(hWnd, GWL_WNDPROC, (DWORD) lpfnOrgCloseWndProc);
        fWMCloseSeen = TRUE;
	}
    return lRet;
    }

/*------------------------------------------------------------------------*/
VOID PASCAL WaitForWMClose(HWND hWndClose)
    {
    static FARPROC  lpfnMy = NULL;
    MSG msg;

    if(lpfnMy == NULL)
	{
	lpfnMy = MakeProcInstance((FARPROC) WaitForWMCloseWndProc, hInst);
        if (lpfnMy == NULL)
            return;
	}
    lpfnOrgCloseWndProc = (FARPROC) GetWindowLong(hWndClose, GWL_WNDPROC);
    SetWindowLong(hWndClose, GWL_WNDPROC, (DWORD) lpfnMy);
    fWMCloseSeen = FALSE;

    //  This is a MUST here. We need to keep messages flowing around while
    //  we're waiting a program to make up his mind with this close thing.
    do	{
	if(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
	    {
	    TranslateMessage(&msg);
	    DispatchMessage(&msg);
	    }
	}
    while(!fWMCloseSeen);

    // We've just seen WM_DESTROY let the app to clean up
    // himself completely before we go on.
    Yield();
    }

/*-------------------------------------------------------------------------*/
BOOL PASCAL CloseApp(HWND hWndClose)
    {
    PostMessage(hWndClose, WM_CLOSE, 0, 0L);
    WaitForWMClose(hWndClose);
    //if windows is still there, application refused to die.
    if(IsWindow(hWndClose))
	return FALSE;
    return TRUE;
    }
