/*--------------------------------------------------------------------------*/
/* AppDraw.c																			*/
/*--------------------------------------------------------------------------*/
#define STRICT
#include <windows.h>
#include <windowsx.h>
#include "appmore.h"

/*-------------------------------------------------------------------------*/
void DrawItem(LPDRAWITEMSTRUCT lpIconDIS, HICON *hIcon)
    {
    iCurrent = (int) (lpIconDIS->CtlID - ID_BUTTON1);
    hWndCurrentButton = lpIconDIS->hwndItem;
    if(!AppSystem.BigButtons)
	{
	if(iCurrent == SYSTEM_BUTTON)
	    {
	    DrawIcon(lpIconDIS->hDC, 0, 0, hSystem);
	    if(bQuickLoad)
		DrawIcon(lpIconDIS->hDC, 0, 0, hQuickLoad);
	    }
	if(iCurrent >= FirstAppButton)
	    {
	    if(hIcon[iCurrent-FirstAppButton] != NULL)
		{
		if(AppButton[iCurrent-FirstAppButton].ButtonLook)
		    DrawIcon(lpIconDIS->hDC, 0, 0, hBlank);
		DrawIcon(lpIconDIS->hDC, 0, 0, hIcon[iCurrent-FirstAppButton]);
		}
	    else
		DrawIcon(lpIconDIS->hDC, 0, 0, hBlank);
	    if(AppButton[iCurrent-FirstAppButton].ProgStatus == ALIVE)
		DrawIcon(lpIconDIS->hDC, 0, 0, hPressed);
	    }
	if(bKeyboardOn == TRUE)
	    if(iCurrent == iKey)
		DrawIcon(lpIconDIS->hDC, 0, 0, hKeybOn);
	}
    if(AppSystem.BigButtons)
	{
	DrawBitmap(lpIconDIS->hDC, 0, 0, hbBlank);
	if(bKeyboardOn == TRUE)
	    if(iCurrent == iKey)
		DrawBitmap(lpIconDIS->hDC, 0, 0, hbKeyb);
	if(iCurrent == SYSTEM_BUTTON)
	    {
	    DrawIcon(lpIconDIS->hDC, 3, 3, hSystem2);
	    if(bQuickLoad)
		DrawIcon(lpIconDIS->hDC, 3, 3, hQuickLoad);
	    }
	if(iCurrent >= FirstAppButton)
	    {
	    if(hIcon[iCurrent-FirstAppButton] != NULL)
		{
		if(AppButton[iCurrent-FirstAppButton].ProgStatus == ALIVE)
		    DrawBitmap(lpIconDIS->hDC, 0, 0, hbPressed);
		DrawIcon(lpIconDIS->hDC, 3, 3, hIcon[iCurrent-FirstAppButton]);
		if(AppButton[iCurrent-FirstAppButton].ProgStatus == ALIVE)
		    DrawIcon(lpIconDIS->hDC, 3, 3, hPressed2);
		}
	    }
	}
    }

/*-------------------------------------------------------------------------*/
void DrawBitmap(HDC hdc, short x, short y, HBITMAP hBitmap)
    {
    BITMAP bm;
    HDC    hMemDC;
    POINT  pt;

    hMemDC = CreateCompatibleDC(hdc);
    SelectObject(hMemDC, hBitmap);
    GetObject(hBitmap, sizeof(BITMAP), (LPSTR) &bm);
    pt.x = bm.bmWidth;
    pt.y = bm.bmHeight;

    BitBlt(hdc, x, y, pt.x, pt.y, hMemDC, 0, 0, SRCCOPY);

    DeleteDC(hMemDC);
    }
