#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <shellapi.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "appmore.h"

char WindowsDir[MAXFILECHARS];

/*----------------------------------------------------------------------------*/
/* FUNCTION: OkMsgBox(char *szCaption, char *szFormat, ...)		     */
/*                                                                            */
/* PURPOSE:  Display in an OKmessageBox a given text				       */
/*----------------------------------------------------------------------------*/
VOID OkMsgBox(char *szCaption, char *szFormat, ...)
    {
    char szBuffer[256];
    char *pArguments;

    pArguments = (char *) &szFormat + sizeof(szFormat);
    vsprintf(szBuffer, szFormat, pArguments);
    if(AppSound.EnableSound != 0)
	if(stricmp(AppSound.ErrorMessage, "<none>") != 0)
	    sndPlaySound(AppSound.ErrorMessage, SND_ASYNC | SND_NODEFAULT);
    MessageBox(NULL, szBuffer, szCaption, MB_OK);
    }

/*----------------------------------------------------------------------------*/
/* FUNCTION: ErrorMsgBox(char *szCaption, char *szFormat, ...)		     */
/*                                                                            */
/* PURPOSE:  Display in an ErrormessageBox a given text				       */
/*----------------------------------------------------------------------------*/
VOID ErrorMsgBox(char *szCaption, char *szFormat, ...)
    {
    char szBuffer[256];
    char *pArguments;

    pArguments = (char *) &szFormat + sizeof(szFormat);
    vsprintf(szBuffer, szFormat, pArguments);
    if(AppSound.EnableSound != 0)
	if(stricmp(AppSound.ErrorMessage, "<none>") != 0)
	    sndPlaySound(AppSound.ErrorMessage, SND_ASYNC | SND_NODEFAULT);
    MessageBox(NULL, szBuffer, szCaption, MB_OK | MB_ICONEXCLAMATION);
    }

/*--------------------------------------------------------------------------*/
APPMAXSIZE CalculateAppMaxSize(VOID)
    {
    int xScreen, yScreen, xAppBar, yAppBar;
    DWORD xMax = 0, yMax = 0;
    APPMAXSIZE AppBarSize, AppSizeX, AppSizeY;

   xScreen = GetSystemMetrics(SM_CXSCREEN);
   yScreen = GetSystemMetrics(SM_CYSCREEN);
   if(AppSystem.Left == -1)
	xAppBar = xScreen - (AppWindow.cxButton*(AppWindow.nColumns+1));
    else
	xScreen = AppSystem.Left;
    if(AppSystem.Top == -1)
	yAppBar = yScreen - (AppWindow.cyButton*(AppWindow.nButtons/AppWindow.nColumns));
    else
	yAppBar = AppSystem.Top;

    // calculate the size of AppBar.
    AppBarSize.left = xAppBar;
    AppBarSize.top = yAppBar;
    AppBarSize.width = AppWindow.cxButton*AppWindow.nColumns;
    AppBarSize.height = AppWindow.cyButton*(AppWindow.nButtons/AppWindow.nColumns);

    // determine largest left space in X direction
    if(AppBarSize.left >= (xScreen -(AppBarSize.left+AppBarSize.width)))
	{
	// largest x-space is to the left of AppBar
	xMax = AppBarSize.left;
	AppSizeX.left = 0;
	AppSizeX.top = 0;
	AppSizeX.width = AppBarSize.left;
	AppSizeX.height = yScreen;
	}
    else
	{
	// largest x-space is to the right of AppBar
	xMax = (xScreen -(AppBarSize.left+AppBarSize.width));
	AppSizeX.left = AppBarSize.left + AppBarSize.width;
	AppSizeX.top = 0;
	AppSizeX.width = xScreen -(AppBarSize.left+AppBarSize.width);
	AppSizeX.height = yScreen;
	}
    if(AppBarSize.top >= (yScreen -(AppBarSize.top+AppBarSize.height)))
	{
	// largest y-space is above AppBar
	yMax = AppBarSize.top;
	AppSizeY.left = 0;
	AppSizeY.top = 0;
	AppSizeY.width = xScreen;
	AppSizeY.height = AppBarSize.top;
	}
    else
	{
	// largest y-space is under AppBar
	yMax = (yScreen -(AppBarSize.top+AppBarSize.height));
	AppSizeY.left = 0;
	AppSizeY.top = AppBarSize.top + AppBarSize.height;
	AppSizeY.width = xScreen;
	AppSizeY.height = yScreen - (AppBarSize.top+AppBarSize.height);
	}

    xMax *= yScreen;
    yMax *= xScreen;
    if(xMax >= yMax)
	return AppSizeX;
    else
	return AppSizeY;
    }

/*--------------------------------------------------------------------------*/
TEXTMETRIC RetrieveTextMetrics(HWND hWnd)
    {
    int iOldMapMode;
    HDC hDC;
    TEXTMETRIC tm;

    hDC = GetDC(hWnd);
    iOldMapMode = GetMapMode(hDC);
    SetMapMode(hDC, MM_TEXT);
    SelectFont(hDC, GetStockFont(SYSTEM_FONT));
    GetTextMetrics(hDC, &tm);
    SetMapMode(hDC, iOldMapMode);
    DeleteDC(hDC);
    return tm;
    }

/*------------------------------------------------------------------------*/
int VerifySectionName(LPSTR SectionName)
    {
    int i;
    char IniString[20];

    GetPrivateProfileString(INI_APPMORE, NUMBEROFSECTIONS, SECTIONS_DEFAULT,
				szBuffer, MAXDIGITS, INI_FILE);
    AppSystem.NumberOfSections = atoi(szBuffer);
    AppSystem.NumberOfSections = max(AppSystem.NumberOfSections, 0);

    if(AppSystem.NumberOfSections == 0)
	return 0;

    for(i=0;i<AppSystem.NumberOfSections;i++)
	{
	sprintf(IniString,"%d",i+1);
	GetPrivateProfileString(INI_APPMORE, IniString, SECTIONNAME_DEFAULT,
				szBuffer, MAXFILECHARS-1, INI_FILE);
	if(strcmp(szBuffer,SectionName) == 0)
	    return (i+1);
	}
    return 0;
    }

/*--------------------------------------------------------------------------*/
VOID InitDefaultButton(VOID)
    {
    char ReadString[MAXDIGITS];

    GetWindowsDirectory(WindowsDir, MAXFILECHARS);

    strcpy(AppButtonDefault.IcoName, "");
    strcpy(AppButtonDefault.ProgName, "");
    strcpy(AppButtonDefault.Params, "");
    strcpy(AppButtonDefault.StartDir, "");
    AppButtonDefault.IconNumber = 0;
    AppButtonDefault.ButtonLook = 0;
    AppButtonDefault.Close = TRUE;
    AppButtonDefault.ShowMode = 0;

    AppSound.EnableSound = 0;
    strcpy(AppSound.ProgramStart, PROGSTART_DEFAULT);
    strcpy(AppSound.ProgramClose, PROGCLOSE_DEFAULT);
    strcpy(AppSound.DropFile, DROPFILE_DEFAULT);
    strcpy(AppSound.ErrorMessage, ERRORMESSAGE_DEFAULT);

    GetPrivateProfileString(INI_APPMORE, INITIALIZED, INITIALIZED_DEFAULT,
			    ReadString, MAXDIGITS, INI_FILE);
    AppSystem.Initialized = atoi(ReadString);
    AppSystem.Initialized = max(AppSystem.Initialized, 0);
    }

/*--------------------------------------------------------------------------*/
/* FUNCTION: IniRead(void)						    */
/*									    */
/* PURPOSE:  Read settings in the appbar.ini file.			    */
/*--------------------------------------------------------------------------*/
VOID PASCAL IniRead(VOID)
    {
    char ReadString[MAXDIGITS],IniString[20];
    char SystemSection[256], ButtonSection[256], SoundSection[256];
    int i, CloseProg;

    SetCursor(LoadCursor(NULL, IDC_WAIT));

    if(AppSystem.SectionNumber == 0)
	{
	for(i=0;i<MAXAPPS;i++)
	    AppButton[i] = AppButtonDefault;
	strcpy(AppSystem.SectionName, "<none>");
	SetCursor(LoadCursor(NULL, IDC_ARROW));
	return;
	}

    sprintf(IniString,"%d", AppSystem.SectionNumber);
    GetPrivateProfileString(INI_APPMORE, IniString, SECTIONNAME_DEFAULT,
			    AppSystem.SectionName, MAXFILECHARS-1, INI_FILE);

    // get ini-settings for AppSystem struct.
    strcpy(SystemSection, AppSystem.SectionName);
    strcat(SystemSection, "_System");
    strcpy(ButtonSection, AppSystem.SectionName);
    strcat(ButtonSection, "_Buttons");
    strcpy(SoundSection, AppSystem.SectionName);
    strcat(SoundSection, "_Sounds");

    // get ini-settings for AppSystem struct.
    GetPrivateProfileString(SystemSection, LEFT, LEFT_DEFAULT, ReadString,
			    MAXDIGITS, INI_FILE);

    AppSystem.Left = atoi(ReadString);
    AppSystem.Left = max(AppSystem.Left, -1);
    AppSystem.Left = min(AppSystem.Left, MAXRES);

    GetPrivateProfileString(SystemSection, TOP, TOP_DEFAULT, ReadString,
		    MAXDIGITS, INI_FILE);
    AppSystem.Top = atoi(ReadString);
    AppSystem.Top = max(AppSystem.Top, -1);
    AppSystem.Top = min(AppSystem.Top, MAXRES);

    GetPrivateProfileString(SystemSection, BUTTONS, BUTTONS_DEFAULT, ReadString,
		    MAXDIGITS, INI_FILE);
    AppSystem.Buttons = atoi(ReadString);
    AppSystem.Buttons = max(AppSystem.Buttons, 0);
    AppSystem.Buttons = min(AppSystem.Buttons, MAXAPPS);

    GetPrivateProfileString(SystemSection, COLUMNS, COLUMNS_DEFAULT, ReadString,
		    MAXDIGITS, INI_FILE);
    AppSystem.Columns = atoi(ReadString);
    AppSystem.Columns = max(AppSystem.Columns, 1);
    AppSystem.Columns = min(AppSystem.Columns, AppSystem.Buttons+2);

    GetPrivateProfileString(SystemSection, ONELAUNCH, ONELAUNCH_DEFAULT,
		    ReadString, MAXDIGITS, INI_FILE);
    AppSystem.OneLaunch	= atoi(ReadString);
    AppSystem.OneLaunch = max(AppSystem.OneLaunch, 0);
    AppSystem.OneLaunch = min(AppSystem.OneLaunch, 1);

    GetPrivateProfileString(SystemSection, CLOSEALL, CLOSEALL_DEFAULT,
		    ReadString, MAXDIGITS, INI_FILE);
    AppSystem.CloseAll = atoi(ReadString);
    AppSystem.CloseAll = max(AppSystem.CloseAll, 0);
    AppSystem.CloseAll = min(AppSystem.CloseAll, 1);

    GetPrivateProfileString(SystemSection, DOUBLECLICK, DOUBLECLICK_DEFAULT,
		    ReadString, MAXDIGITS, INI_FILE);
    AppSystem.DoubleClick = atoi(ReadString);
    AppSystem.DoubleClick = max(AppSystem.DoubleClick, 0);
    AppSystem.DoubleClick = min(AppSystem.DoubleClick, 1);

    GetPrivateProfileString(SystemSection, STAYINFRONT, STAYINFRONT_DEFAULT,
		    ReadString, MAXDIGITS, INI_FILE);
    AppSystem.StayInFront = atoi(ReadString);
    AppSystem.StayInFront = max(AppSystem.StayInFront, 0);
    AppSystem.StayInFront = min(AppSystem.StayInFront, 1);

    GetPrivateProfileString(SoundSection, SOUNDENABLE, SOUNDENABLE_DEFAULT,
		    ReadString, MAXDIGITS, INI_FILE);
    AppSound.EnableSound = atoi(ReadString);
    AppSound.EnableSound = max(AppSound.EnableSound, 0);
    AppSound.EnableSound = min(AppSound.EnableSound, 1);

    GetPrivateProfileString(SoundSection, PROGSTART, PROGSTART_DEFAULT,
		AppSound.ProgramStart, MAXFILECHARS-1, INI_FILE);

    GetPrivateProfileString(SoundSection, PROGCLOSE, PROGCLOSE_DEFAULT,
		AppSound.ProgramClose, MAXFILECHARS-1, INI_FILE);

    GetPrivateProfileString(SoundSection, DROPFILE, DROPFILE_DEFAULT,
		AppSound.DropFile, MAXFILECHARS-1, INI_FILE);

    GetPrivateProfileString(SoundSection, ERRORMESSAGE, ERRORMESSAGE_DEFAULT,
		AppSound.ErrorMessage, MAXFILECHARS-1, INI_FILE);

    // get settings for AppButon struct.
    for(i=0;i<MAXAPPS;i++)
	{
	AppButton[i] = AppButtonDefault;
	sprintf(IniString,"Icon%d",i+1);
	GetPrivateProfileString(ButtonSection, IniString, AppButton[i].IcoName,
				AppButton[i].IcoName, MAXFILECHARS-1, INI_FILE);

	sprintf(IniString,"Prog%d",i+1);
	GetPrivateProfileString(ButtonSection, IniString, WindowsDir,
				AppButton[i].ProgName, MAXFILECHARS-1, INI_FILE);

	sprintf(IniString,"Dir%d",i+1);
	GetPrivateProfileString(ButtonSection, IniString, AppButton[i].StartDir,
				AppButton[i].StartDir, MAXFILECHARS-1, INI_FILE);

	sprintf(IniString,"Params%d",i+1);
	GetPrivateProfileString(ButtonSection, IniString, AppButton[i].Params,
				AppButton[i].Params, MAXFILECHARS-1, INI_FILE);

	sprintf(IniString,"Close%d",i+1);
	GetPrivateProfileString(ButtonSection, IniString, CLOSEPROG_DEFAULT,
				ReadString, MAXDIGITS, INI_FILE);
	CloseProg = atoi(ReadString);
	CloseProg = (CloseProg > 0) ? CloseProg : 0;
	CloseProg = (CloseProg < 1) ? CloseProg : 1;
	if(CloseProg == 1)
	    AppButton[i].Close = TRUE;
	else
	    AppButton[i].Close = FALSE;
	if(AppSystem.CloseAll == 0)
	    AppButton[i].Close = FALSE;

	sprintf(IniString,"ShowMode%d",i+1);
	GetPrivateProfileString(ButtonSection, IniString, SHOWMODE_DEFAULT,
				ReadString, MAXDIGITS, INI_FILE);
	AppButton[i].ShowMode = atoi(ReadString);
	AppButton[i].ShowMode = max(AppButton[i].ShowMode, 0);
	AppButton[i].ShowMode = min(AppButton[i].ShowMode, 3);

	sprintf(IniString,"IconNumber%d",i+1);
	GetPrivateProfileString(ButtonSection, IniString, ICONNUMBER_DEFAULT,
				ReadString, MAXDIGITS, INI_FILE);
	AppButton[i].IconNumber = atoi(ReadString);
	AppButton[i].IconNumber = max(AppButton[i].IconNumber, 0);

	sprintf(IniString,"ButtonLook%d",i+1);
	GetPrivateProfileString(ButtonSection, IniString, BUTTONLOOK_DEFAULT,
				ReadString, MAXDIGITS, INI_FILE);
	AppButton[i].ButtonLook = atoi(ReadString);
	AppButton[i].ButtonLook = max(AppButton[i].ButtonLook, 0);
	AppButton[i].ButtonLook = min(AppButton[i].ButtonLook, 1);
	}
    SetCursor(LoadCursor(NULL, IDC_ARROW));
    }

/*--------------------------------------------------------------------------*/
VOID PASCAL SaveButton(int i)
    {
    char SaveString[MAXDIGITS], IniString[20];
    char ButtonSection[256];

    strcpy(ButtonSection, AppSystem.SectionName);
    strcat(ButtonSection, "_Buttons");

    sprintf(IniString,"Icon%d",i+1);
    WritePrivateProfileString(ButtonSection, IniString, AppButton[i].IcoName, INI_FILE);
    sprintf(IniString,"Prog%d",i+1);
    WritePrivateProfileString(ButtonSection, IniString, AppButton[i].ProgName, INI_FILE);
    sprintf(IniString,"Dir%d",i+1);
    WritePrivateProfileString(ButtonSection, IniString, AppButton[i].StartDir, INI_FILE);
    sprintf(IniString,"Params%d",i+1);
    WritePrivateProfileString(ButtonSection, IniString, AppButton[i].Params, INI_FILE);
    sprintf(IniString,"Close%d",i+1);
    sprintf(SaveString,"%d",AppButton[i].Close);
    WritePrivateProfileString(ButtonSection, IniString, SaveString, INI_FILE);
    sprintf(IniString,"ShowMode%d",i+1);
    sprintf(SaveString,"%d",AppButton[i].ShowMode);
    WritePrivateProfileString(ButtonSection, IniString, SaveString, INI_FILE);
    sprintf(IniString,"IconNumber%d",i+1);
    sprintf(SaveString,"%d",AppButton[i].IconNumber);
    WritePrivateProfileString(ButtonSection, IniString, SaveString, INI_FILE);
    sprintf(IniString,"ButtonLook%d",i+1);
    sprintf(SaveString,"%d",AppButton[i].ButtonLook);
    WritePrivateProfileString(ButtonSection, IniString, SaveString, INI_FILE);
    }

/*-------------------------------------------------------------------------*/
VOID SetNormalChildCursor(VOID)
    {
    SetClassWord(hWndButton[0], GCW_HCURSOR,
	     LoadCursor(NULL, IDC_ARROW));
    }

/*-------------------------------------------------------------------------*/
VOID SetShuffleChildCursor(VOID)
    {
    SetClassWord(hWndButton[0], GCW_HCURSOR,
	     LoadCursor(hInst, "AppShuffle"));
    }

/*-------------------------------------------------------------------------*/
void LoadAllButtonIcons(HICON *hIcon)
    {
    int i;

    for(i=0;i<AppSystem.Buttons;i++)
	{
	hIcon[i] = ExtractIcon(hInst, AppButton[i].IcoName, AppButton[i].IconNumber);
	if(hIcon[i] == (HICON) 1)
	    {
	    hIcon[i] = NULL;
	    OkMsgBox("AppMore - Initialisation", "No Icons found in %s", AppButton[i].IcoName);
	    }
	}
    }
/*-------------------------------------------------------------------------*/
void LoadAppMoreResources(void)
    {
    hAppLogo   = LoadBitmap(hInst, "AppLogo");
    hNNever    = LoadBitmap(hInst, "NNever");
    hQuickLoad = LoadIcon(hInst, MAKEINTRESOURCE(1005));

    if(!AppSystem.BigButtons)
	{
	hSystem	   = LoadIcon(hInst, MAKEINTRESOURCE(1000));
	hPressed   = LoadIcon(hInst, MAKEINTRESOURCE(1004));
	hBlank	   = LoadIcon(hInst, MAKEINTRESOURCE(1003));
	hKeybOn	   = LoadIcon(hInst, MAKEINTRESOURCE(1006));
	}

    if(AppSystem.BigButtons)
	{
	hSystem2  = LoadIcon(hInst, MAKEINTRESOURCE(1008));
	hPressed2 = LoadIcon(hInst, MAKEINTRESOURCE(1007));
	hbBlank   = LoadBitmap(hInst, "BlankBMP");
	hbKeyb	  = LoadBitmap(hInst, "KeybBMP");
	hbPressed = LoadBitmap(hInst, "PressBMP");
	}
    }

/*-------------------------------------------------------------------------*/
void FreeAppMoreResources(void)
    {
    DeleteBitmap(hAppLogo);
    DeleteBitmap(hNNever);

    if(AppSystem.BigButtons)
	{
	DeleteBitmap(hbBlank);
	DeleteBitmap(hbKeyb);
	DeleteBitmap(hbPressed);
	}
    }
