/*-------------------------------------------------------------------------
 AppFindr.c

 AppFinder, a File launch utility for AppBar.

 by
 GMP van kempen
 NEVERnever Software 1993

History:
4.00.1 First Beta release


---------------------------------------------------------------------------*/
#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <shellapi.h>
#include <ctype.h>
#include <string.h>
#include <stdio.h>
#include <io.h>
#include <stdarg.h>
#include <stdio.h>
#include <direct.h>
#include "appfindr.h"

HANDLE hFont;
HINSTANCE hInst;
HMENU  hMenu;
HWND   ghWnd;
HWND   hWndFile, hWndDir, hWndDrive;
HICON  hFileIcon, hExeFileIcon, hSmallIcon, hDosFileIcon, hTTFFileIcon;
HICON  hATMFileIcon, hPIFFileIcon, hDrvFileIcon, hFontIcon, hEnhIcon;
HICON  hFolderIcon, hDosFolderIcon, hSysFolderIcon;
BOOL  FirstMinMax = TRUE;

char  szAppName[]    = "AppFindr";
char  szAppTitle[]   = "AppFinder";
char  DropFile[80], Temp[80];
char  DriveName[10], PathName[90];

int   CharWidth, CharHeight;
int   xSpacing, ySpacing, xSelPos = 0, ySelPos = 0;
int   xMaxIcons, yMaxIcons;
int   IconsInWindow, FileCount, DirCount, DriveCount;
int   CurrentIndex, CurrentSelection = 0;

RECT  gClientRect;

/* functions for Drag & Drop serving */
HGLOBAL FAR DragCreateFiles (LPPOINT lpptMousePos, BOOL fInNonClientArea);
HGLOBAL FAR DragAppendFile (HGLOBAL hDrop, LPCSTR szPathname);

/*----------------------------------------------------------------------------*/
/* FUNCTION: WinMain(HANDLE, HANDLE, LPSTR, int)                              */
/*                                                                            */
/* PURPOSE:  Calls initialization function, processes message loop            */
/*----------------------------------------------------------------------------*/
int PASCAL WinMain(HINSTANCE Inst, HINSTANCE hPrevInst, LPSTR lpCmdLine, int nCmdShow)
    {
    MSG  msg;
    int xScreen, yScreen;

    if (!hPrevInst)
        {
        if(!AppInit(Inst))
            return(FALSE);
        }
    else
        return(FALSE);

    /* get screen size to determine Window position */
    xScreen = GetSystemMetrics(SM_CXSCREEN);
    yScreen = GetSystemMetrics(SM_CYSCREEN);

    ghWnd = CreateWindow(szAppName, szAppTitle,
		 WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN | WS_VSCROLL,
		 xScreen/4, yScreen/4, CW_USEDEFAULT, 0, NULL, NULL, Inst, NULL);

    if (!ghWnd)
	return (FALSE);

    /* load all file and directory icons */
    hFileIcon = LoadIcon(hInst, "FileIcon");
    hDosFileIcon = LoadIcon(hInst, "DosFileIcon");
    hExeFileIcon = LoadIcon(hInst, "ExeFileIcon");
    hPIFFileIcon = LoadIcon(hInst, "PIFFileIcon");
    hATMFileIcon = LoadIcon(hInst, "ATMFileIcon");
    hTTFFileIcon = LoadIcon(hInst, "TTFFileIcon");
    hDrvFileIcon = LoadIcon(hInst, "DrvFileIcon");
    hEnhIcon = LoadIcon(hInst, "EnhIcon");
    hFontIcon = LoadIcon(hInst, "FontIcon");
    hSmallIcon = LoadIcon(hInst, "SmallIcon");
    hFolderIcon = LoadIcon(hInst, "FolderIcon");
    hSysFolderIcon = LoadIcon(hInst, "SysFolderIcon");
    hDosFolderIcon = LoadIcon(hInst, "DosFolderIcon");

    ShowWindow(ghWnd, nCmdShow);
    UpdateWindow(ghWnd);

    while (GetMessage(&msg, NULL, NULL, NULL))
	{
	TranslateMessage(&msg);
	DispatchMessage(&msg);
        }

    return (msg.wParam);
    }

/*----------------------------------------------------------------------------*/
/* FUNCTION: AppInit(HANDLE)                                                  */
/*                                                                            */
/* PURPOSE: Initializes window data and registers window class                */
/*----------------------------------------------------------------------------*/
BOOL AppInit(HINSTANCE hInstance)
    {
    HDC hDC;
    WNDCLASS   rClass;
    TEXTMETRIC tm;
    HFONT hOldFont;
    int	 cxIcon = GetSystemMetrics (SM_CXICON);

    hInst = hInstance;

    /* get char width and height */
    hDC = GetDC(ghWnd);
    hOldFont = SelectObject (hDC, GetStockObject (ANSI_VAR_FONT));
    GetTextMetrics(hDC,&tm);
    CharWidth  = tm.tmAveCharWidth;
    CharHeight = tm.tmHeight + tm.tmExternalLeading;
    xSpacing = (15 * CharWidth);
    if(xSpacing < (2 * cxIcon))
	xSpacing = 2 * cxIcon;
    ySpacing  = (CharHeight + 49);
    SelectObject (hDC, hOldFont);
    ReleaseDC (ghWnd,hDC);


    rClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
    rClass.hIcon	 = LoadIcon(hInstance, "SysFolderIcon");
    rClass.lpszMenuName  = NULL;
    rClass.lpszClassName = szAppName;
    rClass.hbrBackground = GetStockObject(WHITE_BRUSH);
    rClass.hInstance     = hInstance;
    rClass.style	 = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
    rClass.lpfnWndProc   = AppWndProc;

    return RegisterClass(&rClass);
    }

/*----------------------------------------------------------------------------*/
/* FUNCTION: AppWndProc(HWND, unsigned, WORD, LONG)                           */
/*                                                                            */
/* PURPOSE:  Processes messages for main window                               */
/*----------------------------------------------------------------------------*/
long FAR PASCAL AppWndProc(HWND hWnd, UINT message,WPARAM wParam, LPARAM lParam)
    {
    PAINTSTRUCT ps;
    HFONT hOldFont;
    HDC hDC;
    int xMousePos, xPos, yMousePos, yPos, length;
    char Name[80], DirName[80], szDropPathName[200];
    HCURSOR hCrsrDrpNotAllow, hCrsrDrpSingle;
    BOOL fCallDefProc = FALSE, fInNonClientArea, fOkToDrop;
    LONG lResult = 0;
    POINT ptMousePos;
    HWND hWndSubject;
    HGLOBAL hDrop, hDropT;

    switch (message)
        {
	case WM_CREATE:
	    /* create menu for AppFinder, on this menu all drives will
		be placed */
	    hMenu = CreateMenu(hWnd);
	    /* create hidden listbox windows from which the listed drives,
	       directories and files are read */
	    hWndFile = CreateWindow("listbox", NULL, WS_CHILD | LBS_SORT,
				    CharWidth, CharHeight,
				    CharWidth * 16, CharHeight * 20,
				    hWnd, IDC_INVISIBLE, hInst, NULL);
	    hWndDir = CreateWindow("listbox", NULL, WS_CHILD | LBS_SORT,
				    CharWidth, CharHeight,
				    CharWidth * 16, CharHeight * 20,
				    hWnd, IDC_INVISIBLE+1, hInst, NULL);
	    hWndDrive = CreateWindow("listbox", NULL, WS_CHILD | LBS_SORT,
				    CharWidth, CharHeight,
				    CharWidth * 16, CharHeight * 20,
				    hWnd, IDC_INVISIBLE+2, hInst, NULL);
	    SetScrollRange(hWnd, SB_VERT, 0, 0, FALSE);
	    /* place all drives on the menu */
	    MakeDriveList();
	    /* make the create menau AppFinder's menu */
	    SetMenu(hWnd, hMenu);
	    /* fill the directory and drive listboxes */
	    MakeFileList();

	    DragAcceptFiles(hWnd, TRUE);
	    break;

	case WM_GETMINMAXINFO:
            if(FirstMinMax)
                {                      // Set maximum size for opening window
                ((LPPOINT)lParam+4)->x = (xSpacing * 6)+20;
                ((LPPOINT)lParam+4)->y = (ySpacing * 4);
                FirstMinMax = FALSE;
                }
            else                       // ensure enough room for at least 1 icon
                {
                ((LPPOINT)lParam+3)->x = (xSpacing)+20;
                ((LPPOINT)lParam+3)->y = (ySpacing * 2);
                }
	    break;

	case WM_VSCROLL:
            VerticalScrollProcess(wParam, lParam);
            break;

	case WM_SIZE:
	    if(wParam != SIZEICONIC)
                {
                int xTmp, yTmp;

                GetClientRect (ghWnd,&gClientRect);
                xTmp = (4+ gClientRect.right  - gClientRect.left) / xSpacing;
                yTmp = (   gClientRect.bottom - gClientRect.top)  / ySpacing;

                gClientRect.bottom = gClientRect.top + (ySpacing * yTmp);

                if(xTmp != xMaxIcons || yTmp != yMaxIcons)
                    {
                    xMaxIcons = xTmp;
                    yMaxIcons = yTmp;
		    IconsInWindow = xTmp * yTmp;
                    if(CurrentIndex > 0)            /* force index to boundry */
                        CurrentIndex -= (CurrentIndex % IconsInWindow);
                    AdjustScrollBar();
                    }
                }
            break;

	case WM_PAINT:
	    hDC = BeginPaint(hWnd,&ps);
	    hOldFont = SelectObject(hDC, GetStockObject (ANSI_VAR_FONT));
	    ViewIcons(hDC);
	    SelectObject(hDC, hOldFont);
	    EndPaint(hWnd, &ps);
            break;

	case WM_COMMAND:
	    /* WM_COMMAND message only generated when a drive on the
		menu is choosen: change current drive to that drive, and
		update directory and file listboxes */
	    if((wParam >= IDM_DRIVE) && (wParam < IDM_DRIVE+DriveCount))
		{
		ListBox_GetText(hWndDrive, wParam-IDM_DRIVE, DriveName);
		_chdrive((DriveName[2]+1-'a'));
		MakeFileList();
		InvalidateRect(hWnd, NULL, TRUE);
		}
	    break;

	case WM_LBUTTONDOWN:
	    /* if left mouse button is pressed, a new dir or file is
	       made the current selection */

	    /* unselected the previous selection */
	    UpdateCurrentText(0);
	    /* if there are more then one files or directories calcutate
	       which is the new one */
	    if(FileCount > 1)
		{
		/* get mouse position at left button click */
		xMousePos = (int) LOWORD(lParam);
		yMousePos = (int) HIWORD(lParam);

		/* determine which possible icon position this would be */
		xPos = (xMousePos-4)/xSpacing;
		yPos = yMousePos/ySpacing;

		/* if the possible icon position doesn't actual have an icon
		   make the last icon the selected icon */
		if(xPos > xMaxIcons)
		    xPos = xMaxIcons;
		if(yPos > yMaxIcons)
		    yPos = yMaxIcons;

		/* update the global parameters xSelPos & ySelPos */
		xSelPos = xPos;
		ySelPos = yPos;

		/* calculate the Currentselection in terms of the postion
		   in the file and directory listbox from the selected icon
		   and the scrollbar offset (= CurrentIndex ) */
		CurrentSelection = CurrentIndex + xMaxIcons*yPos+xPos;
		if(CurrentSelection > FileCount)
		    {
		    CurrentSelection = CurrentIndex;
		    xSelPos = 0;
		    ySelPos = 0;
		    }
		}
	    else
		{
		CurrentSelection = 0;
		xSelPos = 0;
		ySelPos = 0;
		}
	    /* highlight the text of the current selected icon */
	    UpdateCurrentText(1);
	    return 0L;

	case WM_MOUSEMOVE:
	    /* if the left mousebutton is not down, there is no drag&drop */
	    if(wParam != MK_LBUTTON)
		return 0L;

	    /* no directories can be drag&dropped */
	    if(CurrentSelection < DirCount)
		return 0L;

	    // Get Name of DropFile
	    ListBox_GetText(hWndFile, CurrentSelection-DirCount, Temp);
	    strcpy(szDropPathName, PathName);
	    length = strlen(szDropPathName);
	    if(szDropPathName[length-1] != '\\')
		strcat(szDropPathName, "\\");
	    strcat(szDropPathName, Temp);

	    // User has initiated the "Drag and Drop" sequence
	    // Get the handles to the cursors that will shown to the user.
	    hCrsrDrpNotAllow = LoadCursor(hInst,"DRPFIL_NOTALLOWED");
	    hCrsrDrpSingle = LoadCursor(hInst,"DRPFIL_SINGLE");

	    // *** Loop for determining the drop-file
	    //	   client window ***
	    SetCapture(hWnd);
	    do	{
		// Get cursor pos. & window under the cursor
		GetCursorPos(&ptMousePos);
		hWndSubject = WindowFromPoint(ptMousePos);

		if(!IsWindow(hWndSubject) ||
		     !(GetWindowLong(hWndSubject, GWL_EXSTYLE) &
		     WS_EX_ACCEPTFILES))
		    {
		    fOkToDrop = FALSE;
		    SetCursor(hCrsrDrpNotAllow);
		    }
		else
		    {
		    fOkToDrop = TRUE;
		    SetCursor(hCrsrDrpSingle);
		    }

		// Terminate loop when mouse button is released
	    } while (GetAsyncKeyState(VK_LBUTTON) & 0x8000);
	    ReleaseCapture();

	    // Free the loaded cursors from memory
	    DestroyCursor(hCrsrDrpNotAllow);
	    DestroyCursor(hCrsrDrpSingle);

	    if (!fOkToDrop) return 0L;

	    // Is the cursor in the window's non-client area?
	    fInNonClientArea = (HTCLIENT !=
		    SendMessage(hWndSubject, WM_NCHITTEST, 0,
		    (LONG) MAKELONG(ptMousePos.x, ptMousePos.y)));

	    // Create drop-file memory block and initialize it
	    ScreenToClient(hWndSubject, &ptMousePos);
	    hDrop = DragCreateFiles(&ptMousePos, fInNonClientArea);

	    // Append pathname to end of drop-file memory block
	    hDropT = DragAppendFile(hDrop, szDropPathName);

	    if (hDropT == NULL)
		{
		GlobalFree(hDrop);
		hDrop = NULL;
		return 0L;	// Terminate while loop
		}
	    else
		hDrop = hDropT;

	    if (hDrop != NULL)
		{
		// All pathnames appended successfully, post the message
		// to the drop-file client window
		PostMessage(hWndSubject, WM_DROPFILES, hDrop, 0L);

		// Don't free the memory, the Dropfile client will do it
		}
	    return 0L;

	case WM_LBUTTONDBLCLK:
	    // leftmouse double click to change directory or launch a file
	    SetCursor(LoadCursor(NULL, IDC_WAIT));

	    /* if a directory is double clicked, change to that directory
	       and update dir & file lists */
	    if(CurrentSelection < DirCount)
		{
		ListBox_GetText(hWndDir, CurrentSelection, Name);
		GetRealDirName(Name, DirName);
		chdir(DirName);
		MakeFileList();
		InvalidateRect(ghWnd,NULL,TRUE);
		}
	    else
	    /* otherwise launch (associated) file */
		{
		ListBox_GetText(hWndFile, CurrentSelection-DirCount, Name);
		ShellExecute(ghWnd, "open", Name, NULL, NULL, SW_SHOWNORMAL);
		}
	    SetCursor(LoadCursor(NULL, IDC_ARROW));
	    return 0L;

	case WM_DESTROY:
	    DestroyWindow(hWndFile);
	    DestroyWindow(hWndDir);
	    DestroyWindow(hWndDrive);
	    DragAcceptFiles(hWnd, FALSE);
	    PostQuitMessage(0);
            break;

	default:
            return (DefWindowProc(hWnd, message, wParam, lParam));
        } /* end switch */
    return (NULL);
    }

/*----------------------------------------------------------------------------*/
/* FUNCTION: VerticalScrollProcess(WORD wParam, LONG lParam)                  */
/*                                                                            */
/* PURPOSE:  Processes WM_VSCROLL messages from main window                   */
/*----------------------------------------------------------------------------*/
void VerticalScrollProcess(WPARAM wParam, LPARAM lParam)
    {
    switch(wParam)
        {
        case SB_THUMBPOSITION:
            CurrentIndex = LOWORD(lParam);
            if(CurrentIndex > 0)                    /* force index to boundry */
                CurrentIndex -= (CurrentIndex % IconsInWindow);
            InvalidateRect(ghWnd, NULL, TRUE);
            break;

        case SB_TOP:
            if(CurrentIndex > 0)
                {
                CurrentIndex = 0;
                InvalidateRect(ghWnd, NULL, TRUE);
                }
            break;

        case SB_BOTTOM:
            if(CurrentIndex + IconsInWindow < FileCount)
                {
                CurrentIndex = FileCount - IconsInWindow;
                InvalidateRect(ghWnd, NULL, TRUE);
                }
            break;

        case SB_LINEUP:
            if(CurrentIndex > 0)
                {
                CurrentIndex -= xMaxIcons;
                ScrollWindow(ghWnd, 0, ySpacing,
                  (LPRECT)&gClientRect, (LPRECT)&gClientRect);
		InvalidateRect(ghWnd, NULL, TRUE);
		}
            break;

        case SB_LINEDOWN:
            if((CurrentIndex + IconsInWindow) < FileCount)
                {
                CurrentIndex += xMaxIcons;
                ScrollWindow(ghWnd, 0, -ySpacing,
                  (LPRECT)&gClientRect, (LPRECT)&gClientRect);
		InvalidateRect(ghWnd, NULL, TRUE);
		}
            break;

        case SB_PAGEUP:
            if(CurrentIndex > 0)
                {
                if(CurrentIndex >= IconsInWindow)
                    CurrentIndex -= IconsInWindow;
                else
                    CurrentIndex = 0;
                InvalidateRect(ghWnd, NULL, TRUE);
                }
            break;

        case SB_PAGEDOWN:
            if((CurrentIndex + IconsInWindow) < FileCount)
                {
                CurrentIndex += IconsInWindow;
                InvalidateRect(ghWnd, NULL, TRUE);
                }
            break;

        default:
            break;
        }
    SetScrollPos(ghWnd, SB_VERT, (CurrentIndex > IconsInWindow ?
      CurrentIndex+IconsInWindow : CurrentIndex), TRUE);
    }

/*----------------------------------------------------------------------------*/
/* FUNCTION: MakeFileList()                                                   */
/*                                                                            */
/* PURPOSE: Update lists of all directories and file names in a directory     */
/*----------------------------------------------------------------------------*/
void MakeFileList()
    {
    /* update file listbox and get number of files */
    ListBox_ResetContent(hWndFile);
    ListBox_Dir(hWndFile, 0x0000, "*.*");
    FileCount = ListBox_GetCount(hWndFile);

    /* update dir listbox and get number of directories */
    ListBox_ResetContent(hWndDir);
    ListBox_Dir(hWndDir, 0x8010, "*.*");
    DirCount = ListBox_GetCount(hWndDir);

    // add number of dirs to number of files to get total of displayed items
    FileCount += DirCount;

    // update current selection parameters
    CurrentIndex = 0;
    CurrentSelection = 0;
    xSelPos = 0;
    ySelPos = 0;
    AdjustScrollBar();
    SetPathName();
    }

/*----------------------------------------------------------------------------*/
/* FUNCTION: MakeDriveList()						       */
/*                                                                            */
/* PURPOSE: Update the list of all drives  and make them menu items	*/
/*----------------------------------------------------------------------------*/
void MakeDriveList()
    {
    int i;
    char DriveName[20];

    ListBox_ResetContent(hWndDrive);
    ListBox_Dir(hWndDrive, 0xC000, "*.*");
    DriveCount = ListBox_GetCount(hWndDrive);

    for(i=0;i<DriveCount;i++)
	{
	ListBox_GetText(hWndDrive, i, DriveName);
	AppendMenu(hMenu, MF_STRING, IDM_DRIVE+i, DriveName);
	}
    }

/*----------------------------------------------------------------------------*/
/* FUNCTION: AdjustScrollBar()                                                */
/*                                                                            */
/* PURPOSE:  Sets vertical scroll bar thumbtrack indicator                    */
/*----------------------------------------------------------------------------*/
void AdjustScrollBar()
    {
    if(IconsInWindow < FileCount)
        {
        SetScrollRange(ghWnd, SB_VERT, 0, FileCount, FALSE);
        SetScrollPos(ghWnd, SB_VERT, (CurrentIndex > IconsInWindow ?
          CurrentIndex+IconsInWindow : CurrentIndex), TRUE);
        }
    else
        ShowScrollBar(ghWnd, SB_VERT, 0);   /* hide scroll bar                */
    }

/*----------------------------------------------------------------------------*/
/* FUNCTION: ViewIcons(HDC hDC)                                               */
/*                                                                            */
/* PURPOSE:  Display the max number of icons that will fit in current window  */
/*----------------------------------------------------------------------------*/
void ViewIcons(HDC hDC)
    {
    int row;

    if(FileCount == 0)
        return;

    for(row = 0; row < yMaxIcons ;row++)
        ViewIconRow(hDC, row);
    }

/*----------------------------------------------------------------------------*/
/* FUNCTION: ViewIconRow(HDC hDC, int row)                                    */
/*                                                                            */
/* PURPOSE:  Display 1 row of icons and filenames					       */
/*----------------------------------------------------------------------------*/
void ViewIconRow(HDC hDC, int row)
    {
    int   i, index, Inverted;
    int   xLoc = 4, yLoc = 0;
    char  Name[16];
    RECT  ClearRect, TextRect;

    yLoc += (ySpacing * row);
    index = (CurrentIndex + (row * xMaxIcons));

    ClearRect.left   = xLoc;
    ClearRect.top    = yLoc;
    ClearRect.right  = xLoc + (xSpacing * xMaxIcons);
    ClearRect.bottom = yLoc + ySpacing;
    FillRect(hDC, (LPRECT)&ClearRect, GetStockObject(WHITE_BRUSH));

    for(i = 0; (i < xMaxIcons) && (index < FileCount) ;i++, index++)
        {
        if(index >= 0)
	    {
	    TextRect.left = xLoc;
	    TextRect.top = yLoc + 39;
	    TextRect.right = xLoc + xSpacing;
	    TextRect.bottom = yLoc + ySpacing;
	    if(index == CurrentSelection)
		Inverted = 1;
	    else
		Inverted = 0;
	    if(index < DirCount)
		{
		ListBox_GetText(hWndDir, index, Name);
		ShowIcon(hDC, xLoc+(xSpacing/2-16), yLoc, Name, FOLDER);
		DrawItemText(hDC, Name, TextRect, Inverted);
		}
	    else
		{
		ListBox_GetText(hWndFile, index-DirCount, Name);
		ShowIcon(hDC, xLoc+(xSpacing/2-16), yLoc, Name, FILENAME);
		DrawItemText(hDC, Name, TextRect, Inverted);
		}
	    }
        xLoc += xSpacing;
        }
    }

/*----------------------------------------------------------------------------*/
/*									      */
/* PURPOSE:  Display an icon				       */
/*----------------------------------------------------------------------------*/
int ShowIcon(HDC hDC, UINT xLoc, UINT yLoc, LPSTR FileName, int type)
    {
    HICON  hIcon;
    char   DirIcon[256], Executable[256];
    int length;

    if(type == FOLDER)
	{
	if(strstr(FileName, "system"))
	    {
	    DrawIcon(hDC, xLoc, yLoc+4, hSysFolderIcon);
	    return TRUE;
	    }

	if(strstr(FileName, "dos"))
	    {
	    DrawIcon(hDC, xLoc, yLoc+4, hDosFolderIcon);
	    return TRUE;
	    }

	GetRealDirName(FileName, Executable);
	strcpy(DirIcon, PathName);
	length = strlen(PathName);

	/* if dir isn't rootdir add "\" to dirname */
	if(DirIcon[length-1] != '\\')
	    strcat(DirIcon, "\\");

	/* generate filename with same name as dir in directory dir */
	strcat(DirIcon, Executable);
	strcat(DirIcon, "\\");
	strcat(DirIcon, Executable);
	strcat(DirIcon, ".exe");

	/* try to find an icon, otherwise display normal folder icon */
	if((hIcon = ExtractIcon(hInst, DirIcon, 0)) > 1)
	    {
	    DrawIcon(hDC, xLoc, yLoc+4, hIcon);
	    return TRUE;
	    }
	DrawIcon(hDC, xLoc, yLoc+4, hFolderIcon);
	return TRUE;
	}

    /* if *.com file display dosfile icon */
    if(strstr(FileName, ".com"))
	{
	DrawIcon(hDC, xLoc, yLoc+4, hDosFileIcon);
	return TRUE;
	}

    /* if *.bat file display dosfile icon */
    if(strstr(FileName, ".bat"))
	{
	DrawIcon(hDC, xLoc, yLoc+4, hDosFileIcon);
	return TRUE;
	}

    /* PIF files have no icon and are not associated, so check if file */
    /* if file is PIF file and display a PIF icon */
    if(strstr(FileName, ".pif"))
	{
	DrawIcon(hDC, xLoc, yLoc+4, hPIFFileIcon);
	return TRUE;
	}

    /* check is file has an icon of it's own */
    if((hIcon = ExtractIcon(hInst, FileName, 0)) > 1)
	{
	DrawIcon(hDC, xLoc, yLoc+4, hIcon);
	return TRUE;
	}

    /* if file doesn't have an icon but still is an *.exe file, display
       EXE icon */
    if(strstr(FileName, ".exe"))
	{
	DrawIcon(hDC, xLoc, yLoc+4, hExeFileIcon);
	return TRUE;
	}

    /* if *.dll file doesn't have an icon display normal file icon */
    if(strstr(FileName, ".dll"))
	{
	DrawIcon(hDC, xLoc, yLoc+4, hFileIcon);
	return TRUE;
	}

    /* if file doesn't have an icon try to find an icon from it's
       associated executable file, and diplay this icon with a small
       file icon */
    if(FindExecutable(FileName, PathName, (LPSTR) Executable) > 32)
	if((hIcon = ExtractIcon(hInst, Executable, 0)) > 1)
	    {
	    DrawIcon(hDC, xLoc, yLoc+4, hIcon);
	    DrawIcon(hDC, xLoc, yLoc+4, hSmallIcon);
	    return TRUE;
	    }

    /* if file is *.386 file but doesn't have an icon display an 386 icon */
    if(strstr(FileName, ".386"))
	{
	DrawIcon(hDC, xLoc, yLoc+4, hEnhIcon);
	return TRUE;
	}

    /* display special icons for type 1 font files */
    if(strstr(FileName, ".pfb"))
	{
	DrawIcon(hDC, xLoc, yLoc+4, hATMFileIcon);
	return TRUE;
	}

    if(strstr(FileName, ".pfm"))
	{
	DrawIcon(hDC, xLoc, yLoc+4, hATMFileIcon);
	return TRUE;
	}

    if(strstr(FileName, ".afm"))
	{
	DrawIcon(hDC, xLoc, yLoc+4, hATMFileIcon);
	return TRUE;
	}

    /* display special TrueType icon for Truetype font files */
    if(strstr(FileName, ".ttf"))
	{
	DrawIcon(hDC, xLoc, yLoc+4, hTTFFileIcon);
	return TRUE;
	}

    if(strstr(FileName, ".fot"))
	{
	DrawIcon(hDC, xLoc, yLoc+4, hTTFFileIcon);
	return TRUE;
	}

   /* display an font icon for normal font files */
   if(strstr(FileName, ".fnt"))
	{
	DrawIcon(hDC, xLoc, yLoc+4, hFontIcon);
	return TRUE;
	}

    if(strstr(FileName, ".fon"))
	{
	DrawIcon(hDC, xLoc, yLoc+4, hFontIcon);
	return TRUE;
	}

    /* display an DRV icon for *.drv driver files */
    if(strstr(FileName, ".drv"))
	{
	DrawIcon(hDC, xLoc, yLoc+4, hDrvFileIcon);
	return TRUE;
	}

    /* finally display an FILE icon for all other files */
    DrawIcon(hDC, xLoc, yLoc+4, hFileIcon);
    return TRUE;
    }

/***********************************************************************
 * Title      : DrawItemText
 *                                                                            
 * Parameters : hDC - handle to the DeviceContext
 *                    We'll need this for DrawText() later.                    
 *              wIndex - index to the ITEMSTRUCT structure
 *              bInvert- whether or not the text is highlighted
 *                                                             
 * Description: Draws the text under the icon
 **********************************************************************/
void DrawItemText (HDC hDC, LPSTR Text, RECT textrect, int Invert)
{
   COLORREF   crBkColor, crTxtColor;

   if(Invert)
       {
       crBkColor = SetBkColor(hDC, GetSysColor(COLOR_HIGHLIGHT));
       crTxtColor = SetTextColor(hDC, GetSysColor(COLOR_HIGHLIGHTTEXT));

       DrawText(hDC, Text, lstrlen (Text), &textrect, DT_CENTER);

       SetBkColor(hDC, crBkColor );
       SetTextColor(hDC, crTxtColor); 
       }
   else
       DrawText(hDC, Text, lstrlen (Text), &textrect, DT_CENTER);
}


/**********************************************************************
UpdateCurrentText(): function is used to display the highlighted text
		     of the icon that is selected by the user, and to
		     display normally the text or the previous selection
***********************************************************************/
void UpdateCurrentText (int Invert)
{
   COLORREF   crBkColor, crTxtColor;
   HFONT hOldFont;
   HDC hDC;
   RECT TextRect;
   int xLoc, yLoc;
   char Text[20];

   if(CurrentSelection < DirCount)
	ListBox_GetText(hWndDir, CurrentSelection, Text);
   else
	ListBox_GetText(hWndFile, CurrentSelection-DirCount, Text);

   hDC = GetDC(ghWnd);
   hOldFont = SelectObject(hDC, GetStockObject (ANSI_VAR_FONT));

   xLoc = xSelPos * xSpacing+4;
   yLoc = ySelPos * ySpacing;

   TextRect.left = xLoc;
   TextRect.top = yLoc + 39;
   TextRect.right = xLoc + xSpacing;
   TextRect.bottom = yLoc + ySpacing;

   if(Invert)
       {
       crBkColor = SetBkColor  (hDC, GetSysColor (COLOR_HIGHLIGHT));
       crTxtColor= SetTextColor(hDC, GetSysColor (COLOR_HIGHLIGHTTEXT)); 
       DrawText (hDC, Text, lstrlen(Text), &TextRect, DT_CENTER);
       SetBkColor  (hDC, crBkColor );
       SetTextColor(hDC, crTxtColor); 
       }
   else
       DrawText (hDC, Text, lstrlen(Text), &TextRect, DT_CENTER);

   SelectObject(hDC, hOldFont);
   ReleaseDC(ghWnd, hDC);
}

/*---------------------------------------------------------------------*/
/* GetREalDirName(): removes the [ ] characters from the directoryname */
/*---------------------------------------------------------------------*/
void GetRealDirName(char *Name, char *DirName)
    {
    int i, length;

    length=strlen(Name);

    for(i=0;i<length-2;i++)
	DirName[i] = Name[i+1];
    DirName[i] = '\0';
    }

/*----------------------------------------------------------------------------*/
/* SetPathName(): Updates the Window caption with the current drive and path */
/*---------------------------------------------------------------------------*/
void SetPathName()
    {
    strcpy(PathName, getcwd(PathName, 90));
    SetWindowText(ghWnd, (LPSTR) PathName);
    }

/****************************************************************************/
/**********************                            **************************/
/********************** DROP-FILE SERVER FUNCTIONS **************************/
/**********************                            **************************/
/****************************************************************************/

typedef struct {
        WORD  wSize;                            // Size of data structure
        POINT ptMousePos;                       // Position of mouse cursor
        BOOL  fInNonClientArea;                 // Was the mouse in the
                                                // window's non-client area
} DROPFILESTRUCT, FAR *LPDROPFILESTRUCT;


HANDLE FAR DragCreateFiles (LPPOINT lpptMousePos,
                           BOOL fInNonClientArea)
{

    HGLOBAL hDrop;
    LPDROPFILESTRUCT lpDropFileStruct;

    // GMEM_SHARE must be specified because the block will
    // be passed to another application
    hDrop = GlobalAlloc(GMEM_SHARE | GMEM_MOVEABLE | GMEM_ZEROINIT,
                        sizeof(DROPFILESTRUCT) + 1);

    // If unsuccessful, return NULL
    if (hDrop == NULL) return(hDrop);

    // Lock block and initialize the data members
    lpDropFileStruct = (LPDROPFILESTRUCT) GlobalLock(hDrop);
    lpDropFileStruct->wSize = sizeof(DROPFILESTRUCT);
    lpDropFileStruct->ptMousePos = *lpptMousePos;
    lpDropFileStruct->fInNonClientArea = fInNonClientArea;
    GlobalUnlock(hDrop);
    return(hDrop);
}


HANDLE FAR DragAppendFile (HGLOBAL hDrop, LPCSTR szPathname)
{
    LPDROPFILESTRUCT lpDropFileStruct;
    LPCSTR lpCrnt;
    WORD wSize;

    lpDropFileStruct = (LPDROPFILESTRUCT) GlobalLock(hDrop);

    // Point to first pathname in list
    lpCrnt = (LPSTR) lpDropFileStruct + lpDropFileStruct->wSize;

    // Search for a pathname were first byte is a zero byte
    while (*lpCrnt)         // While the 1st char of path is non-zero
       {
       while (*lpCrnt) lpCrnt++;   // Skip to zero byte
       lpCrnt++;
       }

    // Calculate current size of block
    wSize = (WORD) (lpCrnt - (LPSTR) lpDropFileStruct + 1);
    GlobalUnlock(hDrop);

    // Increase block size to accommodate new pathname being appended
    hDrop = GlobalReAlloc(hDrop, wSize + lstrlen(szPathname) + 1,
                          GMEM_MOVEABLE | GMEM_ZEROINIT | GMEM_SHARE);

    // Return NULL if insufficient memory
    if (hDrop == NULL) return(hDrop);

    lpDropFileStruct = (LPDROPFILESTRUCT) GlobalLock(hDrop);
    // Append the pathname to the block
    lstrcpy((LPSTR) lpDropFileStruct + wSize - 1, szPathname);
    GlobalUnlock(hDrop);
    return(hDrop);  // Return the new handle to the block
}
