#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <shellapi.h>
#include <io.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <direct.h>
#include <string.h>
#include "morsetup.h"

/*--------------------------------------------------------------------------*/
/* FUNCTION: OkMsgBox(char *szCaption, char *szFormat, ...)		    */
/*									    */
/* PURPOSE:  Display in an OKmessageBox a given text			    */
/*--------------------------------------------------------------------------*/
VOID OkMsgBox(char *szCaption, char *szFormat, ...)
    {
    char szBuffer[256];
    char *pArguments;

    pArguments = (char *) &szFormat + sizeof(szFormat);
    vsprintf(szBuffer, szFormat, pArguments);
    MessageBeep(0);
    MessageBox(NULL, szBuffer, szCaption, MB_OK);
    }

/*--------------------------------------------------------------------------*/
/* FUNCTION: ErrorMsgBox(char *szCaption, char *szFormat, ...)		    */
/*									    */
/* PURPOSE:  Display in an ErrormessageBox a given text			    */
/*--------------------------------------------------------------------------*/
VOID ErrorMsgBox(char *szCaption, char *szFormat, ...)
    {
    char szBuffer[256];
    char *pArguments;

    pArguments = (char *) &szFormat + sizeof(szFormat);
    vsprintf(szBuffer, szFormat, pArguments);
    MessageBeep(MB_ICONEXCLAMATION);
    MessageBox(NULL, szBuffer, szCaption, MB_OK | MB_ICONEXCLAMATION);
    }

/*--------------------------------------------------------------------------*/
VOID LoadIconFromFile(HICON *hIcon, int i)
    {
    MaxIconNumber[i] = (int) ExtractIcon(hInst, AppButton[i].IcoName, -1);
    AppButton[i].IconNumber = min(MaxIconNumber[i]-1, AppButton[i].IconNumber);
    *hIcon = ExtractIcon(hInst, AppButton[i].IcoName, AppButton[i].IconNumber);
    if(*hIcon == (HICON) 1)
	*hIcon = NULL;
    }

/*--------------------------------------------------------------------------*/
HBRUSH SetColorLightGray(HWND hwnd, HDC hdc)
    {
    POINT point;

    SetBkColor(hdc, GetSysColor(COLOR_BTNFACE));
    SetTextColor(hdc, GetSysColor(COLOR_BTNTEXT));
    point.x = point.y = 0;
    ClientToScreen(hwnd, &point);
    SetBrushOrg(hdc, point.x, point.y);
    return GetStockBrush(LTGRAY_BRUSH);
    }

/*--------------------------------------------------------------------------*/
HBRUSH SetColorStaticText(HWND hwnd, HDC hdc)
    {
    POINT point;

    SetBkColor(hdc, GetSysColor(COLOR_BTNFACE));
    SetTextColor(hdc, GetSysColor(COLOR_HIGHLIGHT));
    point.x = point.y = 0;
    ClientToScreen(hwnd, &point);
    SetBrushOrg(hdc, point.x, point.y);
    return GetStockBrush(LTGRAY_BRUSH);
    }

/*-------------------------------------------------------------------------*/
VOID LoadExeIcon(HICON *hIcon, int iCurrent)
    {
    strcpy(szBuffer, AppButton[iCurrent].IcoName);
    strcpy(AppButton[iCurrent].IcoName, AppButton[iCurrent].ProgName);
    DestroyIcon(*hIcon);
    LoadIconFromFile(hIcon, iCurrent);
    if(*hIcon == NULL)
	{
	strcpy(AppButton[iCurrent].IcoName, szBuffer);
	LoadIconFromFile(hIcon, iCurrent);
	}
    else
	AppButton[iCurrent].ButtonLook = 1;
    Edit_SetText(hwndEdit[3], AppButton[iCurrent].IcoName);
    UpdateNextButtons(iCurrent);
    }

/*-------------------------------------------------------------------------*/
VOID PASCAL SetCaption(HWND hWndCaption, LPSTR CaptionName)
    {
    strcpy(szBuffer, CaptionName);
    strcat(szBuffer, " - ");
    strcat(szBuffer, "[");
    strcat(szBuffer, AppSystem.SectionName);
    strcat(szBuffer, "]");
    SetWindowText(hWndCaption, szBuffer);
    }
