/* AppDrop.c */

/*
   takes care of the handling of dropped files
*/

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <string.h>
#include <shellapi.h>
#include "appbar.h"

VOID ProcessDropFiles(HANDLE hDrop, HICON *hIcon)
    {
    int    iDropButton = 0, iDropped;
    char   szDropFile[MAXFILECHARS];
    POINT  DropPoint;
    UINT   i, DroppedFiles;

    DragQueryPoint(hDrop, (LPPOINT) &DropPoint);
    iDropButton = (DropPoint.y/(AppWindow.cyButton+AppSystem.Border));
    iDropButton += (AppWindow.nButtons/AppWindow.nColumns)*(DropPoint.x/(AppWindow.cxButton+AppSystem.Border));
    DroppedFiles = DragQueryFile(hDrop, 0xFFFF, (LPSTR) NULL, 0);
    iDropped = iDropButton-FirstAppButton;

    // Determine if we have to play the DropFile sound
    if(AppSound.EnableSound != 0)
	{
	if(iDropped > 0)
	    {
	    if(AppButton[iDropped].NoSound == 0)
		if(stricmp(AppSound.DropFile, "<none>") != 0)
		    sndPlaySound(AppSound.DropFile, SND_ASYNC | SND_NODEFAULT);
	    }
	else
	    {
	    if(stricmp(AppSound.DropFile, "<none>") != 0)
		sndPlaySound(AppSound.DropFile, SND_ASYNC | SND_NODEFAULT);
	    }
	}

    if(!bQuickLoad)
	{
	if(iDropped >= 0)
	    {
	    if(!IsAppTip(iDropped))
		{
		for(i=0;i<DroppedFiles;i++)
		    {
		    DragQueryFile(hDrop, i, szDropFile, sizeof(szDropFile));
		    // add szDropfile to existing parameters.
		    lstrcpy((LPSTR) szBuffer, (LPSTR) AppButton[iDropped].Params);
		    lstrcat((LPSTR) szBuffer, (LPSTR) " ");
		    if(!strchr(szDropFile, '.'))
			lstrcat((LPSTR) szDropFile, (LPSTR) ".");
		    lstrcat((LPSTR) szBuffer, (LPSTR) szDropFile);
		    ProgExec(hWndMain, AppButton[iDropped].ProgName, szBuffer, AppButton[iDropButton-FirstAppButton].StartDir, AppButton[iDropped].ShowMode);
		    }
		}
	    else
		{
		lstrcpy((LPSTR) szBuffer, (LPSTR) " ");
		for(i=0;i<DroppedFiles;i++)
		    {
		    DragQueryFile(hDrop, i, szDropFile, sizeof(szDropFile));
		    // add szDropfile to existing parameters.
		    if(lstrlen((LPSTR) szBuffer) + lstrlen((LPSTR) szDropFile) < 127)
			{
			lstrcat((LPSTR) szBuffer, (LPSTR) szDropFile);
			lstrcat((LPSTR) szBuffer, (LPSTR) " ");
			}
		    else
			{
			ProgExec(hWndMain, AppButton[iDropped].ProgName, szBuffer, AppButton[iDropButton-FirstAppButton].StartDir, AppButton[iDropped].ShowMode);
			lstrcpy((LPSTR) szBuffer, (LPSTR) " ");
			}
		    }
		ProgExec(hWndMain, AppButton[iDropped].ProgName, szBuffer, AppButton[iDropButton-FirstAppButton].StartDir, AppButton[iDropped].ShowMode);
		}
	    }
	else
	    {
	    for(i=0;i<DroppedFiles;i++)
		{
		DragQueryFile(hDrop, i, szDropFile, sizeof(szDropFile));
		ShellExecute(hWndMain, "open", szDropFile, NULL, NULL, SW_SHOWNORMAL);
		}
	    }
	}
    if(bQuickLoad)
	{
	if(iDropped >= 0)
	    {
	    AppButton[iDropped] = AppEmptyButton;
	    DragQueryFile(hDrop, 0, szDropFile, sizeof(szDropFile));
	    strcpy(AppButton[iDropped].IcoName, szDropFile);
	    strcpy(AppButton[iDropped].ProgName, szDropFile);
	    SaveButtonIni(AppButton[iDropped], iDropped, (LPSTR) INI_BUTTON, (LPSTR) INI_FILE);
	    DestroyIcon(hIcon[iDropped]);
	    hIcon[iDropped] = ExtractIcon(hInst, AppButton[iDropped].IcoName, AppButton[iDropped].IconNumber);
	    if(hIcon[iDropped] == (HICON) 1)
		hIcon[iDropped] = NULL;
	    InvalidateRect(hWndButton[iDropButton], NULL, FALSE);
	    UpdateWindow(hWndButton[iDropButton]);
	    }
	}
    DragFinish(hDrop);
    }
