/* appkeyb.c */

/*
   functions for AppBar's keyboard interface
*/

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <string.h>
#include "appbar.h"

int KeyboardInterface(int key)
    {
    switch(key)
	{
	case VK_ESCAPE:
	    if(!bKeyboardOn)
		{
		bKeyboardOn = TRUE;	// turn keyb interface on
		iKey = iCurrent = 0;
		InvalidateRect(hWndButton[iCurrent], (LPRECT) NULL, FALSE);
		UpdateWindow(hWndButton[iCurrent]);
		}
	    else
		{
		bKeyboardOn = FALSE;	// turn keyb interface off
		InvalidateRect(hWndButton[iCurrent], (LPRECT) NULL, FALSE);
		UpdateWindow(hWndButton[iCurrent]);
		}
	    return 0;

	case VK_DELETE:
	    if(bKeyboardOn)
		SendMessage(hWndMain, WM_COMMAND, ID_BUTTON1+iCurrent, MAKELPARAM(0, BN_DOUBLECLICKED));
	    return 0;

	case VK_RETURN:
	    if(bKeyboardOn)
		SendMessage(hWndMain, WM_COMMAND, ID_BUTTON1+iCurrent, MAKELPARAM(0, BN_CLICKED));
	    return 0;

	case VK_UP:
	    if(bKeyboardOn)
		{
		bKeyboardOn = FALSE;
		InvalidateRect(hWndButton[iCurrent], (LPRECT) NULL, FALSE);
		UpdateWindow(hWndButton[iCurrent]);
		iCurrent = max(0, iCurrent-1);
		iKey = iCurrent;
		bKeyboardOn = TRUE;
		InvalidateRect(hWndButton[iCurrent], (LPRECT) NULL, FALSE);
		UpdateWindow(hWndButton[iCurrent]);
		}
	    return 0;

	case VK_DOWN:
	    if(bKeyboardOn)
		{
		bKeyboardOn = FALSE;
		InvalidateRect(hWndButton[iCurrent], (LPRECT) NULL, FALSE);
		UpdateWindow(hWndButton[iCurrent]);
		iCurrent++;
		iCurrent = min(AppWindow.nButtons-1, iCurrent);
		iKey = iCurrent;
		bKeyboardOn = TRUE;
		InvalidateRect(hWndButton[iCurrent], (LPRECT) NULL, FALSE);
		UpdateWindow(hWndButton[iCurrent]);
		}
	    return 0;

	default:
	    return 0;
	}
    }

/*-------------------------------------------------------------------------*/
int ProcessSystemKeys(int SysKey)
    {
    static DLGPROC lpfnExitWDlgProc;

    switch(SysKey)
	{
	case VK_F4:	    // ALT-F4 pressed, close if not shell,
	    if(!IsAppBarShell())	 // exit windows if shell.
		{
		if(AppSound.EnableSound != 0)
		    if(stricmp(AppSound.AppBarExit, "<none>") != 0)
			sndPlaySound(AppSound.AppBarExit, SND_ASYNC | SND_NODEFAULT);
		SendMessage(hWndMain, WM_DESTROY, 0, 0);
		}
	     else
		{
		lpfnExitWDlgProc = (DLGPROC) MakeProcInstance((FARPROC)ExitWDlgProc, hInst);
		DialogBox(hInst, "ExitWDlg", hWndMain, lpfnExitWDlgProc);
		FreeProcInstance((FARPROC)lpfnExitWDlgProc);
		}
	     return 0;

	default:
	     return 0;
	}
    }
