#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <string.h>
#include "appsetup.h"

/*-------------------------------------------------------------------------*/
BOOL WINAPI InitDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
    {
    static DLGPROC lpfnSelectDirDlgProc;

    switch(message)
	{
	case WM_INITDIALOG:
	    return TRUE;

	case WM_COMMAND:
	    switch(wParam)
		{
		case IDINIT_INIT:
		    if(HIWORD(lParam) == EN_KILLFOCUS)
			{
			GetDlgItemText(hDlg, IDINIT_INIT, AppSystem.DefaultIconDir, MAXFILECHARS-1);
			SetDlgItemText(hDlg, IDINIT_INIT, AppSystem.DefaultIconDir);
			}
		    return TRUE;

		case IDINIT_OK:
		    GetDlgItemText(hDlg, IDINIT_INIT, AppSystem.DefaultIconDir, MAXFILECHARS-1);
		    WritePrivateProfileString(INI_SYSTEM, DEFAULTICONDIR, AppSystem.DefaultIconDir, INI_FILE);
		    EndDialog(hDlg, 0);
		    IniRead();
		    return TRUE;

		case IDINIT_BROWSE:
		    lpfnSelectDirDlgProc = (DLGPROC) MakeProcInstance(SelectDirDlgProc, hInst);
		    DialogBox(hInst, "SelectDirDlg", hDlg, lpfnSelectDirDlgProc);
		    FreeProcInstance((FARPROC) lpfnSelectDirDlgProc);
		    InvalidateRect(hDlg, NULL, TRUE);
		    UpdateWindow(hDlg);
		    if(bNewDir)
			{
			strcpy(AppSystem.DefaultIconDir, Directory);
			SetDlgItemText(hDlg, IDINIT_INIT, AppSystem.DefaultIconDir);
			bNewDir = FALSE;
			}
		    return TRUE;

		case IDINIT_CANCEL:
		    EndDialog(hDlg, 0);
		    return TRUE;
		}
	    break;
	}
    return FALSE;
    }
