/* Ownerb.h */
#include <ctl3d.h>

#define WM_APPBAR_RESTART	    (WM_USER+1001)

#define IDC_SCROLL		    101
#define IDC_CLOSEPROG		    102
#define IDC_BUTTONLOOK		    103
#define IDC_NOSOUND		    104
#define IDC_ICONS		    110
#define IDC_BUTTONS		    120
#define IDC_EDITS		    140
#define IDC_TEXTS		    150
#define IDC_RADIOS		    160
#define IDC_NEXT		    170

#define IDD_STAYINFRONT 	    200
#define IDD_QUICKEXIT		    201
#define IDD_CLOSEALL		    202
#define IDD_DEFAULT		    203
#define IDD_DOUBLECLICK		    204
#define IDD_BROWSE		    205
#define IDD_BIGBUTTONS		    206
#define IDD_TOP			    210
#define IDD_SCROLLTOP		    211
#define IDD_LEFT		    220
#define IDD_SCROLLLEFT		    221
#define IDD_BUTTONS		    230
#define IDD_SCROLLBUTTONS	    231
#define IDD_ROWS		    240
#define IDD_SCROLLROWS		    241
#define IDD_BORDER		    242
#define IDD_SCROLLBORDER	    243
#define IDD_HELP		    251
#define IDD_ABOUT		    252
#define IDD_EXITBUTTON		    260

#define IDINIT_INIT		    300
#define IDINIT_CANCEL		    301
#define IDINIT_OK		    302
#define IDINIT_BROWSE		    303

#define IDEXIT_NO		    400
#define IDEXIT_CANCEL		    401
#define IDEXIT_OK		    402
#define IDEXIT_RESTART		    403

#define IDEND_SHELL		    500
#define IDEND_LOAD		    501
#define IDEND_NONE		    502
#define IDEND_START		    503
#define IDEND_RESTART		    504
#define IDEND_EXIT		    505
#define IDEND_SAVE		    506
#define IDEND_OK		    507
#define IDEND_CANCEL		    508

#define IDDIR_OK		    600
#define IDDIR_CANCEL		    601
#define IDDIR_LIST		    602
#define IDDIR_PATH		    603
#define IDDIR_TEXT		    604

#define IDSOUND_OK		    700
#define IDSOUND_CANCEL		    701
#define IDSOUND_TEST		    702
#define IDSOUND_BROWSE		    703
#define IDSOUND_NONE		    704
#define IDSOUND_ENABLE		    705
#define IDSOUND_APPSTART	    706
#define IDSOUND_APPEXIT 	    707
#define IDSOUND_WINEXIT 	    708
#define IDSOUND_PROGSTART	    709
#define IDSOUND_PROGCLOSE	    710
#define IDSOUND_DROPFILE	    711
#define IDSOUND_ERROR		    712
#define IDSOUND_SOUNDDIR	    713
#define IDSOUND_HELP		    714

#define IDUPGRADE_YES		    801
#define IDUPGRADE_NO		    802
#define IDSAVE_YES		    811
#define IDSAVE_NO		    812
#define IDSAVE_PATH		    813
#define IDSAVE_BROWSE		    814
#define IDRESTART_YES		    821
#define IDRESTART_NO		    822

#define IDSHL_LOAD		    900
#define IDSHL_RUN		    901
#define IDSHL_SHELLGROUP	    902
#define IDSHL_SHELL		    903
#define IDSHL_BROWSE		    904
#define IDSHL_DEFAULT		    905
#define IDSHL_HELP		    906

#define INI_SYSTEM	"System"
#define INI_BUTTON	"Buttons"
#define INI_SOUND	"Sounds"
#define INI_SHELL	"Shell"
#define INI_FILE	"appbar.ini"

#define LEFT		"Left"
#define TOP		"Top"
#define COLUMNS		"Columns"
#define BUTTONS 	"Buttons"
#define BORDER		"Border"
#define QUICKEXIT	"QuickExit"
#define CLOSEALL	"CloseAll"
#define STAYINFRONT	"StayInFront"
#define EXITBUTTON	"ExitButton"
#define BIGBUTTONS	"BigButtons"
#define DOUBLECLICK	"DoubleClick"
#define INITIALIZED	"Initialized"
#define DEFAULTICONDIR	"DefaultIconDir"
#define SHELLGROUP	"ShellGroup"
#define OLDSHELL	"OldShell"

#define SOUNDENABLE	"EnableSound"
#define APPSTART	"AppBarStart"
#define APPEXIT 	"AppBarExit"
#define WINEXIT 	"WindowsExit"
#define PROGSTART	"ProgramStart"
#define PROGCLOSE	"ProgramClose"
#define DROPFILE	"DropFile"
#define ERRORMESSAGE	"ErrorMessage"
#define SOUNDDIR	"SoundDirectory"

#define LEFT_DEFAULT	    "-1"
#define TOP_DEFAULT	    "-1"
#define COLUMNS_DEFAULT	    "1"
#define BUTTONS_DEFAULT     "8"
#define QUICK_DEFAULT	    "0"
#define BORDER_DEFAULT	    "0"
#define CLOSEALL_DEFAULT    "1"
#define CLOSEPROG_DEFAULT   "1"
#define NOSOUND_DEFAULT     "0"
#define SHOWMODE_DEFAULT    "0"
#define STAYINFRONT_DEFAULT "0"
#define EXITBUTTON_DEFAULT  "1"
#define BIGBUTTONS_DEFAULT  "0"
#define DOUBLECLICK_DEFAULT "0"
#define INITIALIZED_DEFAULT "0"
#define ICONNUMBER_DEFAULT  "0"
#define BUTTONLOOK_DEFAULT  "0"
#define SHELLGROUP_DEFAULT  "startup.grp"

#define SOUNDENABLE_DEFAULT	"0"
#define APPSTART_DEFAULT	"<none>"
#define APPEXIT_DEFAULT		"<none>"
#define WINEXIT_DEFAULT		"<none>"
#define PROGSTART_DEFAULT	"<none>"
#define PROGCLOSE_DEFAULT	"<none>"
#define DROPFILE_DEFAULT	"<none>"
#define ERRORMESSAGE_DEFAULT	"<none>"


#define MAXFILECHARS	81
#define MAXDIGITS	5
#define MAXBORDER	15
#define NUMICONS	5
#define NUMEDITS	4
#define NUMBUTTONS	11
#define MAXAPPS 	48
#define MAXRES		1280
#define UP		1
#define DOWN		0
#define APPBARVERSION	400
#define APPBAR4		400

typedef enum {NOTALIVE = FALSE, ALIVE = TRUE} STATUS;

typedef struct {
	char	IcoName[MAXFILECHARS];
	char	ProgName[MAXFILECHARS];
	char	StartDir[MAXFILECHARS];
	char	Params[MAXFILECHARS];
	HWND	hWndApp;
	int	IconNumber;
	BOOL	ButtonLook;
	STATUS	ProgStatus;
	BOOL	Close;
	short	ShowMode;
	BOOL	NoSound;
	} APPBARBUTTONS;

typedef struct {
	short	Left;
	short	Top;
	int	Columns;
	int	Buttons;
	BOOL	CloseAll;
	BOOL	StayInFront;
	int	Initialized;
	BOOL	BigButtons;
	BOOL	DoubleClick;
	int	Border;
	char	DefaultIconDir[MAXFILECHARS];
	char	ShellGroup[8*MAXFILECHARS];
	} APPSYSTEM;

typedef struct {
	BOOL	EnableSound;
	char	AppBarStart[MAXFILECHARS];
	char	AppBarExit[MAXFILECHARS];
	char	WindowsExit[MAXFILECHARS];
	char	ProgramStart[MAXFILECHARS];
	char	ProgramClose[MAXFILECHARS];
	char	DropFile[MAXFILECHARS];
	char	ErrorMessage[MAXFILECHARS];
	char	SoundDirectory[MAXFILECHARS];
	} APPSOUND;

typedef enum {EXEFOCUS = 0, PARAMFOCUS = 1, DIRFOCUS = 2, ICONFOCUS = 3} FOCUS;
typedef enum {ICONFILES = 0, EXEFILES = 1, WAVEFILES = 2, GROUPFILES = 3} BROWSEFILES;

char szBuffer[256];
int temp;

#define WITHIN(val, min, max)	  (((temp=val) > max ? max : (temp < min) ? min : temp))
#define ONEORZERO(val)		  WITHIN(val, 0, 1)


extern APPBARBUTTONS AppButton[MAXAPPS], AppButtonDefault, AppButtonTemp;
extern APPSYSTEM     AppSystem, AppSystemNew;
extern APPSOUND      AppSound, AppSoundNew;
extern HWND	     hwndIcon[NUMICONS], hwndScroll, hwndEdit[NUMEDITS];
extern HWND	     hWnd, hwndButton[NUMBUTTONS], hwndText[NUMEDITS];
extern HWND	     hwndRadioButton[3], hwndCloseProg, hwndNext[2];
extern HWND	     hwndButtonLook, hwndNoSound;
extern HINSTANCE     hInst;
extern HICON	     hIcon[MAXAPPS], hIconTemp;
extern HBITMAP	     hAppSetup;
extern BOOL	     bSave, bCreate, bAlreadyShell;
extern BOOL	     bCurrentIcon[NUMICONS], bNewDir;
extern int	     iCurrent, iBlackIcon, iPrevBlackIcon;
extern int	     MaxIconNumber[MAXAPPS], cxChar, cyChar;
extern FOCUS	     nFocus;
extern FARPROC	     lpfnOldEdit[NUMEDITS];
extern char	     Directory[256], TempStr[256];

/* defined in appsetup.c */
long WINAPI MainWndProc(HWND, UINT, WPARAM, LPARAM);

/* defined in appedit.c */
long WINAPI EditProc(HWND, UINT, WPARAM, LPARAM);

/* defined in init.c */
extern BOOL InitFirstInstance(HINSTANCE);

/* defined in AppIni.c */
extern VOID PASCAL IniRead(VOID);
extern VOID PASCAL IniSave(VOID);

/* defined in AppChild.c */
extern VOID UpdateEditWindows(int iCurrent);
extern VOID UpdateRadioButtons(int iCurrentRB);
extern VOID UpdateCheckBoxes(int iCurrent);
extern VOID UpdateScrollIcons(int iCurrentIcon);
extern VOID UpdateNextButtons(int);
extern VOID CreateAllChildWindows(HWND hWnd, HINSTANCE hInst);
extern VOID Insert(VOID);
extern VOID Delete(VOID);
extern VOID MoveUp(VOID);
extern VOID MoveDown(VOID);
extern VOID Next(int i);

/* defined in AppTools.c */
extern VOID OkMsgBox(char *szCaption, char *szFormat, ...);
extern VOID ErrorMsgBox(char *szCaption, char *szFormat, ...);
extern VOID LoadIconFromFile(HICON *hIcon, int i);
extern HBRUSH SetColorLightGray(HWND, HDC);
extern HBRUSH SetColorStaticText(HWND, HDC);
extern VOID LoadExeIcon(HICON *hIcon, int iCurrent);
extern BOOL IsAppBarShell(VOID);
extern HWND GetAppBarWindow(VOID);

/* defined in appsys.c */
extern BOOL WINAPI SystemDlgProc(HWND, UINT, WPARAM, LPARAM);

/* defined in appshell.c */
extern BOOL WINAPI ShellDlgProc(HWND, UINT, WPARAM, LPARAM);

/* defined in appinit.c */
extern BOOL WINAPI InitDlgProc(HWND, UINT, WPARAM, LPARAM);

/* defined in append.c */
extern BOOL WINAPI InitEndDlgProc(HWND, UINT, WPARAM, LPARAM);

/* defined in appexit.c */
BOOL WINAPI ExitDlgProc(HWND, UINT, WPARAM, LPARAM);

/* defined in AppAbout.c */
extern BOOL WINAPI AboutDlgProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

/* defined in appgrade.c */
extern BOOL WINAPI UpgradeDlgProc(HWND, UINT, WPARAM, LPARAM);

/* defined in appsave.c */
extern BOOL WINAPI SaveDlgProc(HWND, UINT, WPARAM, LPARAM);

/* defined in appstart.c */
extern BOOL WINAPI RestartDlgProc(HWND, UINT, WPARAM, LPARAM);

/* defined in appbrows.c */
extern BOOL PASCAL BrowseFile(char *FileName, HWND hWndCommDlgParent, BROWSEFILES FileType);
extern BOOL WINAPI SelectDirDlgProc(HWND, UINT, WPARAM, LPARAM);
extern void UpdateListBox(HWND hDlg);
extern UINT GetListBoxIndex(HWND hDlg);
extern void FileErrorHandler(void);

/* defined in appsound.c */
extern BOOL WINAPI SoundDlgProc(HWND, UINT, WPARAM, LPARAM);

/*defined in AppBar.dll */
extern TEXTMETRIC WINAPI RetrieveTextMetrics(HWND hWnd);
extern void	  WINAPI DrawBitmap(HDC hDC, short x, short y, HBITMAP hBitmap);
extern APPSYSTEM  WINAPI ReadSystemIni(VOID);
extern APPSOUND   WINAPI ReadSoundIni(VOID);
extern VOID	  WINAPI SaveSystemIni(APPSYSTEM AppSystem);
extern VOID	  WINAPI SaveSoundIni(APPSOUND AppSound);
extern APPBARBUTTONS WINAPI ReadButtonIni(int i, LPSTR SectionName, LPSTR IniFile);
extern VOID WINAPI SaveButtonIni(APPBARBUTTONS AppButton, int i, LPSTR SectionName, LPSTR IniFile);
extern APPBARBUTTONS WINAPI InitButton(VOID);
extern VOID	  WINAPI ReadRunLoadIni(LPSTR run, LPSTR load);
extern VOID	  WINAPI SaveRunLoadIni(LPSTR run, LPSTR load);
