/*
    Ownerb.h
*/

#define IDC_SCROLL	101		 // child1 id
#define IDC_ICONS	102		 // child2,3,4,5 !!!
#define IDC_BUTTONS	106		 // child6,7,8,9 !!!
#define IDC_EDITS	110		 // child10, 11, 12 !!!
#define IDC_TEXTS	113		 // child13, 14, 15 !!!
#define IDC_RADIOS	116		 // child16, 17, 18 !!!
#define IDC_CLOSEPROG	119		 // child19
#define IDC_NEXT	120		 // child20, 21
#define IDC_BUTTONLOOK	123

#define IDD_STAYINFRONT 	    200
#define IDD_QUICKEXIT		    201
#define IDD_CLOSEALL		    202
#define IDD_DEFAULT		    203
#define IDD_DOUBLECLICK		    204
#define IDD_TOP			    210
#define IDD_SCROLLTOP		    211
#define IDD_LEFT		    220
#define IDD_SCROLLLEFT		    221
#define IDD_BUTTONS		    230
#define IDD_SCROLLBUTTONS	    231
#define IDD_ROWS		    240
#define IDD_SCROLLROWS		    241
#define IDD_SOUND		    242

#define IDINIT_INIT		    300
#define IDINIT_CANCEL		    301
#define IDINIT_OK		    302
#define IDINIT_BROWSE		    303

#define IDEXIT_NO		    400
#define IDEXIT_CANCEL		    401
#define IDEXIT_OK		    402

#define IDEND_SHELL		    500
#define IDEND_LOAD		    501
#define IDEND_NONE		    502
#define IDEND_START		    503
#define IDEND_RESTART		    504
#define IDEND_EXIT		    505
#define IDEND_SAVE		    506
#define IDEND_OK		    507
#define IDEND_CANCEL		    508

#define IDDIR_OK		    600
#define IDDIR_CANCEL		    601
#define IDDIR_LIST		    602
#define IDDIR_PATH		    603
#define IDDIR_TEXT		    604

#define IDSOUND_EVENTS		    701
#define IDSOUND_FILES		    702
#define IDSOUND_TEST		    703
#define IDSOUND_ENABLE		    705

#define INI_SYSTEM	"System"
#define INI_BUTTON	"Buttons"
#define INI_FILE	"appbar.ini"

#define LEFT		"Left"
#define TOP		"Top"
#define COLUMNS		"Columns"
#define BUTTONS 	"Buttons"
#define QUICKEXIT	"QuickExit"
#define CLOSEALL	"CloseAll"
#define DOUBLECLICK	"DoubleClick"
#define STAYINFRONT	"StayInFront"
#define INITIALIZED	"Initialized"
#define DEFAULTICONDIR	"DefaultIconDir"

#define LEFT_DEFAULT	    "-1"
#define TOP_DEFAULT	    "-1"
#define COLUMNS_DEFAULT	    "1"
#define BUTTONS_DEFAULT     "8"
#define QUICK_DEFAULT	    "0"
#define CLOSEALL_DEFAULT    "1"
#define DOUBLECLICK_DEFAULT "0"
#define CLOSEPROG_DEFAULT   "1"
#define SHOWMODE_DEFAULT    "0"
#define STAYINFRONT_DEFAULT "0"
#define INITIALIZED_DEFAULT "0"
#define ICONNUMBER_DEFAULT  "0"
#define BUTTONLOOK_DEFAULT  "0"

#define WINDOWS31	0x0310

#define MAXFILECHARS	70
#define MAXDIGITS	5
#define NUMICONS	4
#define NUMEDITS	3
#define MAXAPPS 	32
#define MAXRES		1280

typedef struct {
	char	IcoName[MAXFILECHARS];
	char	ProgName[MAXFILECHARS];
	char	StartDir[MAXFILECHARS];
	HWND	hWndApp;
	int	IconNumber;
	int	ButtonLook;
	int	ProgStatus;
	int	CloseProg;
	int	ShowMode;
	} APPBARBUTTONS;

typedef struct {
	short	Left;
	short	Top;
	int	Columns;
	int	Buttons;
	int	QuickExit;
	int	CloseAll;
	int	DoubleClick;
	int	StayInFront;
	int	Initialized;
	char	DefaultIconDir[MAXFILECHARS];
	} APPSYSTEM;

typedef enum {ICONFOCUS = 0, EXEFOCUS = 1, DIRFOCUS = 2} FOCUS;

char szBuffer[256];
extern APPBARBUTTONS AppButton[MAXAPPS];
extern APPSYSTEM     AppSystem, AppSystemNew;
extern HWND	     hwndIcon[NUMICONS], hwndScroll, hwndEdit[3], hwndButton[4];
extern HWND	     hWnd, hwndText[3], hwndRadioButton[3], hwndCloseProg;
extern HWND	     hwndNext[2], hwndButtonLook;
extern HINSTANCE     hInst;
extern HBITMAP	     hAppSetup;
extern BOOL	     bSave, bSaveButton[MAXAPPS], bCurrentIcon[NUMICONS], bNewDir;
extern int	     iCurrent, iBlackIcon, iPrevBlackIcon, MaxIconNumber[MAXAPPS];
extern int	     cxChar, cyChar;
extern FOCUS	     nFocus;
extern FARPROC	     lpfnOldEdit[NUMEDITS];
extern char	     Directory[256], TempStr[256];


/* defined in ownerb.c */
long WINAPI MainWndProc(HWND, UINT, WPARAM, LPARAM);

/* defined in appedit.c */
long WINAPI EditProc(HWND, UINT, WPARAM, LPARAM);

/* defined in init.c */
extern BOOL InitFirstInstance(HINSTANCE);

/* defined in border.c */
extern VOID InnerBorder(HDC hDC, RECT rect);

/* defined in AppTools.c */
extern VOID OkMsgBox(char *szCaption, char *szFormat, ...);
extern VOID ErrorMsgBox(char *szCaption, char *szFormat, ...);
extern VOID PASCAL IniRead(VOID);
extern VOID PASCAL IniSave(VOID);
extern VOID UpdateEditWindows(int iCurrent);
extern VOID UpdateRadioButtons(int iCurrentRB);
extern VOID UpdateScrollIcons(int iCurrentIcon);
extern VOID UpdateNextButtons(int);
extern VOID CreateAllChildWindows(HWND hWnd, HINSTANCE hInst);
extern HICON LoadIconFromFile(int i);
extern HBRUSH SetColorLightGray(HWND hWnd, HDC hDC);
extern TEXTMETRIC RetrieveTextMetrics(HWND hWnd);
extern void FileErrorHandler(void);

/* defined in appsys.c */
BOOL WINAPI SystemDlgProc(HWND, UINT, WPARAM, LPARAM);

/* defined in appinit.c */
BOOL WINAPI InitDlgProc(HWND, UINT, WPARAM, LPARAM);

/* defined in append.c */
BOOL WINAPI InitEndDlgProc(HWND, UINT, WPARAM, LPARAM);

/* defined in appexit.c */
BOOL WINAPI ExitDlgProc(HWND, UINT, WPARAM, LPARAM);

/* defined in appbrows.c */
BOOL PASCAL FileBrowse(FOCUS);
BOOL WINAPI SelectDirDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
void UpdateListBox(HWND hDlg);
UINT GetListBoxIndex(HWND hDlg);

/* defined in appsound.c */
BOOL WINAPI SoundDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
