#include <windows.h>
#include <windowsx.h>
#include <commdlg.h>
#include <stdlib.h>
#include "showjpg.h"
#include "ecjapi.h"

#define MIN(a,b) ((a) < (b) ? (a) : (b))

HANDLE WINAPI ECJ_Decode (LPSTR, WORD, LONG, ECJCB) ;
HPALETTE PASCAL NEAR MakeDIBPalette (LPBITMAPINFOHEADER) ;

long FAR PASCAL _export WndProc (HWND, UINT, UINT, LONG) ;
int  FAR PASCAL _export ECJ_CallBack (WORD, WORD, LONG) ;

char     szAppName [] = "ShowJPG" ;
HWND     hWnd ;
HPALETTE holdpal = NULL, hPalette = NULL;

int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
     {
     MSG         msg ;
     WNDCLASS    wndclass ;

     if (!hPrevInstance) 
          {
          wndclass.style         = CS_HREDRAW | CS_VREDRAW ;
          wndclass.lpfnWndProc   = WndProc ;
          wndclass.cbClsExtra    = 0 ;
          wndclass.cbWndExtra    = 0 ;
          wndclass.hInstance     = hInstance ;
          wndclass.hIcon         = NULL ;
          wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW) ;
          wndclass.hbrBackground = GetStockObject (WHITE_BRUSH) ;
          wndclass.lpszMenuName  = szAppName ;
          wndclass.lpszClassName = szAppName ;

          RegisterClass (&wndclass) ;
          }

     hWnd = CreateWindow (szAppName, "Show JPG using ECJ",
                          WS_OVERLAPPEDWINDOW,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          CW_USEDEFAULT, CW_USEDEFAULT,
                          NULL, NULL, hInstance, NULL) ;

     ShowWindow (hWnd, nCmdShow) ;
     UpdateWindow (hWnd) ;

     while (GetMessage (&msg, NULL, 0, 0))
          {
          TranslateMessage (&msg) ;
          DispatchMessage (&msg) ;
          }
     return msg.wParam ;
     }


BYTE huge * GetDibBits (LPBITMAPINFOHEADER lpbmih)
     {
     BYTE huge * pBits;
     DWORD dwNumColors;

     dwNumColors = lpbmih->biClrUsed ;

     if (dwNumColors == 0)
          if (lpbmih->biBitCount != 24)
               dwNumColors = 1L << lpbmih->biBitCount ;

     pBits = (BYTE huge *) lpbmih + (DWORD)lpbmih->biSize +
			   dwNumColors * sizeof(RGBQUAD);
     return pBits;
     }

int FAR PASCAL _export ECJ_CallBack (WORD mMsg, WORD wParam, LONG lParam)
     {
     char whatsup[80];
     switch (mMsg)
          {
          case ECJ_RESOLUTION: break;
          case ECJ_PROGRESS:
		switch (wParam)
		  {
		  case 0: wsprintf(whatsup, "%d%%", (int)lParam); break;
		  case 1: wsprintf(whatsup, "Making histogram"); break;
		  case 2: wsprintf(whatsup, "Remap %d%%", (int)lParam); break;
		  }
		SetWindowText(hWnd, whatsup);
		break;
          case ECJ_ERROR: break;
	  }
     return 0 ;
     }

long FAR PASCAL _export WndProc (HWND hwnd, UINT message, UINT wParam,
                                                          LONG lParam)
     {
     static char         szFileName  [_MAX_PATH],
                         szTitleName [_MAX_FNAME + _MAX_EXT] ;
     static char *       szFilter[] = { "JPG Files (*.jpg)","*.jpg","" } ;
     static HANDLE	 lpDib ;
     LPBITMAPINFOHEADER  lpbi;
     static OPENFILENAME ofn ;
     static short        cxClient, cyClient ;
     static WORD         wDisplay = IDM_ACTUAL ;
     HDC                 hdc ;
     HMENU               hMenu ;
     BYTE huge *         lpDibBits ;
     PAINTSTRUCT         ps ;
     short               cxDib, cyDib ;

     static FARPROC	 lpfnECJ_CallBack ;
     static char	 grey=0, half=0, auto_half=1, dither=0, two_pass=0 ;
     static int		 color_bits = 8 ;
     static int		 attrib ;

     switch (message)
          {
          case WM_CREATE:
	       {
     	       HANDLE	 hInstance;
               ofn.lStructSize       = sizeof (OPENFILENAME) ;
               ofn.hwndOwner         = hwnd ;
               ofn.lpstrFilter       = szFilter [0] ;
               ofn.lpstrFile         = szFileName ;
               ofn.nMaxFile          = _MAX_PATH ;
               ofn.lpstrFileTitle    = szTitleName ;
               ofn.nMaxFileTitle     = _MAX_FNAME + _MAX_EXT ;
               ofn.lpstrDefExt       = "jpg" ;

	       hInstance = ((LPCREATESTRUCT) lParam)->hInstance;
	       lpfnECJ_CallBack	= MakeProcInstance ((FARPROC) ECJ_CallBack,
						     hInstance);
               return 0 ;
	       }

          case WM_SIZE:
               cxClient = LOWORD (lParam) ;
               cyClient = HIWORD (lParam) ;
               return 0 ;

          case WM_COMMAND:
               hMenu = GetMenu (hwnd) ;

               switch (wParam)
                    {
                    case IDM_OPEN:
                         if (GetOpenFileName (&ofn))
                              {
                              if (lpDib != NULL)
                                   GlobalFree (lpDib) ;

			      if (grey) attrib |= ECJ_GRAY_ONLY;
			      if (auto_half) attrib |= ECJ_AUTO_HALF;
			      else if (half) attrib |= ECJ_HALF_SIZE;
			      if (two_pass) attrib |= ECJ_2_PASS;
			      if (dither) attrib |= ECJ_DITHER;
			      if (color_bits==24) attrib |= ECJ_24_BITS;

                              lpDib = ECJ_Decode (szFileName, attrib,
						  0L, lpfnECJ_CallBack);
                              if (lpDib == NULL)
                                   MessageBox (hwnd, szAppName,
                                               "Could not open JPG file",
                                               MB_ICONEXCLAMATION | MB_OK) ;

                              InvalidateRect (hwnd, NULL, TRUE) ;
                              }
                         return 0 ;

                    case IDM_ACTUAL:
                    case IDM_STRETCH:
                         CheckMenuItem (hMenu, wDisplay, MF_UNCHECKED) ;
                         wDisplay = wParam ;
                         CheckMenuItem (hMenu, wDisplay, MF_CHECKED) ;

                         InvalidateRect (hwnd, NULL, TRUE) ;
                         return 0 ;
                    }
               break ;

          case WM_PAINT:
               hdc = BeginPaint (hwnd, &ps) ;

               if (lpDib != NULL)
                    {
		    lpbi = (LPBITMAPINFOHEADER) GlobalLock(lpDib) ;

		    if (hPalette)
			{
			SelectPalette (hdc, holdpal, FALSE) ;
			DeleteObject (hPalette) ;
			}
                    hPalette = MakeDIBPalette (lpbi) ;
                    holdpal = SelectPalette (hdc, hPalette, FALSE) ;
                    RealizePalette (hdc) ;
			
                    lpDibBits = GetDibBits (lpbi) ;
                    cxDib     = lpbi->biWidth ;
                    cyDib     = lpbi->biHeight ;

                    SetStretchBltMode (hdc, COLORONCOLOR) ;

                    if (wDisplay == IDM_ACTUAL)
                         SetDIBitsToDevice (hdc, 0, 0, cxDib, cyDib, 0, 0,
                                            0, cyDib, (LPSTR) lpDibBits,
                                            (LPBITMAPINFO) lpbi,
                                            DIB_RGB_COLORS) ;

                    else
                         StretchDIBits (hdc, 0, 0, cxClient, cyClient,
                                        0, 0, cxDib, cyDib,
                                        (LPSTR) lpDibBits,
                                        (LPBITMAPINFO) lpbi,
                                        DIB_RGB_COLORS, SRCCOPY) ;
		    GlobalUnlock (lpDib);
                    }

               EndPaint (hwnd, &ps) ;
               return 0 ;

          case WM_DESTROY:
               if (lpDib != NULL)
                    GlobalFree (lpDib) ;
		hdc = GetDC(hwnd);
		if (hPalette)
			{
			SelectPalette(hdc,holdpal,FALSE);
			DeleteObject(hPalette);
			hPalette = NULL;
			}
		ReleaseDC(hwnd,hdc);

               PostQuitMessage (0) ;
               return 0 ;
          }
     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }


HPALETTE PASCAL NEAR MakeDIBPalette(LPBITMAPINFOHEADER lpInfo)
{
    NPLOGPALETTE npPal;
    RGBQUAD far *lpRGB;
    HPALETTE hLogPal; 
    WORD i;

    if (lpInfo->biClrUsed)
    {
	npPal = (NPLOGPALETTE)LocalAlloc(LMEM_FIXED, sizeof(LOGPALETTE) + 
				(WORD)lpInfo->biClrUsed * sizeof(PALETTEENTRY));
	if (!npPal)
	    return(FALSE);

	npPal->palVersion = 0x300;
        npPal->palNumEntries = (WORD)lpInfo->biClrUsed;

	lpRGB = (RGBQUAD FAR *)((LPSTR)lpInfo + lpInfo->biSize);

        for (i = 0; i < (WORD)lpInfo->biClrUsed; i++, lpRGB++)
	{
	    npPal->palPalEntry[i].peRed = lpRGB->rgbRed;
	    npPal->palPalEntry[i].peGreen = lpRGB->rgbGreen;
	    npPal->palPalEntry[i].peBlue = lpRGB->rgbBlue;
	    npPal->palPalEntry[i].peFlags = 0;
	}

	hLogPal = CreatePalette((LPLOGPALETTE)npPal);
	LocalFree((HANDLE)npPal);
	return(hLogPal);
    }

    else
	return(GetStockObject(DEFAULT_PALETTE));
}
