function [Y] = reshape( X, m, n)
%Y=reshape( X, m, n)
%Reshapes matrix X to an m by n size. X must contain m*n elements

%       S.Halevy 7/31/92
%       Copyright (c) 1992 by the MathWizards

if (nargin ~= 3)
   error('reshape needs 3 arguments (A,m,n)');
end

if (prod(size(X)) ~= m*n)
   error('X does not have m*n elements.');
end
Y = zeros(m,n);
Y(:) = X;
return
