/********************************************************************\
*  Julie Solon							     *
*  Microsoft Developer Support                                       *
*  Copyright (c) 1992, 1993 Microsoft Corporation                    *
*                                                                    *
*  Comments:                                                         *
*                                                                    *
*  Functions:							     *
*                                                                    *
*								     *
\********************************************************************/


/*********************  Header Files  *********************/

#include <windows.h>
#include <string.h>
#include "client.h"


/**********************  Defines  *************************/

#define BUFSIZE 512

/*********************  Prototypes  ***********************/

LRESULT WINAPI MainWndProc( HWND, UINT, WPARAM, LPARAM );
LRESULT WINAPI AboutDlgProc( HWND, UINT, WPARAM, LPARAM );

/*******************  Global Variables ********************/

HANDLE ghInstance;


/********************************************************************\
*  Function: int PASCAL WinMain(HINSTANCE, HINSTANCE, LPSTR, int)    *
*                                                                    *
*   Purpose: Initializes Application                                 *
*                                                                    *
*  Comments: Standard template                                       *
*                                                                    *
*                                                                    *
\********************************************************************/


int PASCAL WinMain( HINSTANCE hInstance,
		    HINSTANCE hPrevInstance,
		    LPSTR lpszCmdLine,
		    int nCmdShow )
{
   WNDCLASS wc;
   MSG msg;
   HWND hWnd;

   if( !hPrevInstance ) {
      wc.lpszClassName = "ClientClass";
      wc.lpfnWndProc = MainWndProc;
      wc.style = CS_OWNDC | CS_VREDRAW | CS_HREDRAW;
      wc.hInstance = hInstance;
      wc.hIcon = LoadIcon( NULL, IDI_APPLICATION );
      wc.hCursor = LoadCursor( NULL, IDC_ARROW );
      wc.hbrBackground = (HBRUSH)( COLOR_WINDOW+1 );
      wc.lpszMenuName = "ClientMenu";
      wc.cbClsExtra = 0;
      wc.cbWndExtra = 0;

      RegisterClass( &wc );
   }

   ghInstance = hInstance;

   hWnd = CreateWindow( "ClientClass",
			"Client Application",
                        WS_OVERLAPPEDWINDOW|WS_HSCROLL|WS_VSCROLL,
                        0,
                        0,
                        CW_USEDEFAULT,
                        CW_USEDEFAULT,
                        NULL,
                        NULL,
                        hInstance,
                        NULL
                      );

   ShowWindow( hWnd, nCmdShow );

   while( GetMessage( &msg, NULL, 0, 0 ) ) {
      TranslateMessage( &msg );
      DispatchMessage( &msg );
   }

   return msg.wParam;
}


/********************************************************************\
* Function: LRESULT CALLBACK MainWndProc(HWND, UINT, WPARAM, LPARAM) *
*                                                                    *
*  Purpose: Processes Application Messages                           *
*                                                                    *
* Comments: The following messages are processed                     *
*                                                                    *
*           WM_CREATE                                                *
*           WM_HSCROLL                                               *
*           WM_VSCROLL                                               *
*           WM_KEYDOWN                                               *
*           WM_PAINT                                                 *
*           WM_COMMAND                                               *
*           WM_DESTROY                                               *
*                                                                    *
*                                                                    *
\********************************************************************/


LRESULT CALLBACK MainWndProc( HWND hWnd, UINT msg, WPARAM wParam,
   LPARAM lParam )
{
   PAINTSTRUCT ps;
   HDC hDC;
   HANDLE hPipe;
   DWORD dwMode, dwBytes;
   static char Buffer[BUFSIZE];
   char ErrorBuf[80];

   switch( msg ) {

/**************************************************************\
*     WM_CREATE:					       *
\**************************************************************/

      case WM_CREATE:
         strcpy( Buffer, "" );
	 break;

/**************************************************************\
*     WM_PAINT: 					       *
\**************************************************************/

      case WM_PAINT:
         hDC = BeginPaint( hWnd, &ps );

         TextOut( hDC, 10, 10, Buffer, strlen( Buffer ) );

	 EndPaint( hWnd, &ps );
         break;

/**************************************************************\
*     WM_COMMAND:					       *
\**************************************************************/

      case WM_COMMAND:
         switch( wParam ) {
	    case IDM_CONNECT:
#ifdef WIN32
	       hPipe = CreateFile( "//julieso/pipe/TestPipe",
                          GENERIC_READ,
                          FILE_SHARE_READ,
                          NULL,
                          OPEN_EXISTING,
                          0,
                          NULL
                       );

               if( hPipe == INVALID_HANDLE_VALUE ) {
                  wsprintf( ErrorBuf, "%d", GetLastError() );
                  MessageBox( hWnd, ErrorBuf, "CreateFile()", MB_OK );
                  break;
               }
               dwMode = PIPE_READMODE_MESSAGE;
               SetNamedPipeHandleState( hPipe,
                  &dwMode,
                  NULL,
                  NULL
               );
               ReadFile( hPipe,
                  Buffer,
                  BUFSIZE,
                  &dwBytes,
                  NULL
	       );
	       CloseHandle( hPipe );

#else
{
               OFSTRUCT Info;

	       hPipe = OpenFile( "\\\\julieso\\pipe\\TestPipe",
		  &Info,
		  OF_READ | OF_SHARE_DENY_NONE
	       );
	       if( hPipe == HFILE_ERROR ) {
		  MessageBox( hWnd, "File not opened", "OpenFile()", MB_OK );
		  break;
	       }
	       _lread( hPipe, Buffer, BUFSIZE );
               _lclose( hPipe );
}
#endif
	       InvalidateRect( hWnd, NULL, TRUE );
               break;

	    case IDM_ABOUT:
               DialogBox( ghInstance, "AboutDlg", hWnd, (DLGPROC)  
                             AboutDlgProc );
               break;
         }
         break;

/**************************************************************\
*     WM_DESTROY: PostQuitMessage() is called                  *
\**************************************************************/

      case WM_DESTROY:
         PostQuitMessage( 0 );
         break;

/**************************************************************\
*     Let the default window proc handle all other messages    *
\**************************************************************/

      default:
         return( DefWindowProc( hWnd, msg, wParam, lParam ));
   }

   return 0;
}

/********************************************************************\
* Function: LRESULT CALLBACK AboutDlgProc(HWND, UINT, WPARAM, LPARAM)*
*                                                                    *
*  Purpose: Processes "About" Dialog Box Messages                    *
*                                                                    *
* Comments: The Dialog Box is displayed when the user selects        *
*           Help.About.                                              *
*                                                                    *
\********************************************************************/


LRESULT CALLBACK AboutDlgProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
   switch( uMsg ) {
      case WM_INITDIALOG:
         return TRUE;
      case WM_COMMAND:
         switch( wParam ) {
            case IDOK:
               EndDialog( hDlg, TRUE );
               return TRUE;
         }
      break;
   }

   return FALSE;
}
