///////////////////////////////////////////////////////////////////////////
// C3DDlg.cpp
// implements ctl3d.dll functions 
// 12/20/93 Eddie McCreary
///////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"
#include "3ddlg.h"

#include <string.h>

#ifdef WIN32
#include <winver.h>
#else
#include <ver.h>
#endif

#include "ctl3d.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


C3DDlg::C3DDlg(UINT nIDTemplate,CWnd* pParentWnd) : CDialog(nIDTemplate,pParentWnd)
{
 
}

C3DDlg::C3DDlg() : CDialog()
{
}

BOOL C3DDlg::OnInitDialog()
{
 CDialog::OnInitDialog();
 CenterWindow(GetDesktopWindow());
 
 Ctl3dSubclassDlg(m_hWnd,CTL3D_ALL);
 return TRUE;
}

void C3DDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CAboutDlg)
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(C3DDlg, CDialog)
    //{{AFX_MSG_MAP(C3DDlg)
    ON_WM_CTLCOLOR()
    //}}AFX_MSG_MAP
    ON_MESSAGE(WM_SETTEXT,OnNCSetText)
    ON_MESSAGE(WM_DLGBORDER,OnDlgBorder)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////

LRESULT C3DDlg::OnNCSetText(WPARAM wParam, LPARAM lParam)
{
 ::SetWindowLong(m_hWnd,DWL_MSGRESULT,
    Ctl3dDlgFramePaint(m_hWnd,WM_SETTEXT,wParam,lParam));
 return TRUE;
}

BOOL C3DDlg::OnNcActivate(BOOL bActive)
{
 ::SetWindowLong(m_hWnd,DWL_MSGRESULT,
    Ctl3dDlgFramePaint(m_hWnd,WM_NCACTIVATE,(WPARAM)bActive,0L));
 return TRUE;
}
void C3DDlg::OnNcPaint()
{
 ::SetWindowLong(m_hWnd,DWL_MSGRESULT,
    Ctl3dDlgFramePaint(m_hWnd,WM_NCPAINT,0,0L));
}

LRESULT C3DDlg::OnDlgBorder(WPARAM wParam, LPARAM lParam)
{ 
 wParam = wParam; // to get rid of warning
 *(int FAR*)(lParam) = CTL3D_BORDER;
 return 0;
}

/////////////////////////////////////////////////////////////////////////////

HBRUSH C3DDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
 CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
 return Ctl3dCtlColor((HDC)pDC->m_hDC,
  (LONG)MAKELONG((HWND)pWnd->m_hWnd,nCtlColor));
}

