/*
** TabDlg DLL
** Copyright (c) 1994 Edward McCreary.
** All rights reserved.
**
** Redistribution and use in source and binary forms are freely permitted
** provided that the above copyright notice and attibution and date of work
** and this paragraph are duplicated in all such forms.
** THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
** WARRANTIES OF MERCHANTIBILILTY AND FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef TABDLG_H
#define TABDLG_H

#ifdef __cplusplus
extern "C" {
#endif

typedef struct tagTagTemplate
{
 LPCSTR lpDlgTemplate; /* dialog template for tag */
 LPCSTR lpTitle;    /* null terminated title for tag */
} TAGTEMPLATE;

/*
** 
** call this from WM_INITDIALOG to create tabs
** hDlg handle of parent dialog box
** hInst instance handle of module where tab templates are located
** wFrameID control ID of frame to use for tabs
** lpTemplates array of TAGTEMPLATE structures 
** nNumTemplates number of entries in lpTemplates
**
*/

BOOL WINAPI BuildTabs(HWND hDlg,HINSTANCE hInst, UINT wFrameID, 
    const TAGTEMPLATE FAR *lpTemplates, int nNumTemplates);

/*
**
** Set nTabID to be the top tab.  0 based index into lpTemplates
** parameter of BuildTabs
**
*/                         
                         
BOOL WINAPI  SetTopTab(HWND hDlg, int nTabID);


/*
**
** set tab styles, you must force a repaint if not
** called from WM_INITDIALOG
**
*/
void WINAPI  SetTabStyle(HWND hDlg, DWORD dwStyle);

/*
**
** styles for SetTabStyle
**
*/
#define TAB_SHADOWTEXT  0x0001

#ifdef __cplusplus
}
#endif


#endif /* TABDLG_H */