unit ListPlus;

{
Description:
	This Unit creates a Subclassed listbox that enables two more features:
		1. Moving an item in the listbox;
		2. Moving an item from the listbox to an other listbox

		The variable MODE is used to determine whether the dialog enables feature 1, 2 or both.
		In addition move/drag can be in copy mode: original item isn't deleted.
		=> See mod_xxxx constant declaration for explanation.

	Five cursor handles must be inited in the main app. These cursors are use by the listbox
	and must be valid. The Main app must free them is they were non-system.
	You may use, distribute and modify the five cursors given in the listplus.rc file.
	You may also use other cursors as well.


Acknowledgement:
    	 
This code is based on John A. Grant code for the first feature.

The second feature is my own implementation. Copy mode too.

Bugs were removed thanks to Lothar Rausch.


Please Feel free to distribute it as well as you want. You may, but DO NOT HAVE TO, acknowlegde
the designers.

YOU CAN'T ask money for any part of this product.
This code can be implemented in commercial products or shareware products
BUT NO EXTRA MONEY CAN BE ASKED FOR THE FEATURES PROVIDED BY THIS CODE.

IT'S FREEWARE.
}

interface

uses winprocs, wintypes, strings, wobjects, win31;

const
	dm_no    = 0;
	dm_yes   = 2;
	dm_maybe = 1;

	len_str1 = 200;

	mod_move     = 1; {Move: cut, paste within listbox}
	mod_movecopy = 2; {Copy: copy, paste within listbox}
	mod_allmove  = 3; {Both: ctrl key pressed is copy}
	mod_drag     = 4; {Drag: cut, paste between listboxes}
	mod_dragcopy = 8; {Copy: copy, paste between listboxes}
	mod_alldrag  = 12;{Both: ctrl key pressed is copy}
	mod_mask     = 15;
	mod_copy     = 2;
	mod_scroll   = 16; {This mode forces scroll when move mode is disabled: who needs it??}
  mod_notify   = 32; {This mode send a notify message to the parent window}
	mod_external = 64; {This mode allows drag&drop to listboxes not owned by the parent window}

	len_class = 200;

	lbn_addstring = $401; {A string have been added, sent to the parent}
  lbn_delstring = $402; {A string have been removed}

	{If user moves strings withing listbox, no user message is sent since a lbn_selchange is
	already sent by the listbox defproc}

  {Extra Bonus: TEdit redef}

  edi_comma  = 1; {comma allowed}
	edi_period = 2; {period allowed}
  edi_signed = 4; {Signed entry allowed (1st char is a minus, plus not allowed!)}
	edi_hex		 = 16; {Hexa allowed}
	edi_caps   = 32; {Forces entry to uppercaps otherwise lowercap (Hex only!)}

	idc_interdit    = 100;
	Idc_Drag        = 101;
	Idc_Dragcopy    = 102;
	idc_drop        = 103;
	idc_dropcopy    = 104;


var
	HInterdit,
	HDrag, HDragCopy,	HDrop, HDropCopy: HCursor;
  ExitSave: Pointer;

	{Shared cursor: must be loaded and disposed by
  		 main app}

type

	PLis = ^TLis;
	TLis = object(TListBox)
		dragmode: byte;
		startpt: Tpoint;
    savedC: HCursor;
		vfrom, vto: integer;
		movemode, dropmode: byte;
		ModeScroll, Externe, notify: boolean;
  {New methods}
		function CopyIt(mode: byte): boolean;
		procedure MoveItem;
    procedure TransfertItem(HWind: HWnd);
	{Subclassed message processing methods}
		procedure WMLButtonDown(var Msg: TMessage); virtual wm_first + wm_lButtonDown;
		procedure WMLButtonUp(var Msg: TMessage); virtual wm_first + wm_lButtonUp;
		procedure WMMouseMove(var Msg: TMessage); virtual wm_first + wm_MouseMove;
		procedure WMKeyDown(var Msg: TMessage); virtual wm_first + wm_Keydown;
		procedure WMKeyup(var Msg: TMessage); virtual wm_first + wm_KeyUp;
	{Subclassed methods}
		constructor Init(AParent: PWindowsObject; AnId: Integer; X,Y,W,H: Integer; usermode: byte);
		constructor InitResource(AParent: PWindowsObject; ResourceId: Integer; usermode: byte);
		end;

	PNumEdi = ^TNumEdi;
	TNumEdi = object(TEdit)
		comma, period, signed, hex, caps: boolean;
	{Subclassed message processing methods}
		procedure WMChar(var msg: TMessage); virtual wm_first + wm_char;
	{Subclassed methods}
		constructor Init(AParent: PWindowsObject; AnId: Integer; ATitle: PChar;
						 				 X,Y,W,H: Integer; ATextLen: integer; usermode: byte);
		constructor InitResource(AParent: PWindowsObject; ResourceId: Integer;
										 ATextLen: integer; usermode: byte);
		end;



implementation

{-Renaming functions-

function GetClassName1(Wnd: HWnd; ClassName: PChar; MaxCount: Integer): Integer;
begin
	GetClassName1:=GetClassName(Wnd,ClassName,MaxCount);
end;


{---------TLis-------------------}

procedure TLis.WMLButtonDown(var Msg: TMessage);
var
{	str1: array[0..10] of char;}
	pt: TPoint;
	msg2: TMessage;
begin
	pt.x:=integer(msg.lparamlo);
	pt.y:=integer(msg.lparamhi);
	TListBox.DefWndProc(msg);
	msg2:=msg;
  msg2.message:=WM_LButtonUp;
	TListBox.DefWndProc(msg2);
	vfrom:=GetSelIndex;
	if vfrom<0 then vfrom:=-1
	else begin
		startpt:=pt;
		SetCapture(HWindow);
		dragmode:=dm_maybe;
		end;
	vto:=-1;
	if (movemode<>0) or ModeScroll then TListBox.DefWndProc(Msg);
end;

procedure TLis.WMLButtonUp(var Msg: TMessage);
var
	pt: TPoint;
	msg2: TMessage;
	class: array[0..len_class] of char;
  HWind: HWnd;
begin
	pt.x:=integer(msg.lparamlo);
	pt.y:=integer(msg.lparamhi);
	if dragmode<>dm_no then begin
		releasecapture;
		SetCursor(savedc);
		if dragmode=dm_yes then begin
			ClientToScreen(HWindow,pt);
			Hwind:=WindowFromPoint(pt);
			if HWind=HWindow then begin
				vto:=GetSelIndex;
				if vto<0 then vto:=-1;
				end
			else begin
      	if dropmode<>0 then
				if (Getparent(HWind)=Getparent(HWindow)) or externe then
				if WinProcs.GetClassName(HWind,Class,len_class)>0 then begin
					if StrComp(Class,'ListBox')=0 then begin
						TransfertItem(HWind);
						end;
					end;
        end;
			end;
		dragmode:=dm_no;
		if (movemode <>0) and (vfrom<>-1) and (vto<>-1)
						and (vfrom<>vto) and (vfrom<>vto-1) then
			MoveItem;
		end;
	TListBox.DefWndProc(Msg);
end;

procedure TLis.WMMouseMove(var Msg: TMessage);
var
	str1: array[0..10] of char;
	pt: TPoint;
	msg2: TMessage;
	class: array[0..len_class] of char;
	HWind: HWnd;
  InsideLB: boolean;
begin
	pt.x:=integer(msg.lparamlo);
	pt.y:=integer(msg.lparamhi);
  InsideLB:=true;
	if dragmode=dm_maybe then begin
		if (startpt.x<>pt.x) or (startpt.y<>pt.y)then begin
			dragmode:=dm_yes;
			savedc:=GetCursor;
			end;
		end
	else if dragmode=dm_yes then begin
		ClientToScreen(HWindow,pt);
		HWind:=WindowFromPoint(pt);
		if HWind=HWindow then begin
			if movemode<>0 then begin
				if copyit(movemode) then
					SetCursor(HDragCopy)
				else
					SetCursor(HDrag);
				end
			else
				SetCursor(HInterdit);
			end
		else begin
    	InsideLB:=false;
			if ((Getparent(HWind)<>Getparent(HWindow)) and not externe) then
				SetCursor(HInterdit)
			else begin
				if(WinProcs.GetClassName(HWind,Class,len_class)=0) or (dropmode=0) then
					SetCursor(HInterdit)
				else begin
					if StrComp(Class,'ListBox')=0 then begin
						if copyit(dropmode) then
							SetCursor(HDropCopy)
						else
							SetCursor(HDrop);
						end
					else
						SetCursor(HInterdit);
					end;
	      end;
			end;
		end;
	if InsideLB then TListBox.DefWndProc(Msg);
end;

procedure TLis.moveItem;
var
	Str1: array[0..len_str1] of char;
  copying: boolean;
begin
	if GetString(Str1,vfrom)<0 then exit;
	if not copyit(movemode) then	if DeleteString(vfrom)<0 then exit;
	InsertString(str1,vto);
	if not notify then exit;
	if copyit(movemode) then
		SendMessage(GetParent(HWindow),wm_command,GetID,makelong(HWindow,lbn_AddString));
end;

procedure TLis.TransfertItem(Hwind: HWnd);
{Transfert the selected item to the listbox HWind}
var
	Str1: array[0..len_str1] of char;
	copying: boolean;
begin
	if GetString(Str1,vfrom)<0 then exit;
	if not copyit(dropmode) then	if DeleteString(vfrom)<0 then exit;
	SendMessage(Hwind,lb_AddString,0,Longint(@str1));
  if not notify then exit;
	if not copyit(movemode) then
		SendMessage(GetParent(HWindow),wm_command,GetID,makelong(HWindow,lbn_DelString));
	SendMessage(GetParent(HWind),wm_command,GetDlgCtrlID(HWind),makelong(HWindow,lbn_AddString));
end;

function TLis.CopyIt(mode: byte): boolean;
{ This function check is it must be copied or not depending on mode and vk_control state}
begin
	if mode=3 then
		 copyit:=GetKeyState(vk_control)<0
	else
		copyit:=mode=mod_copy;
end;

procedure TLis.WMKeyDown(var Msg: TMessage); 
{If ctrl key is pressed then chage Hdrop to HdropCopy or HDrag to Hdragcopy (if enabled)}
begin
	if msg.wparam=vk_control then begin
		if (GetCursor=HDrop) and (dropmode=3) then SetCursor(HDropCopy)
		else
			if (GetCursor=HDrag) and (movemode=3) then SetCursor(HDragCopy);
		end
  else TListBox.DefWndProc(msg);
end;

procedure TLis.WMKeyup(var Msg: TMessage);
{If ctrl key is released then chage HdropCopy to Hdrop or HDragCopy to Hdrag (if enabled)}
begin
	if msg.wparam=vk_control then begin
		if (GetCursor=HDropCopy) and (dropmode=3) then SetCursor(HDrop)
		else
			if (GetCursor=HDragCopy) and (movemode=3) then SetCursor(HDrag);
		end
  else TListBox.DefWndProc(msg);
end;


constructor TLis.Init(AParent: PWindowsObject; AnId: Integer; X,Y,W,H: Integer; usermode:byte);
begin
	TListBox.Init(Aparent,AnId,X,Y,W,H);
	dragmode:=dm_no;
	vfrom:=-1;
	vto:=-1;
	if usermode and mod_mask=0 then begin
		movemode:=mod_move;
		dropmode:=0;
		end
	else begin
		movemode:=usermode and 3;
		dropmode:=(usermode div 4) and 3;
		end;
	ModeScroll:=usermode and mod_scroll<>0;
	externe:=usermode and mod_external<>0;
	notify:=usermode and mod_notify<>0;
end;

constructor TLis.InitResource(AParent: PWindowsObject; ResourceId: Integer; usermode: byte);
begin
	TListBox.InitResource(Aparent,ResourceId);
	dragmode:=0;
	vfrom:=-1;
	vto:=-1;
	if usermode and mod_mask=0 then begin
		movemode:=mod_move;
		dropmode:=0;
		end
	else begin
		movemode:=usermode and 3;
		dropmode:=(usermode div 4) and 3;
    end;
	ModeScroll:=(usermode and mod_scroll)<>0;
	externe:=(usermode and mod_external)<>0;
	notify:=usermode and mod_notify<>0;
end;

{---------TNumEdi-------------------}

procedure TNumEdi.WMChar(var msg: TMessage);
var
	Num: array[0..30] of char;
	st,en: integer; 
begin
	GetText(Num,30);
	case msg.wparam of
		$2E: begin
			if not period then exit;
			if StrLen(Num)>0 then
				if StrScan(Num,'.')<>nil then exit;
			end;
		$2C: begin
			if not comma then exit;
			if StrLen(Num)>0 then
				if StrScan(Num,',')<>nil then exit;
			end;
		$2D: begin
			GetSelection(st,en);
			if st>0 then exit;
			if Num[0]='-' then exit;
      end;
		$41..$46: begin
			if not hex then exit;
			if not caps then inc(msg.wparam,32);
      end;
		 $61..$66: begin
		 if not hex then exit;
			if caps then dec(msg.wparam,32);
      end;
		$30..$39: ;
		vk_back: ;
		else exit;
    end;
	TEdit.DefWndProc(msg);
end;


constructor TNumEdi.Init(AParent: PWindowsObject; AnId: Integer; ATitle: PChar;
										 X,Y,W,H: Integer; ATextLen: integer; usermode: byte);
begin
	TEdit.Init(Aparent,AnId,ATitle,X,Y,W,H, ATextLen, false);
  comma:=usermode and edi_comma<>0;
	period:=usermode and edi_period<>0;
	signed:=usermode and edi_signed<>0;
	hex:=usermode and edi_hex<>0;
	caps:=usermode and edi_caps<>0;
end;

constructor TNumEdi.InitResource(AParent: PWindowsObject; ResourceId: Integer;
										 ATextLen: integer; usermode: byte);

begin
	TEdit.InitResource(Aparent,ResourceId,ATextLen);
	comma:=usermode and edi_comma<>0;
	period:=usermode and edi_period<>0;
	signed:=usermode and edi_signed<>0;
	hex:=usermode and edi_hex<>0;
	caps:=usermode and edi_caps<>0;
end;

Procedure ListPlusExit; far;
begin
	exitproc:=Exitsave;
	DestroyCursor(HInterdit);
	DestroyCursor(HDrag);
	DestroyCursor(HDragCopy);
	DestroyCursor(HDrop);
	DestroyCursor(HDropCopy);
end;

begin
	ExitSave:= ExitProc;
	ExitProc:=@ListPLusExit;
	HDrag:=LoadCursor(HInstance, PChar(idc_drag));
	HDrop:=LoadCursor(HInstance, PChar(idc_drop));
	HDragCopy:=LoadCursor(HInstance, PChar(idc_dragCopy));
	HDropCopy:=LoadCursor(HInstance, PChar(idc_dropCopy));
	HInterdit:=LoadCursor(HInstance, PChar(idc_interdit));
end.