{ Program:   DlgTest
  Version:   1.30
  Purpose:   demonstrates tDialogWindow as modeless Dialog Windows and
             MDI child windows.
             For a simpler demo of tDialogWindows as MDI children see file MinMdi.Pas
  Features:  - creates a standard Dialog from BorDlg resource
             - creates a BorDlg from standard resource
             - creates Dialog as is
             - demonstrates the use of "non-standard" MDI child styles
               under Windows 3.1
  Uses:      BWCC.DLL, CTL3D.DLL and BIVBX10.DLL if present.

  Developer: Peter Sawatzki (ps)
             Buchenhof 3, D58091 Hagen, Germany
 CompuServe: 100031,3002

  Date:     Author:
  04/22/92  ps       initial release
  07/25/92  ps/jwp   added Scroller demo
  08/01/92  ps       fixed some bugs, added modal dialog demo
  08/30/92  ps       add MDI/non-MDI menu item
  06/29/93  ps       modified for new tAdvApplication object
  10/01/93  ps       modified for CTL3D
  02/14/93  ps       modified for VBX

  Copyright (c) 1994 Peter Sawatzki. All Rights Reserved.
}
program DlgTest;
{$A+,B-,F-,G+,I-,K+,P-,Q-,R-,S-,T-,V-,X+}
{$R DlgTest.Res}
Uses
  Win31,
{$IfDef Debug} Debug, {$EndIf}
  WinTypes,
  WinProcs,
  Strings,
  Objects,
  oWindows,
  oDialogs,
  DynLink,
  Vbx,
{$IfDef PsPrint} PsPrint,
{$Else}          oPrinter, {$EndIf}
{$IfDef Custom}  CustomWn, {$EndIf}
{$IfDef PScc}    PSccTest, {$EndIf}
{$IfDef DEW}     DEWTest,  {$EndIf}
  DialogWn;
{$i DlgTest.Inc}
Const
  VBXvalidation: tVbxValidation = cVbxValidation;
  ProgName = 'DlgTest';
  AppCtl: (MdiApp,NormApp,SwitchApp,TermApp) = MdiApp; {we want a Mdi app first}
  GlobalPosRect: tRect = (left: -1);

{-------------------- the tDialogWindow supporting an owner draw listbox }
Type
  pOwnerLBWindow = ^tOwnerLBWindow;
  tOwnerLBWindow = Object(tDialogWindow)
    Procedure SetupWindow; Virtual;
    Procedure wmMeasureItem (Var Msg: tMessage); Virtual wm_First+wm_MeasureItem;
    Procedure wmDrawItem (Var Msg: tMessage);    Virtual wm_First+wm_DrawItem;
    Procedure wmModalClone (Var Msg: tMessage);  Virtual id_First+$100;
  End;

Procedure tOwnerLBWindow.SetupWindow;
  Procedure AddLb (aString: pChar);
  Begin
    SendDlgItemMessage(hWindow,10, lb_AddString, 0, LongInt(aString))
  End;
Begin
  Inherited SetupWindow;
  AddLb('This is the'#13'Asterisk Icon symbol loaded'#13+
        'with ''LoadIcon(idi_Asterisk)''');
  AddLb('Exclamation');
  AddLb('Hand');
  AddLb('Question');
End;

Procedure tOwnerLBWindow.wmMeasureItem (Var Msg: tMessage);
Var
  aDC: hDC;
  OldFont: hFont;
  CalcRect: tRect;
Begin With pMeasureItemStruct(Msg.lParam)^ Do Begin
  aDC:= GetDC(hWindow);
  OldFont:= SelectObject(aDC, DialogAttr.Font);
  itemHeight:= GetSystemMetrics (SM_CYICON);
  DrawText(aDC, Pointer(itemData), -1, CalcRect, dt_CalcRect);
  With CalcRect Do If itemHeight<bottom-top Then
    itemHeight:= bottom-top;
  SelectObject(aDC, OldFont);
  ReleaseDC(hWindow, aDC)
End End;

Procedure tOwnerLBWindow.wmDrawItem (Var Msg: tMessage);
Var
  Tmp: Array[0..150] Of Char;
  anIcon: hIcon;
  TextRect: tRect;
  OldBkColor: tColorRef;

    Procedure DrawRedFrame (aDC: hDC; aRect: tRect);
    Var
      OldPen: hPen;
    Begin With aRect Do Begin
      OldPen:= SelectObject(aDC, CreatePen(ps_Dot, 1, $80));
      MoveTo(aDC, left, top); LineTo(aDC, right-1,top); LineTo(aDC,right-1,bottom-1);
      LineTo(aDC,left,bottom-1); LineTo(aDC, left,top);
      DeleteObject(SelectObject(aDC, OldPen))
    End End;

Begin With pDrawItemStruct(Msg.lParam)^ Do Begin
  Case itemID Of
    0: anIcon:= LoadIcon(0, idi_Asterisk);
    1: anIcon:= LoadIcon(0, idi_Exclamation);
    2: anIcon:= LoadIcon(0, idi_Hand);
    3: anIcon:= LoadIcon(0, idi_Question);
  Else
    anIcon:= 0
  End;
  SendDlgItemMessage(hWindow,10{id ListBox},lb_GetText,itemID,LongInt(@Tmp));
  If itemState And ODS_Selected=0 Then
    OldBkColor:= SetBkColor(hDC, GetSysColor(Color_Window)) {not selected}
  Else
    If itemState And ODS_Focus=0 Then
      OldBkColor:= SetBkColor(hDC, GetSysColor(Color_BtnFace)) {selected without focus}
    Else
      OldBkColor:= SetBkColor(hDC, GetSysColor(Color_HighLight)); {selected with focus}
  ExtTextOut(hDC, 0, 0, Eto_Opaque, @rcItem, Nil, 0, Nil);
  TextRect:= rcItem; Inc(TextRect.left, GetSystemMetrics(sm_CxIcon)+5);
  DrawText(hDC, Tmp, -1, TextRect, dt_Left Or dt_VCenter);
  If anIcon<>0 Then
    DrawIcon(hDC, rcItem.left, rcItem.top, anIcon);
  SetBkColor(hDC, OldBkColor);

  If itemState And ODS_Focus<>0 Then
    DrawRedFrame(hDC, rcItem) {draw the focus rect}
End End;

Procedure tOwnerLBWindow.wmModalClone (Var Msg: tMessage);
Begin
  ExecDialogWindow(New(pOwnerLBWindow, Init(@Self, DialogAttr.Name)))
End;

{-------------------- a Control Window for tDialogWindow's properties}
Type
  pControlWindow = ^tControlWindow;
  tControlWindow = Object(tDialogWindow)
    Procedure SetupWindow; Virtual;
    Procedure Ok (Var Msg: tMessage); Virtual id_First+id_Ok;
  End;

Const
  Map3D: Array[iCtl3D_Buttons..iCtl3D_StaticFrames] Of Word =
    (Ctl3D_Buttons, Ctl3D_ListBoxes,   Ctl3D_Edits,
     Ctl3D_Combos,  Ctl3D_StaticTexts, Ctl3D_StaticFrames);

Procedure tControlWindow.SetupWindow;
Var
  toCheck: Integer;
  pd: pDialogWindow;
  aRect: tRect;
Begin
  Inherited SetupWindow;
  pd:= pDialogWindow(Parent);
  GetWindowRect(pd^.GetItemHandle(iControl), aRect);
  MoveWindow(hWindow, aRect.right, aRect.top, Attr.w, Attr.h, False);
  toCheck:= iUseOrg;
  If pd^.DlgStyle And ForceStd<>0 Then
    toCheck:= iForceStd
  Else If pd^.DlgStyle And ForceBor<>0 Then
    toCheck:= iForceBor;
  CheckRadioButton(hWindow, iUseOrg, iForceBor, toCheck);
  CheckDlgButton(hWindow, iForceGrayBk, Word(pd^.DlgStyle And ForceGrayBk<>0));
  CheckDlgButton(hWindow, iDlgBold,     Word(pd^.DialogAttr.FontWeight=fw_Bold));
  CheckDlgButton(hWindow, iEnableCtl3D, Word(pd^.DlgStyle And EnableCtl3D<>0));
  For toCheck:= Low(Map3D) To High(Map3D) Do
    CheckDlgButton(hWindow, toCheck, Word(pd^.Ctl3DStyle And Map3D[toCheck]<>0))
End;

Procedure tControlWindow.Ok (Var Msg: tMessage);
Var
  NewStyle, New3DStyle: LongInt;
  NewFontWeight: Integer;
  pd: pDialogWindow;
  i: Integer;
  Procedure SetLong (Var aLong: LongInt; Bitmask: LongInt; aBool: Boolean);
  Begin
    If aBool Then aLong:= aLong Or Bitmask Else aLong:= aLong And Not Bitmask
  End;
Begin
  pd:= pDialogWindow(Parent);
  NewStyle:= pd^.DlgStyle;
  New3DStyle:= pd^.Ctl3DStyle;
  NewFontWeight:= pd^.DialogAttr.FontWeight;

  SetLong(NewStyle, ForceStd, IsDlgButtonChecked(hWindow, iForceStd)=1);
  SetLong(NewStyle, ForceBor, IsDlgButtonChecked(hWindow, iForceBor)=1);
  SetLong(NewStyle, ForceGrayBk, IsDlgButtonChecked(hWindow, iForceGrayBk)=1);
  SetLong(NewStyle, EnableCtl3D, IsDlgButtonChecked(hWindow, iEnableCtl3D)=1);
  If IsDlgButtonChecked(hWindow, iDlgBold)=1 Then
    NewFontWeight:= fw_Bold
  Else
    NewFontWeight:= fw_Normal;

  For i:= iCtl3D_Buttons To iCtl3D_StaticFrames Do
    SetLong(New3DStyle, Map3D[i], IsDlgButtonChecked(hWindow, i)=1);
  If (NewStyle<>pd^.DlgStyle) Or (New3DStyle<>pd^.Ctl3DStyle)
  Or (NewFontWeight<>pd^.DialogAttr.FontWeight) Then Begin
    pd^.DlgStyle:= NewStyle;
    pd^.Ctl3DStyle:= New3DStyle;
    pd^.DialogAttr.FontWeight:= NewFontWeight;
    EndDlg(id_Ok)
  End Else
    EndDlg(id_Cancel)
End;

{------- a tDialogWindow descendant with scrollers and a property button}
Type
  pJanusWindow = ^tJanusWindow;
  tJanusWindow = Object(tDialogWindow)
    Constructor Init (aParent: pWindowsObject; aName: pChar);
    Procedure Control (Var Msg: tMessage); Virtual id_First+$100;
    Procedure UpdateDialog; Virtual;
  End;

Constructor tJanusWindow.Init (aParent: pWindowsObject; aName: pChar);
Begin
  Inherited Init(aParent, aName);
  Attr.Style:= Attr.Style Or ws_VScroll Or ws_HScroll;
  Scroller:= New(pScroller, Init(@Self,1,1,0,0))
End;

Procedure tJanusWindow.Control (Var Msg: tMessage);
Var
  Cmd: Integer;
Begin
  If ExecDialogWindow(New(pControlWindow, Init(@Self, pChar(iControlDlg))))=id_Ok Then Begin
    DefStyle:= DlgStyle;
    DefCtl3DStyle:= Ctl3DStyle;
    DefFontWeight:= DialogAttr.FontWeight;
    If Assigned(ModalCode) Then Cmd:= cModal Else Cmd:= cModeless;
    With GlobalPosRect, Attr Do Begin
      left:= X; top:= Y;
      right:= X+w; bottom:= y+h
    End;
    PostMessage(Parent^.hWindow, wm_Command, Cmd, 0);
    If Assigned(ModalCode) Then
      ModalCode^:= id_Cancel
    Else
      PostMessage(hWindow, wm_Close, 0, 0)
  End
End;

Procedure tJanusWindow.UpdateDialog;
Begin
  Inherited UpdateDialog;
  {-check for the special case where we want to place our dialog where the previous was}
  With GlobalPosRect, Attr Do
  If left>=0 Then Begin
    x:= left;
    y:= top;
    w:= right-left;
    h:= bottom-top;
    left:= -1
  End
End;

{--------------------------- VBX sample window}
Type
  pVbxWindow = ^tVbxWindow;
  tVbxWindow = Object(tDialogWindow)
    Constructor Init (aParent: pWindowsObject; aName: pChar);
  End;

Constructor tVbxWindow.Init (aParent: pWindowsObject; aName: pChar);
Var
  aCtl: pVbxControl;
Begin
  Inherited Init(aParent, aName);
  aCtl:= New(pVbxControl, InitResource(@Self, 101));
End;

Type
  pAboutWindow = ^tAboutWindow;
  tAboutWindow = Object(tDialogWindow)
    Procedure SetupWindow; Virtual;
  End;

Procedure tAboutWindow.SetupWindow;
Var
  i: Integer;
Begin
  Inherited SetupWindow;
  For i:= 10 To 15 Do
    CheckDlgButton(hWindow, i, Word(True))
End;

Procedure SelectPrinter (aParent: pWindowsObject);
Var
  aPrinter: pPrinter;
Begin
  aPrinter:= New(pPrinter, Init);
  If Not Assigned(aPrinter) Then
    Exit;
  aPrinter^.Setup(aParent);
  Dispose(aPrinter, Done)
End;

Procedure Help;
Var
  FileNameLen: Integer;
  FileName: Array[0..67] Of Char;
  I: integer;
Begin
  FileNameLen:= GetModuleFileName(System.hInstance, FileName, SizeOf(FileName));
  I:= FileNameLen-1;
  While (I<>0) And Not (Filename[I] In ['\',':']) Do
    Dec(I);
  Inc(I);
  If I+13<=SizeOf(FileName) Then
    StrCopy(@FileName[I], 'janusw.hlp')
  Else
    StrCopy(@FileName[I], '?');
  WinHelp(0, FileName, Help_Contents, 0)
End;

Const
  Ck: Array[0..1] Of Integer = (mf_ByCommand+mf_UnChecked, mf_ByCommand+mf_Checked);

{-all code for the window creation is in the Dispatch function:
  Dispatch is called from tWindow or tMdiWindow depending if this is an
  'normal' or a MDI application
}
Function Dispatch (aParent: pWindow; Var Msg: tMessage): Boolean;
Var
  aWin: pWindow;
Begin
  aWin:= Nil;
  Case Msg.wParam Of
    cAbout: aWin:= New(pAboutWindow,Init (aParent, pChar(iAboutDlg)));
    cHelp:  Help;
    cSwitchMdi: Begin
      AppCtl:= SwitchApp;
      GetWindowRect(aParent^.hWindow, GlobalPosRect);
      PostMessage(Application^.MainWindow^.hWindow,wm_Close,0,0)
    End;
    cSelectPrinter:  SelectPrinter(aParent);
  Else If Hi(Msg.wParam) In [Hi(cModeless), Hi(cModal)] Then
  Case Lo(Msg.wParam) Of
    cJanus:   aWin:= New(pJanusWindow,  Init(aParent, pChar(iJanusDlg)));
    cVbx:     aWin:= New(pVbxWindow, Init(aParent, pChar(iVbxDlg)));
    cUnusual: aWin:= New(pOwnerLBWindow,Init(aParent, pChar(iUnusualDlg)));
  {$IfDef DEW}
    cDEW:     aWin:= New(pCustomer, Init(aParent, 'CUSTOMER'));
  {$EndIf}
  {$IfDef PScc}
    cPscc:    aWin:= New(pPSccWindow,Init(aParent, 'PSccTest')); {PSccTest Dialog}
  {$EndIf}
  {$IfDef Custom}
    cCustTF:  aWin:= New(pCustomWindow, InitTest(aParent, 'ThickFrame',
                          ws_MinimizeBox+ws_MaximizeBox+ws_ThickFrame+ws_Caption+ws_SysMenu, 1, 1));
    cCustCF:  aWin:= New(pCustomWindow, InitTest(aParent, 'Caption',   ws_Caption+ws_SysMenu, 1, 1));
    cCustDF:  aWin:= New(pCustomWindow, InitTest(aParent, 'DlgFrame',  ws_DlgFrame+ws_SysMenu, 1, 1));
    cCustTF2: aWin:= New(pCustomWindow, InitTest(aParent, 'ThickFrame',
                          ws_MinimizeBox+ws_MaximizeBox+ws_ThickFrame+ws_Caption+ws_SysMenu, 5, 8));
    cCustCF2: aWin:= New(pCustomWindow, InitTest(aParent, 'Caption',   ws_Caption+ws_SysMenu, 3, 3));
    cCustDF2: aWin:= New(pCustomWindow, InitTest(aParent, 'DlgFrame',  ws_DlgFrame+ws_SysMenu, 2, 2));
  {$EndIf}
  {$IfDef Test}
    cTest:  aWin:= New(pDialogWindow, Init(aParent, pChar(iControlDlg)));
    cTest2: aWin:= New(pDialogWindow, InitCustom(aParent, pChar(iControlDlg), ForceBor));
  {$EndIf}
  End End;
  If aWin<>Nil Then
    If Hi(Msg.wParam)=Hi(cModeless) Then
      Application^.MakeWindow(aWin)          {modeless}
    Else
      ExecDialogWindow(pDialogWindow(aWin)); {modal}
  Dispatch:= Assigned(aWin)
End;

{$IfDef DEW}
Procedure AddDEWEntries (aMenu: hMenu);
Var
  aSubMenu: hMenu;
  i: Integer;
Begin
  For i:= 0 To 0 Do Begin
    aSubMenu:= GetSubMenu(aMenu,i+1);
    AppendMenu(aSubMenu,mf_Separator,0,Nil);
    AppendMenu(aSubMenu,mf_String,cModeless+(i Shl 8)+cDEW,'D&EW demo dialog')
  End
End;
{$EndIf}

{$IfDef PScc}
Procedure AddPSccEntries (aMenu: hMenu);
Var
  aSubMenu: hMenu;
  i: Integer;
Begin
  For i:= 0 To 1 Do Begin
    aSubMenu:= GetSubMenu(aMenu,i+1);
    AppendMenu(aSubMenu,mf_Separator,0,Nil);
    AppendMenu(aSubMenu,mf_String,cModeless+(i Shl 8)+cPscc,'PScc')
  End
End;
{$EndIf}

{$IfDef Custom}
Procedure AddCustomEntries (aMenu: hMenu);
Var
  aSubMenu: hMenu;
  i: Integer;
Begin
  aSubMenu:= GetSubMenu(aMenu,1);
  AppendMenu(aSubMenu,mf_Separator,0,Nil);
  AppendMenu(aSubMenu,mf_String,cModeless+cCustTF ,'Custom Window (ThickFrame/small)');
  AppendMenu(aSubMenu,mf_String,cModeless+cCustCF ,'Custom Window (Caption/small)');
  AppendMenu(aSubMenu,mf_String,cModeless+cCustDF ,'Custom Window (DlgFrame/small)');
  AppendMenu(aSubMenu,mf_String,cModeless+cCustTF2,'Custom Window (ThickFrame/large)');
  AppendMenu(aSubMenu,mf_String,cModeless+cCustCF2,'Custom Window (Caption/large)');
  AppendMenu(aSubMenu,mf_String,cModeless+cCustDF2,'Custom Window (DlgFrame/large)');
End;
{$EndIf}

{$IfDef Test}
Procedure AddTestEntries (aMenu: hMenu);
Var
  aSubMenu: hMenu;
  i: Integer;
Begin
  For i:= 0 To 1 Do Begin
    aSubMenu:= GetSubMenu(aMenu,i+1);
    AppendMenu(aSubMenu,mf_Separator,0,Nil);
    AppendMenu(aSubMenu,mf_String,cModeless+(i Shl 8)+cTest ,'TestDlg (as is)');
    AppendMenu(aSubMenu,mf_String,cModeless+(i Shl 8)+cTest2,'TestDlg (as Bor)')
  End
End;
{$EndIf}

Procedure PlaceWindow (aWnd: hWnd);
Var
  aRect: tRect;
  width, height: Integer;
Begin
  GetWindowRect(GetDeskTopWindow, aRect);
  If GlobalPosRect.left>=0 Then With GlobalPosRect Do Begin
    MoveWindow(aWnd, left, top, right-left, bottom-top, False);
    left:= -1
  End Else With aRect Do Begin
    width:= (right-left) Div 4 * 3;
    height:= (bottom-top) Div 4 * 3;
    Inc(left,(right-left) Div 8);
    Inc(top, (bottom-top) Div 8);
    MoveWindow(aWnd,left, top, width, height, False)
  End
End;

{-------------------- the MDI part }

Type
  paMDIWindow = ^aMdiWindow;
  aMDIWindow = object(tAdvMdiWindow)
    Procedure SetupWindow; Virtual;
    Procedure InitClientWindow; Virtual;
    Procedure DefCommandProc (Var Msg: tMessage); Virtual;
  End;

Procedure aMDIWindow.SetupWindow;
Begin
  Inherited SetupWindow;
{$IfDef DEW}    AddDEWEntries(Attr.Menu);    {$EndIf}
{$IfDef PScc}   AddPSccEntries(Attr.Menu);   {$EndIf}
{$IfDef Custom} AddCustomEntries(Attr.Menu); {$EndIf}
{$IfDef Test}   AddTestEntries(Attr.Menu);   {$EndIf}
  CheckMenuItem(Attr.Menu, cMdiAll, Ck[GetWindowLong(ClientWnd^.hWindow, gwl_Style) And MdiS_AllChildStyles]);
  PlaceWindow(hWindow)
End;

Procedure aMDIWindow.InitClientWindow;
Begin
 ClientWnd:= New(pMdiClient, Init(@Self));
 With ClientWnd^.Attr do
   Style:= Style Or ws_VScroll Or ws_HScroll Or MdiS_AllChildStyles
End;

Procedure aMDIWindow.DefCommandProc (Var Msg: tMessage);
Var
  MdiS: LongInt;
Begin
  If Not Dispatch(@Self, Msg) Then
  Case Msg.wParam Of
    cMdiAll: Begin
            MdiS:= GetWindowLong(ClientWnd^.hWindow,gwl_Style) Xor MdiS_AllChildStyles;
            SetWindowLong(ClientWnd^.hWindow, gwl_Style, MdiS);
            CheckMenuItem(Attr.Menu, cMdiAll, Ck[MdiS And 1])
          End;
  Else
    Inherited DefCommandProc(Msg)
  End
End;

{-------------------- the normal window part }

Type
  paWindow = ^aWindow;
  aWindow = Object(tWindow)
    Constructor Init (aParent: pWindowsObject; aTitle: pChar);
    Procedure SetupWindow; Virtual;
    Procedure GetWindowClass(var WndClass: TWndClass); virtual;
    Procedure DefCommandProc (Var Msg: tMessage); Virtual;
  End;

Constructor aWindow.Init (aParent: pWindowsObject; aTitle: pChar);
Var
  i: Word;
Begin
  Inherited Init(aParent, aTitle);
  Attr.Menu:= LoadMenu(hInstance,pChar(iMainMnu));
  For i:= cm_ArrangeIcons To cm_CloseChildren Do
    EnableMenuItem(Attr.Menu,i,mf_ByCommand+mf_Disabled+mf_Grayed);
  ModifyMenu(Attr.Menu, cSwitchMdi, mf_ByCommand, cSwitchMdi, '&Switch to MDI mode');
  EnableMenuItem(Attr.Menu,cMdiAll,mf_ByCommand+mf_Disabled+mf_Grayed); {MdiS_AllChildStyles}
{$IfDef DEW}    AddDEWEntries(Attr.Menu);    {$EndIf}
{$IfDef PScc}   AddPSccEntries(Attr.Menu);   {$EndIf}
{$IfDef Custom} AddCustomEntries(Attr.Menu); {$EndIf}
{$IfDef Test}   AddTestEntries(Attr.Menu);   {$EndIf}
End;

Procedure aWindow.SetupWindow;
Begin
  Inherited SetupWindow;
  PlaceWindow(hWindow)
End;

Procedure aWindow.GetWindowClass(var WndClass: TWndClass);
Begin
  Inherited GetWindowClass(WndClass);
  WndClass.lpszMenuName:= Nil
End;

Procedure aWindow.DefCommandProc (Var Msg: tMessage);
Begin
  If Not Dispatch(@Self,Msg) Then
    Inherited DefCommandProc(Msg)
End;

{-------------------- the Application part }
Type
  tProgApp = Object(tAdvApplication)
    MdiStyle: Boolean;
    Constructor Init (aName: pChar; asMdi: Boolean);
    Destructor Done; Virtual;
    Procedure InitMainWindow; Virtual;
  End;

Constructor tProgApp.Init (aName: pChar; asMdi: Boolean);
Begin
  MdiStyle:= asMdi;
  Inherited Init(aName)
End;

Destructor tProgApp.Done;
Begin
  If AppCtl=SwitchApp Then
    If MdiStyle Then
      AppCtl:= NormApp
    Else
      AppCtl:= MdiApp
  Else
    AppCtl:= TermApp;
  Inherited Done
End;

Procedure tProgApp.InitMainWindow;
Begin
  If MdiStyle Then
    MainWindow:= New(paMDIWindow, Init(ProgName, LoadMenu(hInstance, pChar(iMainMnu))))
  Else
    MainWindow:= New(paWindow, Init(Nil, ProgName));
  hAccTable:= LoadAccelerators(hInstance, pChar(iMainAcc))
End;

Var
  App: tProgApp;
Begin
  RegisterVBX(VBXvalidation);
  DefStyle:= OrgStyle;
  With App Do
    Repeat
      Init(ProgName,AppCtl=MdiApp);
      Run;
      Done
    Until AppCtl=TermApp
End.
