VERSION 2.00
Begin Form frmAdvancedApplications 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Select Desired Disk/File Information"
   ClientHeight    =   4575
   ClientLeft      =   1710
   ClientTop       =   1875
   ClientWidth     =   8325
   Height          =   4980
   Icon            =   0
   Left            =   1650
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4575
   ScaleWidth      =   8325
   Top             =   1530
   Width           =   8445
   Begin CommandButton cmdSystem 
      Caption         =   "S&ystem..."
      Height          =   375
      Left            =   120
      TabIndex        =   27
      Top             =   3120
      Width           =   1575
   End
   Begin CommandButton cmdCreateDir 
      Caption         =   "Di&rectory..."
      Height          =   375
      Left            =   2280
      TabIndex        =   10
      Top             =   4080
      Width           =   1815
   End
   Begin CommandButton cmdPathWord 
      Caption         =   "S&plit Word..."
      Height          =   375
      Left            =   2280
      TabIndex        =   9
      Top             =   3600
      Width           =   1815
   End
   Begin CommandButton cmdSearchList 
      Caption         =   "&Search..."
      Height          =   375
      Left            =   2280
      TabIndex        =   8
      Top             =   3120
      Width           =   1815
   End
   Begin CommandButton cmdCopy 
      Caption         =   "&Move/Copy File..."
      Height          =   375
      Left            =   2280
      TabIndex        =   7
      Top             =   2640
      Width           =   1815
   End
   Begin CommandButton cmdAbout 
      Caption         =   "&About..."
      Height          =   375
      Left            =   120
      TabIndex        =   6
      Top             =   3600
      Width           =   1575
   End
   Begin CommandButton cmdSample 
      Caption         =   "&?"
      Height          =   375
      Left            =   1320
      TabIndex        =   5
      Top             =   2640
      Width           =   375
   End
   Begin CommandButton cmdHelp 
      Caption         =   "&Help"
      Height          =   375
      Left            =   120
      TabIndex        =   4
      Top             =   2640
      Width           =   1095
   End
   Begin PictureBox picDrive 
      BackColor       =   &H00C0C0C0&
      Height          =   2415
      Left            =   120
      ScaleHeight     =   2385
      ScaleWidth      =   3945
      TabIndex        =   23
      Top             =   120
      Width           =   3975
      Begin CommandButton cmdDiskSpace 
         Caption         =   "&Free Space"
         Height          =   375
         Index           =   0
         Left            =   120
         TabIndex        =   1
         Top             =   120
         Width           =   1455
      End
      Begin ComboBox cboDrive 
         Height          =   300
         Left            =   1440
         Style           =   2  'Dropdown List
         TabIndex        =   0
         Top             =   1920
         Width           =   2415
      End
      Begin CommandButton cmdDiskSpace 
         Caption         =   "&Total Space"
         Height          =   375
         Index           =   1
         Left            =   120
         TabIndex        =   2
         Top             =   600
         Width           =   1455
      End
      Begin CommandButton cmdClear 
         Caption         =   "&Clear Labels"
         Height          =   375
         Left            =   1680
         TabIndex        =   3
         Top             =   1080
         Width           =   2175
      End
      Begin Label lblFreeSpace 
         BackColor       =   &H00C0C0C0&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Disk Free Space"
         Height          =   255
         Left            =   1680
         TabIndex        =   16
         Top             =   190
         Width           =   2175
      End
      Begin Label lblTotalSpace 
         BackColor       =   &H00C0C0C0&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Disk Total Space"
         Height          =   255
         Left            =   1680
         TabIndex        =   19
         Top             =   670
         Width           =   2175
      End
      Begin Label Label3 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Test Drive:"
         Height          =   255
         Left            =   120
         TabIndex        =   24
         Top             =   1950
         Width           =   1215
      End
      Begin Line Line2 
         X1              =   120
         X2              =   3840
         Y1              =   1680
         Y2              =   1680
      End
   End
   Begin PictureBox picFileMode 
      BackColor       =   &H00C0C0C0&
      Height          =   3975
      Left            =   4200
      ScaleHeight     =   3945
      ScaleWidth      =   3945
      TabIndex        =   20
      Top             =   120
      Width           =   3975
      Begin CommandButton cmdCheckFile 
         Caption         =   "C&heck File"
         Height          =   375
         Left            =   1320
         TabIndex        =   17
         Top             =   3360
         Width           =   1455
      End
      Begin TextBox txtFile 
         Height          =   285
         Left            =   1080
         TabIndex        =   11
         Text            =   "Text1"
         Top             =   120
         Width           =   2775
      End
      Begin Frame Frame1 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Select File Mode"
         Height          =   1815
         Left            =   120
         TabIndex        =   21
         Top             =   480
         Width           =   3735
         Begin OptionButton optFileMode 
            BackColor       =   &H00C0C0C0&
            Caption         =   "Check for Read/Write Permission."
            Height          =   255
            Index           =   3
            Left            =   120
            TabIndex        =   15
            Top             =   1440
            Width           =   3495
         End
         Begin OptionButton optFileMode 
            BackColor       =   &H00C0C0C0&
            Caption         =   "Check for Read Permission."
            Height          =   255
            Index           =   2
            Left            =   120
            TabIndex        =   14
            Top             =   1080
            Width           =   3015
         End
         Begin OptionButton optFileMode 
            BackColor       =   &H00C0C0C0&
            Caption         =   "Check for Write Permission."
            Height          =   255
            Index           =   1
            Left            =   120
            TabIndex        =   13
            Top             =   720
            Width           =   3015
         End
         Begin OptionButton optFileMode 
            BackColor       =   &H00C0C0C0&
            Caption         =   "Existance Check."
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   12
            Top             =   360
            Width           =   3015
         End
      End
      Begin Label Label2 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Status:"
         Height          =   735
         Left            =   120
         TabIndex        =   26
         Top             =   2400
         Width           =   735
      End
      Begin Label lblFileMode 
         Alignment       =   2  'Center
         BackColor       =   &H00C0C0C0&
         BorderStyle     =   1  'Fixed Single
         Height          =   735
         Left            =   840
         TabIndex        =   25
         Top             =   2400
         Width           =   3015
      End
      Begin Label Label1 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Dir or File:"
         Height          =   255
         Left            =   120
         TabIndex        =   22
         Top             =   170
         Width           =   975
      End
   End
   Begin CommandButton cmdExit 
      Caption         =   "E&xit"
      Height          =   375
      Left            =   120
      TabIndex        =   18
      Top             =   4080
      Width           =   1575
   End
End
'''''''''''''''''''''''''''''''''''''''''''''''''
' Copyright by Advanced Applications 1994 - 1995
' All rights reserved
'
'''''''''''''''''''''''''''''''''''''''''''''''''
Dim nFileMode As Integer        ' Used by Drive Check Type

Sub cmdAbout_Click ()
    nReturn% = AboutBox()
End Sub

Sub cmdCheckFile_Click ()
    strDrive$ = Trim(txtFile.Text)      ' Must be a String
    
    ''''''''''''''''''''''''''''''''''''''''''''''
    ' Check the Drive.
    '
    bDriveCheck = DriveCheck(strDrive$, nFileMode)
	
    If bDriveCheck = FILE_EXISTS Then
	strMessage$ = "Directory/File Exists"
	strMessage$ = strMessage$ & Chr$(KEY_RETURN)
	strMessage$ = strMessage$ & "and/or"
	strMessage$ = strMessage$ & Chr$(KEY_RETURN)
	strMessage$ = strMessage$ & "Mode Is Accessible."
    Else
	strMessage$ = "Directory/File Does Not Exist"
	strMessage$ = strMessage$ & Chr$(KEY_RETURN)
	strMessage$ = strMessage$ & "and/or"
	strMessage$ = strMessage$ & Chr$(KEY_RETURN)
	strMessage$ = strMessage$ & "Mode Is Not Accessible."
    End If

    ' Display the message
    lblFileMode.Caption = strMessage$
End Sub

Sub cmdClear_Click ()
    lblFreeSpace.Caption = ""       ' Clears Labels
    lblTotalSpace.Caption = ""
End Sub

Sub cmdCopy_Click ()
    frmMove.Show MODAL
End Sub

Sub cmdCreateDir_Click ()
    frmCreateDir.Show MODAL
End Sub

Sub cmdDiskSpace_Click (Index As Integer)
    If cboDrive.Text = "Default" Then
	nDrive% = 0
    Else
	strDrive$ = Left(cboDrive.Text, 1)
	nDrive% = Asc(strDrive$) - 64
    End If

    Select Case Index
	Case FREE_SPACE
	    lblFreeSpace.Caption = ""
	    DoEvents
	    
	    Screen.MousePointer = HOURGLASS

	    ''''''''''''''''''''''''''''''''''''''''''''
	    ' Find the Free Space for the Selected Drive
	    '
	    lDriveInfo = DiskFreeSpace(nDrive%)

	    Screen.MousePointer = DEFAULT
	    
	    ' Did an error occur?
	    If lDriveInfo <= DISK_FULL And lDriveInfo >= FILE_NOT_FOUND Then
		DisplayError lDriveInfo
		Exit Sub
	    End If
	    
	    ' Display the Information
	    lblFreeSpace.Caption = lDriveInfo & " Bytes"

	Case TOTAL_SPACE
	    lblTotalSpace.Caption = ""
	    DoEvents

	    Screen.MousePointer = HOURGLASS
	    
	    ''''''''''''''''''''''''''''''''''''''''''''
	    ' Find the Total Space for the Selected Drive
	    '
	    lDriveInfo = DiskTotalSpace(nDrive%)
	    
	    Screen.MousePointer = DEFAULT
	    
	    ' Did an error occur?
	    If lDriveInfo <= DISK_FULL And lDriveInfo >= FILE_NOT_FOUND Then
		DisplayError lDriveInfo
		Exit Sub
	    End If

	    ' Display the information
	    lblTotalSpace.Caption = lDriveInfo & " Bytes"
    End Select
End Sub

Sub cmdExit_Click ()
    End
End Sub

Sub cmdHelp_Click ()
     ' Run the Advanced Application Disk Help File
     strHelp = "winhelp " & App.Path & "\ADVDISK.HLP"
     X = Shell(strHelp, 1)
End Sub

Sub cmdPathWord_Click ()
    frmPathWord.Show MODAL
End Sub

Sub cmdSample_Click ()
    SendKeys "{F1}", True       ' Force Help to Samples
End Sub

Sub cmdSearchList_Click ()
    szBuffer$ = String(255, 0)

    strPath$ = "C:\*.*"

    nLength% = SearchList(strPath$, szBuffer$)
    
    If nLength% = 0 Then
	MsgBox "Search Item not returned", , "Search List Return Error"
	Exit Sub
    End If

    strWord$ = Left$(szBuffer$, nLength%)
    MsgBox "Search Item Returned: " & strWord$, , "Search List Return Error"
End Sub

Sub cmdSystem_Click ()
    frmOperations.Show MODAL
End Sub

Sub Form_Load ()
    Left = (Screen.Width - Width) / 2   ' Center form horizontally.
    Top = (Screen.Height - Height) / 2  ' Center form vertically.

    lblFreeSpace.Caption = ""           ' Clear labels
    lblTotalSpace.Caption = ""
    txtFile.Text = ""                   ' Clear Text

    nFileMode = EXISTANCE_CHECK         ' Default Value
    optFileMode(0).Value = True

    ' Find the system drives and fill the Drive Combo Box
    ' Starting with "Drive A" to "Drive Z".
    cboDrive.Clear
    cboDrive.AddItem "Default"
    For I% = 0 To 25
	nDrive% = DriveType(I%)
	
	If nDrive% <> DRIVE_UNDETERMINED And nDrive% <> DRIVE_NOT_VALID Then
	    If nDrive% < 10 Then
		nCompress% = nDrive%
	    Else
		nCompress% = nDrive% - 10
	    End If
	    Select Case nCompress%
		Case DRIVE_REMOVABLE
		    strDrive$ = "[Floppy"
		Case DRIVE_FIXED
		    strDrive$ = "[Fixed"
		Case DRIVE_REMOTE
		    strDrive$ = "[Network"
		Case DRIVE_CDROM
		    strDrive$ = "[CDRom"
		Case DRIVE_RAM
		    strDrive$ = "[RAM"
		Case Else
		    strDrive$ = ""
	    End Select
	    If nDrive% > 10 Then
		strDrive$ = strDrive$ & " (Compressed)]"
	    Else
		strDrive$ = strDrive$ & "]"
	    End If
	    
	    strTemp$ = Chr$(65 + I%) & ": "
	    strTemp$ = strTemp$ & strDrive$
	    cboDrive.AddItem strTemp$
	End If
    Next

    ' Select the Default Drive, Default = 0
    cboDrive.ListIndex = DEFAULT_DRIVE

    ' Setup the Help Context
    App.HelpFile = App.Path & "\ADVDISK.HLP"

    ' Main Form Help Context ID's
    frmAdvancedApplications.HelpContextID = HLP_SAMPLE
    cboDrive.HelpContextID = HLP_DRIVE_TYPE
    cmdCheckFile.HelpContextID = HLP_DRIVE_CHECK
    cmdDiskSpace(0).HelpContextID = HLP_FREE_SPACE
    cmdDiskSpace(1).HelpContextID = HLP_TOTAL_SPACE
    cmdCopy.HelpContextID = HLP_MOVE_FILE
    cmdSample.HelpContextID = HLP_SAMPLE
    cmdAbout.HelpContextID = HLP_ABOUTBOX
    cmdSearchList.HelpContextID = HLP_SEARCH
    cmdPathWord.HelpContextID = HLP_SPLIT_WORD
    cmdCreateDir.HelpContextID = HLP_DIRECTORY

    ' Move Form Help Context ID's
    cmdCheckFile.HelpContextID = HLP_FILE_EXISTS
    frmMove.cmdTo.HelpContextID = HLP_FILE_EXISTS
    frmMove.cmdFrom.HelpContextID = HLP_FILE_EXISTS
    frmMove.HelpContextID = HLP_MOVE_FILE

    ' Create/Delete Directory Help Context ID's
    frmCreateDir.cmdOK(0).HelpContextID = HLP_CREATE_PATH
    frmCreateDir.cmdOK(1).HelpContextID = HLP_DELETE_PATH

End Sub

Sub optFileMode_Click (Index As Integer)
    ' Set the Drive Check Type Mode
    Select Case Index
	Case 0
	    nFileMode = EXISTANCE_CHECK
	Case 1
	    nFileMode = WRITE_CHECK
	Case 2
	    nFileMode = READ_CHECK
	Case 3
	    nFileMode = READ_WRITE_CHECK
    End Select
End Sub

