'Functions for dealing with INI files

Option Compare Database   'Use database order for string comparisons
Option Explicit : DefInt A-Z

Declare Function GetPrivateProfileInt Lib "Kernel" (ByVal Section As String, ByVal Entry As String, ByVal Default As Integer, ByVal FileName As String) As Integer
Declare Function PAWSOFFGetPrivateProfileString Lib "Kernel" Alias "GetPrivateProfileString" (ByVal Section As String, ByVal Entry As Any, ByVal Default As String, ByVal Buffer As String, ByVal BufSize As Integer, ByVal FileName As String) As Integer
Declare Function PAWSOFFWritePrivateProfileString Lib "Kernel" Alias "WritePrivateProfileString" (ByVal Section As Any, ByVal Entry As Any, ByVal Value As Any, ByVal FileName As String) As Integer

Declare Function GetProfileInt Lib "Kernel" (ByVal Section As String, ByVal Entry As String, ByVal Default As Integer) As Integer
Declare Function PAWSOFFGetProfileString Lib "Kernel" Alias "GetProfileString" (ByVal Section As String, ByVal Entry As Any, ByVal Default As String, ByVal Buffer As String, ByVal BufSize As Integer) As Integer
Declare Function PAWSOFFWriteProfileString Lib "Kernel" Alias "WriteProfileString" (ByVal Section As Any, ByVal Entry As Any, ByVal Value As Any) As Integer

Const BufSz = 1024
Const BufSzAll = 4096

'A slightly more bulletproof string-to-number function
Function Dec (ByVal s As String) As Double
    Dim temp As String
    Dim i As Integer
    Dim c As String
    Dim DecimalPt As String
    Dim DPUsed As Integer
    Dim NDigits As Integer

    DecimalPt = GetProfileString("intl", "sDecimal", ".")
    DPUsed = False
    NDigits = 0

    For i = 1 To Len(s)
        c = Mid$(s, i, 1)
        Select Case (Asc(c))
        Case Asc("0") To Asc("9")
            temp = temp & c: NDigits = NDigits + 1
        Case Asc(DecimalPt)
            If (Not DPUsed) Then temp = temp & DecimalPt: DPUsed = True
        'Case Else
        '    If (temp <> "") Then Exit For
        End Select
    Next i

    If (NDigits > 0) Then Dec = CDbl(temp) Else Dec = 0
End Function

'The most recently read profile file is cached in memory. This flushes the cache.
Sub FlushPrivateProfile (ByVal FileName As String)
    Dim R As Integer
    R = PAWSOFFWritePrivateProfileString(0&, 0&, 0&, FileName)
End Sub

'WIN.INI is cached in memory. This flushes the cache.
Sub FlushProfile ()
    Dim R As Integer
    R = PAWSOFFWriteProfileString(0&, 0&, 0&)
End Sub

'Like the API call but allows the use of VB's Null in place of a C-style NULL
Function GetPrivateProfileString (ByVal Section As String, ByVal Entry As Variant, ByVal Default As String, ByVal FileName As String) As String
    Dim Buffer As String
    Dim R As Integer

    If (IsNull(Entry)) Then
        'Get names of all entries in the named section
        Buffer = String$(BufSzAll, 0)
        R = PAWSOFFGetPrivateProfileString(Section, 0&, Default, Buffer, BufSzAll, FileName)
    Else
        'Get the value of the named entry
        Buffer = String$(BufSz, 0)
        R = PAWSOFFGetPrivateProfileString(Section, CStr(Entry), Default, Buffer, BufSz, FileName)
    End If
    GetPrivateProfileString = Left$(Buffer, R)
End Function

'Like the API call but allows the use of VB's Null in place of a C-style NULL
Function GetProfileString (ByVal Section As String, ByVal Entry As Variant, ByVal Default As String) As String
    Dim Buffer As String
    Dim R As Integer

    If (IsNull(Entry)) Then
        'Get names of all entries in the named section
        Buffer = String$(BufSzAll, 0)
        R = PAWSOFFGetProfileString(Section, 0&, Default, Buffer, BufSzAll)
    Else
        'Get the value of the named entry
        Buffer = String$(BufSz, 0)
        R = PAWSOFFGetProfileString(Section, CStr(Entry), Default, Buffer, BufSz)
    End If
    GetProfileString = Left$(Buffer, R)
End Function

'Retrieve an entry from a multi-entry string
Function StrEntry (ByVal s As String, ByVal Which As Integer) As String
    If (Which < 1) Then StrEntry = "": Exit Function
    
    Dim Pos As Long
    Dim Curr As Integer
    Curr = 1
    Pos = 1

    'Pos = starting character of entry #Curr
    Do Until (Curr = Which)
        Pos = InStr(Pos, s, Chr$(0))
        If (Pos = 0) Then
            StrEntry = ""
            Exit Function
        End If
        Pos = Pos + 1
        Curr = Curr + 1
    Loop
    'Pos = starting character of entry #Which

    'Find end of this line
    Dim LineEnd
    LineEnd = InStr(Pos, s, Chr$(0))
    If (LineEnd = 0) Then

        StrEntry = Right$(s, Len(s) - Pos + 1)
    Else
        StrEntry = Mid$(s, Pos, LineEnd - Pos)
    End If
End Function

'Find the number of NUL separated entries in a string
Function StrNEntries (ByVal s As String) As Integer
    Dim NNuls As Integer
    Dim Pos As Integer

    Pos = 1
    NNuls = 1
    Do While (True)
        Pos = InStr(Pos, s, Chr$(0))
        If (Pos = 0) Then
            StrNEntries = NNuls
            Exit Function
        Else
            Pos = Pos + 1
            NNuls = NNuls + 1
        End If
    Loop
End Function

'Like the API call but allows the use of VB's Null in place of a C-style NULL
Sub WritePrivateProfile (ByVal Section As String, ByVal Entry As Variant, ByVal Value As Variant, ByVal FileName As String)
    Dim R As Integer

    If (IsNull(Entry)) Then
        'Delete named section
        R = PAWSOFFWritePrivateProfileString(Section, 0&, 0&, FileName)
    ElseIf (IsNull(Value)) Then
        'Delete named entry within the section

        R = PAWSOFFWritePrivateProfileString(Section, CStr(Entry), 0&, FileName)
    Else
        'Insert or replace the entry
        R = PAWSOFFWritePrivateProfileString(Section, CStr(Entry), CStr(Value), FileName)
    End If
    
    If (R = 0) Then Err = 32767
End Sub

'Like the API call but allows the use of VB's Null in place of a C-style NULL
Sub WriteProfile (ByVal Section As String, ByVal Entry As Variant, ByVal Value As Variant)
    Dim R As Integer

    If (IsNull(Entry)) Then
        'Delete named section
        R = PAWSOFFWriteProfileString(Section, 0&, 0&)
    ElseIf (IsNull(Value)) Then
        'Delete named entry within the section
        R = PAWSOFFWriteProfileString(Section, CStr(Entry), 0&)
    Else
        'Insert or replace the entry
        R = PAWSOFFWriteProfileString(Section, CStr(Entry), CStr(Value))
    End If
    
    If (R = 0) Then Err = 32767
End Sub
