VERSION 2.00
Begin Form fEZPrint 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "VSPrinter: a smarter Replacement for the Printer Object"
   ClientHeight    =   6240
   ClientLeft      =   1185
   ClientTop       =   540
   ClientWidth     =   7515
   Height          =   6705
   Left            =   1095
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6240
   ScaleWidth      =   7515
   Top             =   165
   Width           =   7695
   Begin vsViewPort vsViewPort2 
      BackColor       =   &H00808080&
      ConvInfo        =   FEZPRINT.FRX:0000
      Height          =   3735
      LargeChangeVert =   900
      Left            =   255
      Top             =   585
      VirtualHeight   =   7400
      VirtualWidth    =   0
      Width           =   1905
      Begin CommandButton Command1 
         BackColor       =   &H00808080&
         Caption         =   "Table of Cont."
         Height          =   500
         Index           =   12
         Left            =   135
         TabIndex        =   17
         Top             =   2520
         Width           =   1380
      End
      Begin CommandButton Command1 
         BackColor       =   &H00808080&
         Caption         =   "Fancy Table"
         Height          =   500
         Index           =   11
         Left            =   120
         TabIndex        =   16
         Top             =   1920
         Width           =   1380
      End
      Begin CommandButton Command1 
         BackColor       =   &H00808080&
         Caption         =   "Line by Line"
         Height          =   500
         Index           =   0
         Left            =   120
         TabIndex        =   3
         Top             =   105
         Width           =   1380
      End
      Begin CommandButton Command1 
         BackColor       =   &H00808080&
         Caption         =   "Paragraph"
         Height          =   500
         Index           =   1
         Left            =   120
         TabIndex        =   4
         Top             =   720
         Width           =   1380
      End
      Begin CommandButton Command1 
         BackColor       =   &H00808080&
         Caption         =   "Tables"
         Height          =   500
         Index           =   2
         Left            =   120
         TabIndex        =   5
         Top             =   1320
         Width           =   1380
      End
      Begin CommandButton Command1 
         BackColor       =   &H00808080&
         Caption         =   "Multi-Column"
         Height          =   500
         Index           =   3
         Left            =   120
         TabIndex        =   6
         Top             =   3135
         Width           =   1380
      End
      Begin CommandButton Command1 
         BackColor       =   &H00808080&
         Caption         =   "Draw"
         Height          =   500
         Index           =   4
         Left            =   120
         TabIndex        =   10
         Top             =   5535
         Width           =   1380
      End
      Begin CommandButton Command1 
         BackColor       =   &H00808080&
         Caption         =   "&AlignText"
         Height          =   500
         Index           =   5
         Left            =   120
         TabIndex        =   7
         Top             =   3735
         Width           =   1380
      End
      Begin CommandButton Command1 
         BackColor       =   &H00808080&
         Caption         =   "&Indent"
         Height          =   500
         Index           =   6
         Left            =   120
         TabIndex        =   8
         Top             =   4335
         Width           =   1380
      End
      Begin CommandButton Command1 
         BackColor       =   &H00808080&
         Caption         =   "&Mail Merge"
         Height          =   500
         Index           =   7
         Left            =   120
         TabIndex        =   9
         Top             =   4935
         Width           =   1380
      End
      Begin CommandButton Command1 
         BackColor       =   &H00808080&
         Caption         =   "&Graphics"
         Height          =   500
         Index           =   8
         Left            =   120
         TabIndex        =   11
         Top             =   6135
         Width           =   1380
      End
      Begin CommandButton Command1 
         BackColor       =   &H00808080&
         Caption         =   "Angle"
         Height          =   500
         Index           =   10
         Left            =   120
         TabIndex        =   12
         Top             =   6735
         Width           =   1380
      End
   End
   Begin CommandButton Command1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Order Form"
      Default         =   -1  'True
      Height          =   870
      Index           =   9
      Left            =   240
      TabIndex        =   13
      Top             =   4440
      Width           =   1905
   End
   Begin ComboBox cmbOrientation 
      Enabled         =   0   'False
      Height          =   300
      Left            =   2880
      Style           =   2  'Dropdown List
      TabIndex        =   0
      Top             =   105
      Width           =   1065
   End
   Begin CommandButton cmdPrint 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Print"
      Enabled         =   0   'False
      Height          =   300
      Left            =   6120
      TabIndex        =   2
      Top             =   120
      Width           =   1095
   End
   Begin vsViewPort vsViewPort1 
      BackColor       =   &H00808080&
      ConvInfo        =   FEZPRINT.FRX:000B
      Height          =   5490
      Left            =   2295
      Top             =   525
      VirtualHeight   =   0
      VirtualWidth    =   0
      Width           =   4980
      Begin vsPrinter vsPrinter 
         BackColor       =   &H00FFFFFF&
         BrushColor      =   &H0080FFFF&
         ConvInfo        =   FEZPRINT.FRX:0016
         FontName        =   "Arial"
         FontSize        =   40
         Footer          =   "||Page %d"
         HdrColor        =   &H00800000&
         HdrFontBold     =   -1  'True
         HdrFontItalic   =   -1  'True
         HdrFontName     =   "Arial"
         HdrFontSize     =   24
         Header          =   "|VideoSoft VSView"
         Height          =   3555
         Left            =   105
         PenWidth        =   2
         TableSep        =   "|;"
         Top             =   105
         Width           =   2805
      End
   End
   Begin ComboBox cmbZoom 
      Enabled         =   0   'False
      Height          =   300
      Left            =   4800
      Style           =   2  'Dropdown List
      TabIndex        =   1
      Top             =   105
      Width           =   960
   End
   Begin Image Image3 
      Height          =   510
      Left            =   960
      Picture         =   FEZPRINT.FRX:0021
      Stretch         =   -1  'True
      Top             =   5520
      Visible         =   0   'False
      Width           =   750
   End
   Begin Image Image2 
      Height          =   330
      Left            =   285
      Picture         =   FEZPRINT.FRX:937B
      Stretch         =   -1  'True
      Top             =   5640
      Visible         =   0   'False
      Width           =   540
   End
   Begin Label Label1 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Orient."
      ForeColor       =   &H00000000&
      Height          =   195
      Index           =   2
      Left            =   2250
      TabIndex        =   15
      Top             =   130
      Width           =   615
   End
   Begin Label Label1 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Zoom"
      ForeColor       =   &H00000000&
      Height          =   195
      Index           =   1
      Left            =   4275
      TabIndex        =   14
      Top             =   135
      Width           =   495
   End
   Begin Image Image1 
      Height          =   420
      Left            =   240
      Picture         =   FEZPRINT.FRX:9F1D
      Top             =   105
      Width           =   420
   End
End
Option Explicit

Dim MyPage%         'Keep the output view to be printed
Dim OldOrientation  'Don't mess with my printer settings

Sub cmbOrientation_Click ()
  
  mousepointer = 11
  
  vsPrinter.Orientation = cmbOrientation.ListIndex
  cmbZoom_click
  If MyPage >= 0 Then command1_click MyPage

  mousepointer = 0

End Sub

Sub cmbZoom_click ()
  
  vsPrinter.Visible = False
  mousepointer = 11
    
  'Change the screen size to zoom value
  vsPrinter.Width = vsPrinter.PageWidth * Val(cmbZoom) / 100
  vsPrinter.Height = vsPrinter.PageHeight * Val(cmbZoom) / 100
  
  'Make scrollable ViewPort
  vsViewPort1.VirtualWidth = vsPrinter.Width + 400
  vsViewPort1.VirtualHeight = vsPrinter.Height + 400

  ' center printer if it fit on the screen
  If vsPrinter.Width < vsViewPort1.Width Then vsPrinter.Left = (vsViewPort1.Width - vsPrinter.Width) / 2
  If vsPrinter.Height < vsViewPort1.Height Then vsPrinter.Top = (vsViewPort1.Height - vsPrinter.Height) / 2
  
  mousepointer = 0
  vsPrinter.Visible = True

End Sub

Sub cmdPrint_Click ()
  
  ' get ready to print
  cmdPrint.Enabled = False
  mousepointer = 11
  
  ' print to the printer
  vsPrinter.Preview = False
  command1_click MyPage
  vsPrinter.Preview = True

  ' all done
  cmdPrint.Enabled = True
  mousepointer = 0

End Sub

Sub command1_click (Index%)
      
  ' remember page for use with Print command
  MyPage = Index%

  ' we have a print job, so let's enable these guys
  cmbZoom.Enabled = True
  cmdPrint.Enabled = True
  cmbOrientation.Enabled = True

  ' start the print preview job
  vsPrinter.Action = 3 ' StartDoc
  If vsPrinter.Error Then Beep: Exit Sub
  mousepointer = 11

  SetDefaultStyle

  ' choose what to print based on button index
  Select Case Index
    Case 0: DoLine
    Case 1: DoParagraph
    Case 2: DoTable
    Case 3: DoColumns
    Case 4: DoDrawing
    Case 5: DoAlign
    Case 6: DoIndent
    Case 7: DoMailMerge "Joe Smith", "Chief Financial Officer"
            DoMailMerge "Mary Kerney", "President"
    Case 8: DoGraphics
    Case 9: DoOrder
    Case 10: DoAngle
    Case 11: DoFancyTable
    Case 12: ' print table of contents
              vsPrinter = "Table of Contents"
              vsPrinter.FontSize = 20
              DoTableOfContents "Acknowledgements", "i"
              DoTableOfContents "Introduction", "1"
              DoTableOfContents "Background", "5"
              DoTableOfContents "Printing", "15"
              DoTableOfContents "  graphics", "25"
              DoTableOfContents "  text", "46"
              DoTableOfContents "Previewing", "67"
              DoTableOfContents "  graphics", "88"
              DoTableOfContents "  text", "92"
              DoTableOfContents "Conclusion", "125"
 
  End Select
  
  ' all done
  vsPrinter.Action = 6 'End Document
  mousepointer = 0

End Sub

Sub DoAlign ()
      
      ' show page title
      vsPrinter.SpaceAfter = 100
      vsPrinter.TextColor = QBColor(1)
      vsPrinter.TextAlign = 1  'Center
      vsPrinter.FontUnderline = True
      vsPrinter.Paragraph = ""
      vsPrinter.Paragraph = "VSPrinter automatically aligns proportional fonts"
      vsPrinter.FontUnderline = False
      
      ' show off
      vsPrinter.Paragraph = ""
      vsPrinter.FontSize = 20
      vsPrinter.TextColor = QBColor(0)
      vsPrinter.CurrentX = vsPrinter.MarginLeft
      vsPrinter.TextAlign = 2  'Rigth
      vsPrinter.Paragraph = "Text is right aligned"
      vsPrinter.TextAlign = 1  'Center
      vsPrinter.Paragraph = "Text is centered"
      vsPrinter.TextAlign = 0  'Left
      vsPrinter.Paragraph = "Text is left aligned"
      vsPrinter.SpaceAfter = 0

End Sub

Sub DoAngle ()
      Dim i%, j%

      ' show page title
      vsPrinter.TextAngle = 450
      vsPrinter = ""
      vsPrinter = ""
      vsPrinter = ""
      vsPrinter = ""
      vsPrinter = "Rotate text"
      vsPrinter = "to any angle"
      
      ' rotate Text
      j = 1
      For i = 450 To 3600 Step 900
        vsPrinter.TextColor = QBColor(j)
        vsPrinter.CurrentX = vsPrinter.PageWidth * .5
        vsPrinter.CurrentY = vsPrinter.PageHeight * .5
        vsPrinter.TextAngle = i
        vsPrinter.Text = "VSView"
        j = j + 1
      Next

      ' restore defaults
      vsPrinter.TextAngle = 0
      vsPrinter.TextColor = 0

End Sub

Sub DoColumns ()
      Dim s$, i%

      ' set multi-column mode
      vsPrinter.Columns = 2
      
      ' create a string to print
      s = "VSPrinter can also print in multiple columns. "
      s = s + "You have control over column breaks, and you can save "
      s = s + "a whole lot of paper by using multiple columns."
      
      ' print text in two colors just for fun
      vsPrinter.TextColor = QBColor(1)
      vsPrinter = s
      vsPrinter = ""
      vsPrinter.TextColor = QBColor(0)
      vsPrinter = s

End Sub

Sub DoDrawing ()
      Dim s$, X%, Y%

      ' go to center of the page
      vsPrinter.CurrentX = vsPrinter.PageWidth / 2
      vsPrinter.CurrentY = vsPrinter.PageHeight / 2

      ' start with some text
      vsPrinter.TextAlign = 1
      vsPrinter.TextColor = &H800000       'Blue
      vsPrinter = "Add graphics to your reports!"
      vsPrinter.TextColor = &H0&           'Black
      vsPrinter = "With VSPrinter, it's easy!"
      vsPrinter.TextAlign = 0              ' Left

      ' draw graphics with primitives
      vsPrinter.X1 = vsPrinter.PageWidth / 4 * .25
      vsPrinter.Y1 = vsPrinter.PageHeight / 4 * .25
      vsPrinter.X2 = vsPrinter.PageWidth / 4 * 1.25
      vsPrinter.Y2 = vsPrinter.PageHeight / 4 * 1.25
      vsPrinter.BrushColor = &HFF&         'Red
      vsPrinter.BrushStyle = 6             'Cross
      vsPrinter.Draw = 3                   'Circle

      vsPrinter.X1 = vsPrinter.PageWidth * .7
      vsPrinter.Y1 = vsPrinter.PageHeight * .7
      vsPrinter.X2 = vsPrinter.PageWidth * .9
      vsPrinter.Y2 = vsPrinter.PageHeight * .9
      vsPrinter.BrushColor = &H800080      'Purple
      vsPrinter.BrushStyle = 7             'Cross Diagonal
      vsPrinter.Draw = 2                   'Rect.

      ' polylines are good for charts, graphs, maps etvsPrinter...
      s = ""
      For X = vsPrinter.MarginLeft To vsPrinter.PageWidth - vsPrinter.MarginRight Step 20
        Y = 3000 + Cos(X * 3.1416 / 180) * (X - vsPrinter.PageWidth / 2) / 10
        s = s + Str(X) + Str(Y)
      Next
      vsPrinter.PenWidth = 30
      vsPrinter.PolyLine = s
      vsPrinter.PenWidth = 0

End Sub

Sub DoFancyTable ()
    Dim f$, s$, tw, savx
    Dim sp%

    ' initialize
    f = "2000|1800|^1440|^2200;"
    tw = 2000 + 1800 + 1440 + 2200
    s = "Country|Capital|GNP|Comments"
    
    ' print page title
    vsPrinter.TextAlign = 1    'Center
    vsPrinter.FontSize = 40
    vsPrinter = ""
    vsPrinter = "Shading Tables"
    vsPrinter.FontSize = 18
    vsPrinter = ""
    vsPrinter = ""

    ' save row start position
    Select Case vsPrinter.TextAlign
      Case 0: vsPrinter.X1 = vsPrinter.CurrentX
      Case 1: vsPrinter.X1 = (vsPrinter.PageWidth - tw) / 2
      Case 2: vsPrinter.X1 = vsPrinter.PageWidth - tw - vsPrinter.MarginRight
    End Select
    savx = vsPrinter.X1
    vsPrinter.Y1 = vsPrinter.CurrentY
    
    ' print header just to measure row
    vsPrinter.FontBold = True
    vsPrinter.Table = f + s
    
    ' save row end position
    vsPrinter.X2 = vsPrinter.X1 + tw
    vsPrinter.Y2 = vsPrinter.CurrentY
    
    ' use saved positions to draw light shading
    vsPrinter.BrushStyle = 0
    vsPrinter.BrushColor = RGB(255, 255, 0)
    vsPrinter.PenColor = vsPrinter.BrushColor
    vsPrinter.Draw = 2 ' rectangle
    vsPrinter.PenColor = 0
      
      
    ' the shading erased the row, so let's go again
    vsPrinter.CurrentX = savx
    vsPrinter.CurrentY = vsPrinter.Y1
    vsPrinter.Table = f + s
      
    ' disable header coloring
    vsPrinter.TextColor = 0
    sp = MyPage
    MyPage = -1
    
    ' do the table body
    vsPrinter.FontBold = False
    s = f + "Argentina|Buenos Aires|50|Tango land;"
    s = s + "Brazil|Brasilia|150|Lambada, anyone?;"
    s = s + "Chile|Santiago|25|This has nothing to do with beans!;"
    vsPrinter.Table = s

    '  let's try some pictures on the table
    vsPrinter.FontSize = 40
    vsPrinter = ""
    vsPrinter = "Pictures on Tables"
    vsPrinter.FontSize = 14
    vsPrinter = ""
    vsPrinter = ""

    ' initialize
    f = "2000|>720|7000;"
    tw = 2000 + 720 + 7000
    s = "Control||Comments;"
    vsPrinter.TextAlign = 0    'Left
    vsPrinter.X1 = vsPrinter.CurrentX
    vsPrinter.Y1 = vsPrinter.CurrentY
    
    ' print header just to measure row
    vsPrinter.FontBold = True
    vsPrinter.Table = f + s
    
    ' save row end position
    vsPrinter.X2 = vsPrinter.X1 + tw
    vsPrinter.Y2 = vsPrinter.CurrentY


    ' just for kicks, put a picture in cell 2
    vsPrinter.X1 = vsPrinter.X1 + 2000
    vsPrinter.X2 = vsPrinter.X1 + 720
    vsPrinter.Picture = image1

    s = "Grid|No|Limited functionality;"
    s = s + "vsPrinter|Yes|Very powerful"
    vsPrinter.Table = f + s
    
    ' restore defaults
    MyPage = sp
End Sub

Sub DoGraphics ()
    Dim s$, fmt$
  
    ' print page title
    vsPrinter = ""
    vsPrinter.CurrentX = 2500
    vsPrinter.TextColor = QBColor(1)
    vsPrinter = "Metafiles and Bitmaps"
    vsPrinter.TextColor = QBColor(0)
    vsPrinter.FontSize = 28
    vsPrinter = ""
    s = "You can now print and preview reports that "
    s = s + "include bitmaps and metafiles.  "
    s = s + "Automate desktop publishing with vsView!!!!"
    vsPrinter = s
    vsPrinter = ""

    ' print pictures, stretch and align anywhere on the page
    vsPrinter.X1 = 1000
    vsPrinter.Y1 = 1000
    vsPrinter.X2 = 2400
    vsPrinter.Y2 = 2400
    vsPrinter.Picture = image3.Picture

    vsPrinter.X1 = vsPrinter.CurrentX
    vsPrinter.Y1 = vsPrinter.CurrentY
    vsPrinter.X2 = vsPrinter.PageWidth - vsPrinter.MarginRight
    vsPrinter.Y2 = vsPrinter.PageHeight - vsPrinter.MarginBottom
    vsPrinter.Picture = image3.Picture
      
End Sub

Sub DoIndent ()
  
    ' indent left, right, or center
    vsPrinter.IndentFirst = 1000
    vsPrinter = "You can automatically indent the FIRST LINE of a paragraph."
    vsPrinter = ""

    vsPrinter.IndentFirst = 0
    vsPrinter.IndentLeft = 1000
    vsPrinter = "You can automatically indent from the LEFT margin of the page."
    vsPrinter = ""
  
    vsPrinter.IndentLeft = 0
    vsPrinter.IndentRight = 1000
    vsPrinter = "You can automatically indent from the RIGHT margin of the page."
    vsPrinter = ""

    vsPrinter.IndentLeft = 1000
    vsPrinter.IndentFirst = 1500
    vsPrinter = "Or combine all types of indentation."

    ' restore defaults
    vsPrinter.IndentLeft = 0
    vsPrinter.IndentFirst = 0
    vsPrinter.IndentRight = 0

End Sub

Sub DoLine ()
      
      ' start a line or paragraph with one font
      vsPrinter.TextColor = 0
      vsPrinter = ""
      vsPrinter.Text = "With VSPrinter you can print "

      ' continue with a different font
      vsPrinter.FontBold = True
      vsPrinter.TextColor = RGB(255, 0, 255)
      vsPrinter.Text = "Line by Line"
      
      ' and finish with the original font!
      vsPrinter.TextColor = 0
      vsPrinter.FontBold = False
      vsPrinter.Text = " just like you would in VB."
      vsPrinter.Text = " Text wraps automatically, so your life becomes easier."

End Sub

Sub DoMailMerge (FullName$, Position$)

    ' get ready to print with "corporate" font
    vsPrinter.FontBold = False
    vsPrinter.FontSize = 24
    vsPrinter.TextColor = 0
  
    ' you could print a letterhead here...

    ' date and salutation...
    vsPrinter = Format$(Now, "mmmm d, yyyy")
    vsPrinter = ""
    vsPrinter = ""
    vsPrinter.Text = "This letter is to inform that "
  
    ' print person name and new position
    vsPrinter.TextColor = RGB(255, 0, 0)
    vsPrinter.Text = FullName
    vsPrinter.TextColor = 0
    vsPrinter.Text = " has been promoted to "
    vsPrinter.TextColor = RGB(255, 0, 0)
    vsPrinter.Text = Position
    vsPrinter.TextColor = 0
    vsPrinter.Text = " of this company."
    
    ' skip an inch instead of breaking pages (with Action property)
    vsPrinter.CurrentY = vsPrinter.CurrentY + 1440
    vsPrinter.CurrentX = vsPrinter.MarginLeft
    
End Sub

Sub DoOrder ()
    Dim fmt$, s$, INCHES%
    
    ' initialize
    INCHES = 1440
    vsPrinter.FontSize = 30
    vsPrinter.FontBold = True

    ' place money picture
    vsPrinter.X1 = vsPrinter.PageWidth - (2.5 * INCHES)
    vsPrinter.Y1 = .75 * INCHES
    vsPrinter.X2 = vsPrinter.X1 + (2 * INCHES)
    vsPrinter.Y2 = vsPrinter.Y1 + (1.25 * INCHES)
    vsPrinter.Picture = image2.Picture

    ' print title
    vsPrinter.CurrentY = .75 * INCHES
    vsPrinter = "ORDER FORM"
    vsPrinter.PenWidth = 2
    vsPrinter.FontSize = 10
    vsPrinter.FontBold = False
    vsPrinter = "Please rush my order to the following address:"
    vsPrinter = ""
  
    ' print table to hold customer name and address
    fmt = "2500|>4500;" ' column widths in Twips (1440 = 1 inch)
    s = fmt
    s = s + "Name|;"
    s = s + "Company|;"
    s = s + "Address|;"
    s = s + "|;"
    s = s + "|;"
    s = s + "|;"
    s = s + "Phone|;"
    s = s + "Fax|;"
    s = s + "Credit Card #|;"
    s = s + "Expiration Date|;"
    s = s + "Comments|;"
    s = s + "|;"
    s = s + "|;"
    vsPrinter.TableBorder = 5 ' columns
    vsPrinter.Table = s
  
    ' some fine print...
    vsPrinter = ""
    vsPrinter = ""
    vsPrinter = "Fax your credit card order to 510-547-1084 or mail your check or money order to: VideoSoft, 2625 Alcatraz Avenue, Suite 271, Berkeley, California 94705.  Sorry no CODs."
    vsPrinter = ""

    ' another table for quantities and amounts (let's center this one)
    vsPrinter.TextAlign = 1   ' center
    vsPrinter.TableBorder = 7 ' all
    fmt = "^2000|^4000|^2000|^2000;"
    s = fmt
    s = s + "QUANTITY|COPIES OF|PRICE|TOTAL;"
    vsPrinter.Table = s

    ' print body in 4 columns but with different column alignment
    fmt = "^2000|4000|>2000|>2000;"
    s = fmt
    s = s + "|VideoSoft VSView|$99.00|;"
    s = s + "|VideoSoft VSVBX|$45.00|;"
    s = s + "|VideoSoft CodeBook|$45.00|;"
    vsPrinter.Table = s

    ' now append another table with only 2 columns
    fmt = ">8000|>2000;"
    s = fmt
    s = s + "California state residents add 8.5% sales tax|;"
    s = s + "Shipping and Handling Domestic|US$6.00;"
    s = s + "Shipping and Handling International|US$10.00;"
    s = s + "TOTAL|;"
    vsPrinter.Table = s
    
End Sub

Sub DoParagraph ()
    Dim s$

    ' print paragraphs by assigning a string to the printer
    s = "You can print whole paragraphs at once! This is very easy. "
    vsPrinter.Paragraph = s + s
    vsPrinter.Paragraph = ""
    vsPrinter.Paragraph = "VSPrinter takes care of indentation, wrapping, spacing, etvsPrinter."

End Sub

Sub DoTable ()
    Dim s$, fmt$

    ' print page title
    vsPrinter = "Print by Table"
    vsPrinter.FontSize = 18
    vsPrinter = ""
    s = "You can now print reports that include paragraphs "
    s = s + "and tables.  With VSView, printing a grid it is very easy."
    vsPrinter = s
    vsPrinter = ""

    ' create table format
    fmt = "2500|>1600|^1600|>2100|>2200;"                   '^Center > Right
    
    ' create table string
    s = fmt + "Product|Code|Region|Units Sold|Revenue;"     'Set header
    s = s + "Spam in a Can|00012|North|372|$23,542;"
    s = s + "Flipper Tuna|00231|North|832|$44,432;"
    s = s + "Jiffy Lubed Butter|00978|North|452|$53,535"

    ' print the table in three flavors
    vsPrinter.PenWidth = 1
    vsPrinter.TextAlign = 1

    vsPrinter.FontSize = 18
    vsPrinter.TableBorder = 7
    vsPrinter.Table = s         ' flavor 1
    vsPrinter = ""
    
    vsPrinter.FontSize = 14
    vsPrinter.TableBorder = 8
    vsPrinter.Table = s         ' flavor 2
    vsPrinter = ""
    
    vsPrinter = ""
    vsPrinter.TableBorder = 9
    vsPrinter.Table = s         ' flavor 3
    
    ' and resume printing regular text
    vsPrinter = "Same table, different alignment and borders."

End Sub

Sub DoTableOfContents (txt$, pp$)
    Dim pw, ppos

    ' measure width of page number string
    vsPrinter.Measure = pp
    pw = vsPrinter.TextWid

    ' print topic name
    vsPrinter.TextAlign = 0
    vsPrinter.Text = txt

    ' print dot string
    ppos = vsPrinter.PageWidth - vsPrinter.MarginRight - pw
    Do
      vsPrinter.Text = " ."
    Loop While vsPrinter.CurrentX < ppos - 1440 / 4
    
    ' print page number and skip to next line
    vsPrinter.TextAlign = 2
    vsPrinter.Text = pp
    vsPrinter.TextAlign = 0
    vsPrinter = ""
End Sub

Sub Form_Load ()

  ' save orientation to clean up later
  OldOrientation = vsPrinter.Orientation
  
  ' initialize
  MyPage = -1    ' no current page
  vsPrinter.Preview = True
  vsPrinter.PreviewPage = 1
  
  ' preset zoom levels (you can choose your own)
  cmbZoom.AddItem "35"
  cmbZoom.AddItem "50"
  cmbZoom.AddItem "75"
  cmbZoom.AddItem "100"
  cmbZoom.AddItem "150"
  cmbZoom.AddItem "200"
  cmbZoom.ListIndex = 0

  ' orientation (you cannot choose your own)
  cmbOrientation.AddItem "Portrait"
  cmbOrientation.AddItem "Landscape"
  cmbOrientation.ListIndex = 0

  ' ready, set default page to 0
  MyPage = 0
End Sub

Sub Form_Unload (Cancel As Integer)
  
  ' restore printer orientation
  vsPrinter.Orientation = OldOrientation

End Sub

Sub SetDefaultStyle ()
  'Default Printing Values
  vsPrinter.FontName = "Arial"
  vsPrinter.FontSize = 40
  vsPrinter.FontBold = False
  vsPrinter.FontItalic = False
  vsPrinter.TextAlign = 0  'Left
  vsPrinter.TableBorder = 7
  vsPrinter.PageBorder = 3
  vsPrinter.PenStyle = 0
  vsPrinter.BrushStyle = 0
  vsPrinter.PenWidth = 2
  vsPrinter.PenColor = 0
  vsPrinter.BrushColor = 0
  vsPrinter.TextColor = 0
  vsPrinter.Columns = 1
  vsPrinter.SpaceAfter = 0

End Sub

Sub vsPrinter_Error ()
  '
End Sub

Sub vsPrinter_NewTableCell (row As Integer, Column As Integer, Cell As String)
  
  ' only when printing Table Example
  If MyPage <> 2 Then Exit Sub
  
  ' change color of hte headers (row 1)
  If row = 1 Then
    vsPrinter.TextColor = QBColor(Column)
  Else
    vsPrinter.TextColor = 1
  End If

End Sub

