// cntritem.cpp : implementation of the CVogonCntrItem class
//

#include "StdAfx.h"

#include "Vogon.h"

#include "CntrInfo.h"
#include "CntrItem.h"
#include "VogonDoc.h"
#include "VogonVw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CVogonCntrItem implementation

IMPLEMENT_SERIAL(CVogonCntrItem, COleClientItem, 0)

CVogonCntrItem::CVogonCntrItem(CVogonDoc* pContainer) : COleClientItem(pContainer)
{
   m_pConnPt = NULL;
   m_pEventInfo = NULL;

   // Setup Last Params Structure
   m_LastParams.cArgs = m_LastParams.cNamedArgs = 0;
   m_LastParams.rgvarg = NULL;
   m_LastParams.rgdispidNamedArgs = NULL;
}

CVogonCntrItem::~CVogonCntrItem()
{
   if (m_LastParams.cArgs > 0)
   {
      CleanUpParams();
   }
}


/////////////////////////////////////////////////////////////////////////////
//  CVogonCntrItem interface map
 
BEGIN_INTERFACE_MAP(CVogonCntrItem, COleClientItem)
    // INTERFACE_PART(CVogonCntrItem, IID_IDispatch, AmbientProps)
    // INTERFACE_PART(CVogonCntrItem, IID_IPropertyNotifySink, PropertyNotifySink)
END_INTERFACE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CVogonCntrItem implementation
LPUNKNOWN CVogonCntrItem::GetInterfaceHook(const void FAR* iid)
{
   //
   //  If requested IID is same as the one we looked up in the registry
   //  (see InitControlInfo), return pointer to our event handler code.
   //

   if (*(IID FAR*)iid == m_iidEvents)
   {
      return &m_xEventHandler;
   }

   return NULL;
}

///////////////////////////////////////////////////////////////////////////
// Overrides
             
/////////////////////////////////////////////////////////////////////////////
//
BOOL CVogonCntrItem::FinishCreate(HRESULT hr)
{
   BOOL status = COleClientItem::FinishCreate(hr);

   if (status)
   {
      InitControlInfo();

      //  Wire the control to our event handler
      LPCONNECTIONPOINTCONTAINER lpContainer;
      // Get a pointer to the interface
      if (SUCCEEDED(m_lpObject->QueryInterface(IID_IConnectionPointContainer,
                                               (LPVOID FAR*)&lpContainer)))
      {
         ASSERT(lpContainer != NULL);
         // Get a pointer to the connection point
         if (SUCCEEDED(lpContainer->FindConnectionPoint(m_iidEvents, &m_pConnPt)))
         {  // Tell the connection point about our event handler
            ASSERT(m_pConnPt != NULL);
            m_pConnPt->Advise(&m_xEventHandler, &m_dwEventConnection);
         }
         // We are done with the interface, let it go
         lpContainer->Release();
      }
   }
              
   return status;
}

/////////////////////////////////////////////////////////////////////////////
//
void CVogonCntrItem::Release(OLECLOSE dwCloseOption)
{
    UINT nSt = GetItemState ();
    if ((nSt == activeUIState) || (nSt == activeState) || (nSt == openState)) 
        Close (OLECLOSE_NOSAVE);

    if (m_pConnPt != NULL)
    {
        m_pConnPt->Unadvise(m_dwEventConnection);
        m_pConnPt->Release();
    }

    FreeControlInfo();
    COleClientItem::Release(dwCloseOption);
}
             
             
                                   
///////////////////////////////////////////////////////////////////////////
// Implementation
        
LPUNKNOWN CVogonCntrItem::GetCtlInterface(IID iidRequested)
{
   LPUNKNOWN lpUnknown = NULL;
   if (m_lpObject != NULL) 
   { 
      IID iidUnknown = IID_IUnknown;
      if (IsEqualIID(iidRequested, iidUnknown)) 
      {
         lpUnknown = m_lpObject;
         lpUnknown->AddRef();
      } 
      else 
      {
         if (FAILED (m_lpObject->QueryInterface(iidRequested, (LPVOID *) &lpUnknown))) 
         {
            lpUnknown = NULL;
         }
      }
   }
   return lpUnknown;
}
        
/////////////////////////////////////////////////////////////////////////////
//
void CVogonCntrItem::InitEventInfo(LPTYPEINFO lpTypeInfo)
{
    LPTYPEATTR lpType = NULL;
    LPFUNCDESC lpFuncDesc = NULL;

    if (lpTypeInfo != NULL && SUCCEEDED(lpTypeInfo->GetTypeAttr(&lpType)))
    {
        m_iidEvents = lpType->guid;
        m_nEvents = lpType->cFuncs;

        if (m_nEvents > 0)
        {
			TRY
			{
            	m_pEventInfo = new EVENTINFO[m_nEvents];
                        
	            USHORT nCount;
                        
	            //
	            //  Enumerate events, getting their member id's and names
	            //
                
	            for (nCount = 0; nCount < m_nEvents; nCount++)
	            {
	                m_pEventInfo[nCount].memid = -1;
	                m_pEventInfo[nCount].cParams = 0;
	                m_pEventInfo[nCount].pbstr = NULL;
    
	                if (SUCCEEDED(lpTypeInfo->GetFuncDesc(nCount, &lpFuncDesc)))
	                {
	                    m_pEventInfo[nCount].memid = lpFuncDesc->memid;
	                    m_pEventInfo[nCount].cParams = lpFuncDesc->cParams;
    
	                    m_pEventInfo[nCount].pbstr = new BSTR[lpFuncDesc->cParams+1];
	                    UINT cNames;
	                    lpTypeInfo->GetNames(lpFuncDesc->memid, m_pEventInfo[nCount].pbstr, 
	                            lpFuncDesc->cParams+1, &cNames);
                                        
	                    ASSERT((unsigned)lpFuncDesc->cParams+1 == cNames);
	                    lpTypeInfo->ReleaseFuncDesc(lpFuncDesc);
						lpFuncDesc = NULL;
	                }
	            }
			}
			CATCH(CMemoryException, e)
			{
				if (lpType != NULL)
					lpTypeInfo->ReleaseTypeAttr(lpType);

				if (lpFuncDesc != NULL)
	                    lpTypeInfo->ReleaseFuncDesc(lpFuncDesc);
	                    					
				lpType = NULL;
				lpFuncDesc = NULL;
			}
			END_CATCH				
		}
        lpTypeInfo->ReleaseTypeAttr(lpType);
		lpType = NULL;
    }
}

/////////////////////////////////////////////////////////////////////////////
//
void CVogonCntrItem::InitControlInfo()
{
   //
   //  Use the control's class info to obtain information about
   //  its events, etc.
   //

   ASSERT_VALID(this);
   ASSERT(m_lpObject != NULL);

   LPPROVIDECLASSINFO lpProvide = NULL;
      
   if (SUCCEEDED(m_lpObject->QueryInterface(IID_IProvideClassInfo, (LPVOID FAR*)&lpProvide)))
   {
      ASSERT(lpProvide != NULL);
    
      LPTYPEINFO lpClassInfo = NULL;

      if (SUCCEEDED(lpProvide->GetClassInfo(&lpClassInfo)))
      {
         ASSERT(lpClassInfo != NULL);

         LPTYPEATTR lpType;
         if (SUCCEEDED(lpClassInfo->GetTypeAttr(&lpType)))
         {
            ASSERT(lpType != NULL);
            ASSERT(lpType->typekind == TKIND_COCLASS);

            UINT nCount;
            int iFlags;
            HREFTYPE hRefType;

            //
            //  Search for typeinfo of the default events interface.
            //

            for (nCount = 0; nCount < lpType->cImplTypes; nCount++)
            {
               if (SUCCEEDED(lpClassInfo->GetImplTypeFlags(nCount, &iFlags)) &&
                  ((iFlags & IMPLTYPE_MASK) == IMPLTYPE_DEFAULTSOURCE))
               {
                  LPTYPEINFO lpTypeInfo = NULL;

                  if (SUCCEEDED(lpClassInfo->GetRefTypeOfImplType(nCount, &hRefType)) &&
                      SUCCEEDED(lpClassInfo->GetRefTypeInfo(hRefType, &lpTypeInfo)))
                  {
                     //
                     //  Found it!  Use it to initialize event table.
                     //

                     ASSERT(lpTypeInfo != NULL);
                     InitEventInfo(lpTypeInfo);                           
                     lpTypeInfo->Release();
                     lpTypeInfo = NULL;
                  }

                  break;
               }
            }

            lpClassInfo->ReleaseTypeAttr(lpType);
      	   lpType = NULL;
         }
                
         lpClassInfo->Release();
         lpClassInfo = NULL;
      }

      lpProvide->Release();
   }
}


/////////////////////////////////////////////////////////////////////////////
//
void CVogonCntrItem::FreeControlInfo(void)
{
   if (m_pEventInfo != NULL)
   {
      USHORT i;

      for (i = 0; i < m_nEvents; i++)
      {
         if (m_pEventInfo[i].pbstr != NULL)
         {
            for (SHORT j = 0; j < m_pEventInfo[i].cParams+1; j++)
            {
               ::SysFreeString(m_pEventInfo[i].pbstr[j]);
            }
            delete [] m_pEventInfo[i].pbstr;
         }
      }
      delete [] m_pEventInfo;
      m_pEventInfo = NULL;
   }                            
}

/////////////////////////////////////////////////////////////////////////////
//
EVENTINFO* CVogonCntrItem::GetEventInfo(MEMBERID memid)
{
   USHORT i;

   for (i = 0; i < m_nEvents; i++)
   {
      if (memid == m_pEventInfo[i].memid)
      {
         return &m_pEventInfo[i];
      }
   }    
   return NULL;
}
                                   
        
/////////////////////////////////////////////////////////////////////////////
//
void CVogonCntrItem::CleanUpParams()
{              
   ASSERT_VALID(this);          

   DISPPARAMS FAR* lpDispparams = &m_LastParams;
   
   if (lpDispparams->rgvarg != NULL)	      
   {
      for (UINT i=0; i<lpDispparams->cArgs; i++)
      {
         switch(lpDispparams->rgvarg[i].vt)
         {
            case VT_BSTR:
               ::SysFreeString(lpDispparams->rgvarg[i].bstrVal);
               break;
            case VT_DISPATCH:
               lpDispparams->rgvarg[i].pdispVal->Release();
               break;
            case VT_UNKNOWN:
               lpDispparams->rgvarg[i].punkVal->Release();
               break;
            default:
               break;
         }
      }
      delete lpDispparams->rgvarg;
   }

   lpDispparams->rgvarg = NULL;

   if (lpDispparams->rgdispidNamedArgs != NULL)
   {
      delete lpDispparams->rgdispidNamedArgs;
   }
   lpDispparams->rgdispidNamedArgs = NULL;
}		
                                 
/////////////////////////////////////////////////////////////////////////////
//
void CVogonCntrItem::CopyParams(DISPPARAMS FAR* lpDispparams)
{       
	UINT i;             

	if (lpDispparams == NULL)
		return;					// can't copy bogus params
		
	if (m_LastParams.cArgs > 0)
		CleanUpParams();

	// Change state information about incoming 		                  
	m_LastParams.cArgs = lpDispparams->cArgs;    
	if (lpDispparams->cArgs == 0)
		m_LastParams.rgvarg = NULL;
	else
		m_LastParams.rgvarg = new VARIANTARG[lpDispparams->cArgs];
    
	m_LastParams.cNamedArgs = lpDispparams->cNamedArgs;
	if(lpDispparams->cNamedArgs == 0)
  		m_LastParams.rgdispidNamedArgs = NULL;
	else
	{
  		m_LastParams.rgdispidNamedArgs = new DISPID[lpDispparams->cNamedArgs];
      		
		for(i = 0; i < m_LastParams.cNamedArgs; ++i)
			m_LastParams.rgdispidNamedArgs[i] = lpDispparams->rgdispidNamedArgs[i];
	}
	
	for (i = 0; i < m_LastParams.cArgs; i++)
	{               
		// Copy Parameter by type, left-to-right
      int indexOut = m_LastParams.cArgs - i - 1; 

		m_LastParams.rgvarg[indexOut].vt = lpDispparams->rgvarg[i].vt;

		switch(lpDispparams->rgvarg[i].vt)
        {       
	        case VT_I2:
	        	m_LastParams.rgvarg[indexOut].iVal = lpDispparams->rgvarg[i].iVal;
	            break;
	 
	        case VT_I4:
	        	m_LastParams.rgvarg[indexOut].lVal = lpDispparams->rgvarg[i].lVal;
	            break;
	 
	        case VT_R4:
	        	m_LastParams.rgvarg[indexOut].fltVal = lpDispparams->rgvarg[i].fltVal;
	            break;
	 
	        case VT_R8:
	        	m_LastParams.rgvarg[indexOut].dblVal = lpDispparams->rgvarg[i].dblVal;
	            break;

			case VT_BOOL:
	        	m_LastParams.rgvarg[indexOut].bool = lpDispparams->rgvarg[i].bool;
	            break;
	                                                                      
	        case VT_ERROR:
	        	m_LastParams.rgvarg[indexOut].scode = lpDispparams->rgvarg[i].scode;
	            break;
	                                                                        
	        case VT_CY:
	        	m_LastParams.rgvarg[indexOut].cyVal = lpDispparams->rgvarg[i].cyVal;
	            break;

	        case VT_DATE:
	        	m_LastParams.rgvarg[indexOut].date = lpDispparams->rgvarg[i].date;
	            break;
	            
	        case VT_BSTR:
	        	m_LastParams.rgvarg[indexOut].bstrVal = ::SysAllocString(lpDispparams->rgvarg[i].bstrVal);
	            break;
                                                                             
	        case VT_UNKNOWN:
	        	m_LastParams.rgvarg[indexOut].punkVal = lpDispparams->rgvarg[i].punkVal;
	            break;
	                                                                            
	        case VT_DISPATCH:
	        	m_LastParams.rgvarg[indexOut].pdispVal = lpDispparams->rgvarg[i].pdispVal;
	            break;
	            
	        case (VT_I2 | VT_BYREF):
	        	m_LastParams.rgvarg[indexOut].piVal = lpDispparams->rgvarg[i].piVal;
	            break;
	            
	        case (VT_I4 | VT_BYREF):
	        	m_LastParams.rgvarg[indexOut].plVal = lpDispparams->rgvarg[i].plVal;
	            break;
	            
	        case (VT_R4 | VT_BYREF):
	        	m_LastParams.rgvarg[indexOut].pfltVal = lpDispparams->rgvarg[i].pfltVal;
	            break;

	        case (VT_R8 | VT_BYREF):
	        	m_LastParams.rgvarg[indexOut].pdblVal = lpDispparams->rgvarg[i].pdblVal;
	            break;

			case (VT_BOOL | VT_BYREF):
	        	m_LastParams.rgvarg[indexOut].pbool = lpDispparams->rgvarg[i].pbool;
	            break;
	                                                                      
	        case (VT_ERROR | VT_BYREF):
	        	m_LastParams.rgvarg[indexOut].pscode = lpDispparams->rgvarg[i].pscode;
	            break;
	                                                                        
	        case (VT_CY | VT_BYREF):
	        	m_LastParams.rgvarg[indexOut].pcyVal = lpDispparams->rgvarg[i].pcyVal;
	            break;

	        case (VT_DATE | VT_BYREF):
	        	m_LastParams.rgvarg[indexOut].pdate = lpDispparams->rgvarg[i].pdate;
	            break;
	            
	        case (VT_BSTR | VT_BYREF):
	        	m_LastParams.rgvarg[indexOut].pbstrVal = lpDispparams->rgvarg[i].pbstrVal;
	            break;
                             
			case (VT_VARIANT | VT_BYREF):
				m_LastParams.rgvarg[indexOut].pvarVal = lpDispparams->rgvarg[i].pvarVal;
				break;
				                                                                             
	        case (VT_UNKNOWN | VT_BYREF):
	        	m_LastParams.rgvarg[indexOut].ppunkVal = lpDispparams->rgvarg[i].ppunkVal;
	            break;
	                                                                            
	        case (VT_DISPATCH | VT_BYREF):
	        	m_LastParams.rgvarg[indexOut].ppdispVal = lpDispparams->rgvarg[i].ppdispVal;
	            break;
	            
	        default:
	        	break;
        }
	}
}
                                          
/////////////////////////////////////////////////////////////////////////////
//  Callbacks

void CVogonCntrItem::OnEvent(DISPID dispID, DISPPARAMS FAR* lpDispparams)
{
   // Set the dispid and dispparams pointers to the latest information

   m_EventID = dispID;
   CopyParams(lpDispparams);

#ifdef _DEBUG
   TRACE("CVogonCntrItem dispatched for event %ld\n", dispID);

   // find the event
   EVENTINFO* pEvent = GetEventInfo(m_EventID);
   // Did we ?
   if (pEvent == NULL)
   { 
      TRACE1("Unknown event ID: %u\n", m_EventID);
      return;
   }

   // Costruct the trace: start with the event name
   CString stringMsg(pEvent->pbstr[0]);
   // wcstombs(sz, (const unsigned short*) pEvent->pbstr[0], ELEMENTS(sz));
   stringMsg += _T("(");

   for (unsigned nParameter = 0; nParameter < m_LastParams.cArgs; nParameter++)
   {
      TCHAR fmtBuf[64];

      if (nParameter > 0)
      {
         stringMsg += _T(", ");
      }

      stringMsg += pEvent->pbstr[nParameter + 1];
      stringMsg += _T(" = ");

      // We only handle BSTR, LONG, SHORT and BOOL - the types Webster uses ...
      switch (m_LastParams.rgvarg[nParameter].vt)
      // switch (lpDispparams->rgvarg[nParameter].vt)
      {
      case VT_I2:
         // m_LastParams.rgvarg[i].iVal = lpDispparams->rgvarg[i].iVal;
         TRACE("VT_I2 = %hu\n", m_LastParams.rgvarg[nParameter].iVal);
         stringMsg += itoa(m_LastParams.rgvarg[nParameter].iVal, fmtBuf, 10);
         break;

      case VT_I4:
         // m_LastParams.rgvarg[i].lVal = lpDispparams->rgvarg[i].lVal;
         TRACE("VT_I4 = %lu\n", m_LastParams.rgvarg[nParameter].lVal);
         stringMsg += ltoa(m_LastParams.rgvarg[nParameter].iVal, fmtBuf, 10);
         break;

      case VT_BSTR:
         // m_LastParams.rgvarg[i].bstrVal = ::SysAllocString(lpDispparams->rgvarg[i].bstrVal);
         TRACE("VT_BSTR = %s\n", (LPCTSTR) m_LastParams.rgvarg[nParameter].bstrVal);
         break;

      case VT_BOOL:
         // m_LastParams.rgvarg[i].bool = lpDispparams->rgvarg[i].bool;
         TRACE("VT_BOOL = %s\n", m_LastParams.rgvarg[nParameter].bool ? _T("TRUE") : _T("FALSE"));
         stringMsg += m_LastParams.rgvarg[nParameter].bool ? _T("TRUE") : _T("FALSE");
         break;
	                                                                      
      case VT_I2 | VT_BYREF:
         // m_LastParams.rgvarg[i].iVal = lpDispparams->rgvarg[i].iVal;
         TRACE("VT_I2 | VT_BYREF = %hu\n", *m_LastParams.rgvarg[nParameter].piVal);
         stringMsg += itoa(*m_LastParams.rgvarg[nParameter].piVal, fmtBuf, 10);
         break;

      case VT_I4 | VT_BYREF:
         // m_LastParams.rgvarg[i].lVal = lpDispparams->rgvarg[i].lVal;
         TRACE("VT_I4 | VT_BYREF = %lu\n", *m_LastParams.rgvarg[nParameter].plVal);
         stringMsg += ltoa(*m_LastParams.rgvarg[nParameter].piVal, fmtBuf, 10);
         break;

      case VT_BSTR | VT_BYREF:
         // m_LastParams.rgvarg[i].bstrVal = ::SysAllocString(lpDispparams->rgvarg[i].bstrVal);
         TRACE("VT_BSTR | VT_BYREF = %s\n", *(LPCTSTR*) m_LastParams.rgvarg[nParameter].pbstrVal);
         stringMsg += *(LPCTSTR*) m_LastParams.rgvarg[nParameter].bstrVal;
         break;

      case VT_BOOL | VT_BYREF:
         // m_LastParams.rgvarg[i].bool = lpDispparams->rgvarg[i].bool;
         TRACE("VT_BOOL | VT_BYREF = %s\n", (*m_LastParams.rgvarg[nParameter].pbool ? _T("TRUE") : _T("FALSE")));
         stringMsg += (*m_LastParams.rgvarg[nParameter].pbool ? _T("TRUE") : _T("FALSE"));
         break;
	                                                                      
      }
   }

   stringMsg += _T(")\n");
   TRACE(stringMsg);
#endif // _DEBUG

   // Get pointer to our document
   CVogonDoc* pDoc = (CVogonDoc*) GetDocument();
   ASSERT(pDoc);
   // Call the appropriate function: this is hard-coded for Webster ...
   #define EVENT_INDEX_DOCLICKURL (1)
   #define EVENT_INDEX_KEYDOWN    (2)
   // Which event routine to call ?
   switch (m_EventID)
   {
      case EVENT_INDEX_DOCLICKURL:
         // eventDoClickURL(BSTR* SelectedURL, BOOL* Cancel);
         pDoc->eventDoClickURL(m_LastParams.rgvarg[0].pbstrVal, m_LastParams.rgvarg[1].pbool);
         break;

      case EVENT_INDEX_KEYDOWN:
         // eventKeyDown(short* KeyCode, short Shift);
         pDoc->eventKeyDown(m_LastParams.rgvarg[0].piVal, m_LastParams.rgvarg[1].iVal);
         break;
   }
}

#ifdef JUST_FOR_REFERENCE
// These are define in OLEAuto.h ..
typedef struct  tagDISPPARAMS
    {
    /* [size_is] */ VARIANTARG __RPC_FAR *rgvarg;
    /* [size_is] */ DISPID __RPC_FAR *rgdispidNamedArgs;
    UINT cArgs;
    UINT cNamedArgs;
    }	DISPPARAMS;

struct tagVARIANT{
    VARTYPE vt;
    WORD wReserved1;
    WORD wReserved2;
    WORD wReserved3;
    union
    {
      unsigned char bVal;           /* VT_UI1               */
      short         iVal;           /* VT_I2                */
      long          lVal;           /* VT_I4                */
      float         fltVal;         /* VT_R4                */
      double        dblVal;         /* VT_R8                */
      VARIANT_BOOL  bool;           /* VT_BOOL              */
      SCODE         scode;          /* VT_ERROR             */
      CY            cyVal;          /* VT_CY                */
      DATE          date;           /* VT_DATE              */
      BSTR          bstrVal;        /* VT_BSTR              */
      IUnknown      *punkVal;       /* VT_UNKNOWN           */
      IDispatch     *pdispVal;      /* VT_DISPATCH          */
      SAFEARRAY     *parray;        /* VT_ARRAY|*           */
      unsigned char *pbVal;         /* VT_BYREF|VT_UI1      */
      short         *piVal;         /* VT_BYREF|VT_I2       */
      long          *plVal;         /* VT_BYREF|VT_I4       */
      float         *pfltVal;       /* VT_BYREF|VT_R4       */
      double        *pdblVal;       /* VT_BYREF|VT_R8       */
      VARIANT_BOOL  *pbool;         /* VT_BYREF|VT_BOOL     */
      SCODE         *pscode;        /* VT_BYREF|VT_ERROR    */
      CY            *pcyVal;        /* VT_BYREF|VT_CY       */
      DATE          *pdate;         /* VT_BYREF|VT_DATE     */
      BSTR          *pbstrVal;      /* VT_BYREF|VT_BSTR     */
      IUnknown      **ppunkVal;     /* VT_BYREF|VT_UNKNOWN  */
      IDispatch     **ppdispVal;    /* VT_BYREF|VT_DISPATCH */
      SAFEARRAY     **pparray;      /* VT_BYREF|VT_ARRAY|*  */
      VARIANT       *pvarVal;       /* VT_BYREF|VT_VARIANT  */
      void     * byref;             /* Generic ByRef        */
    }
#if(defined(NONAMELESSUNION))
    u
#endif
     ;
};
#endif // JUST_FOR_REFERENCE

/////////////////////////////////////////////////////////////////////////////
//  CVogonCntrItem::XEventHandler
 
 
STDMETHODIMP_(ULONG) CVogonCntrItem::XEventHandler::AddRef()
{
    METHOD_PROLOGUE(CVogonCntrItem, EventHandler)
    return (ULONG)pThis->ExternalAddRef();
}
 
 
STDMETHODIMP_(ULONG) CVogonCntrItem::XEventHandler::Release()
{
    METHOD_PROLOGUE(CVogonCntrItem, EventHandler)
    return (ULONG)pThis->ExternalRelease();
}
 
 
STDMETHODIMP CVogonCntrItem::XEventHandler::QueryInterface(
    REFIID iid, LPVOID far* ppvObj)
{
    METHOD_PROLOGUE(CVogonCntrItem, EventHandler)
    return (HRESULT)pThis->ExternalQueryInterface(&iid, ppvObj);
}
 
 
STDMETHODIMP CVogonCntrItem::XEventHandler::GetTypeInfoCount(unsigned int FAR* pctinfo)
{
    METHOD_PROLOGUE(CVogonCntrItem, EventHandler)
    ASSERT_VALID(pThis);

    *pctinfo = 0;
    return NOERROR;
}
 
 
STDMETHODIMP CVogonCntrItem::XEventHandler::GetTypeInfo(unsigned int itinfo,
      LCID lcid, ITypeInfo FAR* FAR* pptinfo)
{
    METHOD_PROLOGUE(CVogonCntrItem, EventHandler)
    ASSERT_VALID(pThis);
 
    return ResultFromScode(E_NOTIMPL);
}
 
 
STDMETHODIMP CVogonCntrItem::XEventHandler::GetIDsOfNames(REFIID riid,
      LPTSTR FAR* rgszNames, unsigned int cNames, LCID lcid,
      DISPID FAR* rgdispid)
{
    METHOD_PROLOGUE(CVogonCntrItem, EventHandler)
    ASSERT_VALID(pThis);
 
    return ResultFromScode(E_NOTIMPL);
}

 
STDMETHODIMP CVogonCntrItem::XEventHandler::Invoke(DISPID dispidMember,
      REFIID riid, LCID lcid, unsigned short wFlags, DISPPARAMS FAR* lpDispparams,
      VARIANT FAR* pvarResult, EXCEPINFO FAR* pexcepinfo, 
      unsigned int FAR* puArgErr)
{
    METHOD_PROLOGUE(CVogonCntrItem, EventHandler)
    ASSERT_VALID(pThis);

	pThis->OnEvent(dispidMember, lpDispparams);	// Call the event handler, who also cleans up.
	
	return NOERROR;
}
                                          

/////////////////////////////////////////////////////////////////////////////
// 
void CVogonCntrItem::OnActivate()
{
   // Let the base class do it's thing
   COleClientItem::OnActivate();
   // Create a dispatch interface for our Webster:
   LPDISPATCH pd = GetIDispatch();
   TRACE("CVogonCntrItem::OnActivate IDispatch at %x\n", pd);
   m_dWebster.AttachDispatch(pd);
}

/////////////////////////////////////////////////////////////////////////////
// 
void CVogonCntrItem::OnDeactivate()
{
   // Let the base class do it's thing
   COleClientItem::OnDeactivate();
   // Release the dispatch interface for our Webster:
   m_dWebster.ReleaseDispatch();
}

void CVogonCntrItem::OnChange(OLE_NOTIFICATION nCode, DWORD dwParam)
{
   ASSERT_VALID(this);

   COleClientItem::OnChange(nCode, dwParam);

   // When an item is being edited (either in-place or fully open)
   //  it sends OnChange notifications for changes in the state of the
   //  item or visual appearance of its content.

   // TODO: invalidate the item by calling UpdateAllViews
   //  (with hints appropriate to your application)

   GetDocument()->UpdateAllViews(NULL);
      // for now just update ALL views/no hints
}

BOOL CVogonCntrItem::OnChangeItemPosition(const CRect& rectPos)
{
   ASSERT_VALID(this);

   // During in-place activation CVogonCntrItem::OnChangeItemPosition
   //  is called by the server to change the position on of the in-place
   //  window.  Usually, this is a result of the data in the server
   //  document changing such that the extent has changed or as a result
   //  of in-place resizing.
   //
   // The default here is to call the base class, which will call
   //  COleClientItem::SetItemRects to move the item
   //  to the new position.

   if (IsInPlaceActive() && !COleClientItem::OnChangeItemPosition(rectPos))
      return FALSE;

   // TODO: update any cache you may have of the item's rectangle/extent

   return TRUE;
}

void CVogonCntrItem::OnGetItemPosition(CRect& rPosition)
{
   ASSERT_VALID(this);

   // During in-place activation, CVogonCntrItem::OnGetItemPosition
   //  will be called to determine the location of this item.  The default
   //  implementation created from AppWizard simply returns a hard-coded
   //  rectangle.  Usually, this rectangle would reflect the current
   //  position of the item relative to the view used for activation.
   //  You can obtain the view by calling CVogonCntrItem::GetActiveView.


   // We always fill our view:
   if (GetInPlaceWindow())
   {  // Object has a window: just get the current size
      GetInPlaceWindow()->GetWindowRect(rPosition);
   }
   else
   {  // Just fill the view
      GetActiveView()->GetClientRect(rPosition);
   }
   // TODO: return correct rectangle (in pixels) in rectPos

   // rPosition.SetRect(10, 10, 210, 210);
}

void CVogonCntrItem::OnDeactivateUI(BOOL bUndoable)
{
   COleClientItem::OnDeactivateUI(bUndoable);

   // Close an in-place active item whenever it removes the user
   //  interface.  The action here should match as closely as possible
   //  to the handling of the escape key in the view.

   Deactivate();   // nothing fancy here -- just deactivate the object
}

void CVogonCntrItem::Serialize(CArchive& ar)
{
   ASSERT_VALID(this);

   // Call base class first to read in COleClientItem data.
   // Since this sets up the m_pDocument pointer returned from
   //  CVogonCntrItem::GetDocument, it is a good idea to call
   //  the base class Serialize first.
   COleClientItem::Serialize(ar);

   // now store/retrieve data specific to CVogonCntrItem
   if (ar.IsStoring())
   {
      // TODO: add storing code here
   }
   else
   {  
      // TODO: add loading code here
   }
}

/////////////////////////////////////////////////////////////////////////////
// CVogonCntrItem diagnostics

#ifdef _DEBUG
void CVogonCntrItem::AssertValid() const
{
   COleClientItem::AssertValid();
}

void CVogonCntrItem::Dump(CDumpContext& dc) const
{
   COleClientItem::Dump(dc);
}
#endif

/////////////////////////////////////////////////////////////////////////////
//  This code is straight outa MSDN ...
//
LPDISPATCH CVogonCntrItem::GetIDispatch()
{
   ASSERT_VALID(this);
   ASSERT(m_lpObject != NULL);

   LPUNKNOWN lpUnk = m_lpObject;

   Run();	// must be running

   LPOLELINK lpOleLink = NULL;
   if (m_lpObject->QueryInterface(IID_IOleLink, (LPVOID FAR*)&lpOleLink) == NOERROR)
   {
      ASSERT(lpOleLink != NULL);
      lpUnk = NULL;
      if (lpOleLink->GetBoundSource(&lpUnk) != NOERROR)
      {
         TRACE0("Warning: Link is not connected!\n");
         lpOleLink->Release();
         return NULL;
      }
      ASSERT(lpUnk != NULL);
   }

   LPDISPATCH lpDispatch = NULL;
   if (lpUnk->QueryInterface(IID_IDispatch, (void**) &lpDispatch) != NOERROR)
   {
      TRACE0("Warning: does not support IDispatch!\n");
      return NULL;
   }

   ASSERT(lpDispatch != NULL);
   return lpDispatch;
}

