// mainfrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "vogon.h"

#include "mainfrm.h"
#include "UnRegDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// This code is straight from MSDN

#ifdef _WIN32
#define LOADLIBRARY_FAILED(x) (x == 0)
#include "winver.h"
#else
#define LOADLIBRARY_FAILED(x) (x <= HINSTANCE_ERROR)
#include "ver.h" 
#endif

#include <memory.h>

//
//
//
typedef HRESULT (STDAPICALLTYPE *CTLREGPROC)(void) ; //see COMPOBJ.H

//
//
//
CRegisterControl::CRegisterControl(CString PathName)
{
   m_strPathName = PathName ;
}

//
//
//
CRegisterControl::~CRegisterControl()
{
   m_strPathName.Empty() ; 
}

//
//
//
BOOL CRegisterControl::Register()
{
   BOOL bResult = FALSE;
   ASSERT(!m_strPathName.IsEmpty()) ;

   if (SupportsSelfRegister()) 
   {  
      char* szPathName = m_strPathName.GetBuffer(m_strPathName.GetLength()) ;
      HINSTANCE hModule = ::LoadLibrary(szPathName) ;
      m_strPathName.ReleaseBuffer(-1) ;
      if (LOADLIBRARY_FAILED(hModule)) return FALSE ;
            
      CTLREGPROC DLLRegisterServer = (CTLREGPROC)::GetProcAddress(hModule,"DllRegisterServer" ) ;
      if (DLLRegisterServer != NULL)
      {
         HRESULT regResult = DLLRegisterServer() ;
         bResult = (regResult == NOERROR) ; 
      }     
      ::FreeLibrary(hModule) ;          
         
   }
   return bResult;   
}

//
//
//
BOOL CRegisterControl::Unregister()
{
   BOOL bResult = FALSE ;
   ASSERT(!m_strPathName.IsEmpty()) ;

   if (SupportsSelfRegister()) 
   {                                    
      char* szPathName = m_strPathName.GetBuffer(m_strPathName.GetLength()) ;
      HMODULE hModule = ::LoadLibrary(szPathName) ;
      m_strPathName.ReleaseBuffer(-1) ;
      if (LOADLIBRARY_FAILED(hModule)) return FALSE ;
            
      CTLREGPROC DllUnregisterServer = (CTLREGPROC)::GetProcAddress(hModule,"DllUnregisterServer" ) ;
      if (DllUnregisterServer != NULL)
      {
         HRESULT regResult = DllUnregisterServer() ;
         bResult = (regResult == NOERROR) ; 
      }     
      FreeLibrary(hModule) ;
   }                                     
   return bResult;   
} 

//
//
//
BOOL CRegisterControl::SupportsSelfRegister()
{
   BOOL bResult = FALSE;
   DWORD  handle;
   DWORD  uiInfoSize;
   UINT  uiVerSize ;
   UINT  uiSize ;
   DWORD* lpBuffer;
   CString strName   ;
   char szName[128] ;

   // Get the size of the version information.
   uiInfoSize = ::GetFileVersionInfoSize((LPTSTR)(LPCTSTR)m_strPathName, &handle);
   if (uiInfoSize == 0) 
      return FALSE ;

   // Allocate a buffer for the version information.
   char* pbData = new char[uiInfoSize] ;

   // Fill the buffer with the version information.
   bResult = ::GetFileVersionInfo((LPTSTR)(LPCTSTR)m_strPathName, handle, uiInfoSize, pbData);  
   if (!bResult) goto NastyGoto ;

   // Get the translation information.
   bResult = ::VerQueryValue(pbData, "\\VarFileInfo\\Translation", (void**)&lpBuffer, &uiVerSize);
   if (!bResult) goto NastyGoto ;

   bResult = uiVerSize ;
   if (!bResult) goto NastyGoto ;

   // Build the path to the key OLESelfRegister using the translation information.
   wsprintf(szName,"\\StringFileInfo\\%04hX%04hX\\OLESelfRegister",LOWORD(*lpBuffer),HIWORD(*lpBuffer)) ;

   // Search for the key.
    bResult = ::VerQueryValue(pbData, szName, (void**)&lpBuffer, &uiSize);

NastyGoto:
   delete [] pbData ;
   return bResult ;
}

// END This code is straight from MSDN
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
   //{{AFX_MSG_MAP(CMainFrame)
   ON_WM_CREATE()
   ON_COMMAND(ID_VIEW_REGISTERWEBSTER, OnRegisterWebster)
   ON_COMMAND(ID_VIEW_UNREGISTERWEBSTER, OnUnregisterWebster)
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// arrays of IDs used to initialize control bars

// toolbar buttons - IDs are command buttons
static UINT BASED_CODE buttons[] =
{
   // same order as in the bitmap 'toolbar.bmp'
   ID_FILE_NEW,
   ID_FILE_OPEN,
   ID_FILE_SAVE,
      ID_SEPARATOR,
   ID_SHOW_PROPERTY_INSPECTOR,
      ID_SEPARATOR,
   ID_VIEW_SLIDESHOW,
   ID_VIEW_SLIDESHOW_SETUP,
      ID_SEPARATOR,
   ID_VIEW_URLFILTER,
      ID_SEPARATOR,
   ID_VIEW_ABOUTWEBSTER,
   ID_APP_ABOUT
};

static UINT BASED_CODE indicators[] =
{
   ID_SEPARATOR,           // status line indicator
   ID_INDICATOR_CAPS,
   ID_INDICATOR_NUM,
   ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
   // TODO: add member initialization code here
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
   if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
      return -1;

#ifdef _WIN32
   if (!m_wndToolBar.Create(this, CBRS_TOOLTIPS | WS_CHILD | WS_VISIBLE | CBRS_TOP) ||
#else   // not _WIN32
   if (!m_wndToolBar.Create(this, WS_CHILD | WS_VISIBLE | CBRS_TOP) ||
#endif  //     _WIN32
      !m_wndToolBar.LoadBitmap(IDR_MAINFRAME) ||
      !m_wndToolBar.SetButtons(buttons,
        sizeof(buttons)/sizeof(UINT)))
   {
      TRACE("Failed to create toolbar\n");
      return -1;      // fail to create
   }

   if (!m_wndStatusBar.Create(this) ||
      !m_wndStatusBar.SetIndicators(indicators,
        sizeof(indicators)/sizeof(UINT)))
   {
      TRACE("Failed to create status bar\n");
      return -1;      // fail to create
   }
   else
   {  // Default hide the status bar
      m_wndStatusBar.ShowWindow(SW_HIDE);
      RecalcLayout();
   }

   return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
   CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
   CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

/////////////////////////////////////////////////////////////////////////////
//
void CMainFrame::OnRegisterWebster() 
{
   static char BASED_CODE szFilter[] = "OLE controls (*.ocx) | *.ocx | DLL's (*.dll) | *.dll | OCX and DLL (*.ocx; *.dll) | *.ocx;*.dll | All Files (*.*) | *.* ||" ;

   CFileDialog aDlg(TRUE, "OCX", "*.ocx;*.dll", OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST ,szFilter,this ) ;  

   if (aDlg.DoModal() == IDOK)
   {
      CString strCtlPathName = aDlg.GetPathName() ;
      CRegisterControl aCtlReg(strCtlPathName) ;
      if (aCtlReg.Register())
      {
            MessageBox("Successful control registration.","Control Registration.",MB_OK | MB_ICONINFORMATION) ;
      }
      else
      {
            MessageBox("Control registration failed.",NULL,MB_OK | MB_ICONEXCLAMATION) ;
      }
   }  
}

/////////////////////////////////////////////////////////////////////////////
//
void CMainFrame::OnUnregisterWebster() 
{
   CUnregisterDlg dlgUnReg(this);

   if(dlgUnReg.DoModal() == IDOK)
   {
      CRegisterControl aCtlReg(dlgUnReg.m_strThePath); 
      if (aCtlReg.Unregister())
      {
         MessageBox("Control unregistered successfully.","Control Registration.",MB_OK | MB_ICONINFORMATION) ;
      }
      else
      {
         MessageBox("Unable to unregister control.",NULL,MB_OK | MB_ICONEXCLAMATION) ;
      }     
   }
}


