// slides.cpp : implementation file
//

#include "stdafx.h"
#include "vogon.h"
#include "slides.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSlideShowDlg dialog


CSlideShowDlg::CSlideShowDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSlideShowDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSlideShowDlg)
	m_uintInterval = 10;
	m_doLoop = FALSE;
	m_stringSlideName = _T("");
	//}}AFX_DATA_INIT
}


void CSlideShowDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSlideShowDlg)
	DDX_Control(pDX, IDC_LIST_SLIDES, m_listboxSlides);
	DDX_Control(pDX, IDC_EDIT_SLIDE_NAME, m_editSlideName);
	DDX_Text(pDX, IDC_EDIT_INTERVAL, m_uintInterval);
	DDV_MinMaxUInt(pDX, m_uintInterval, 1, 38400);
	DDX_Check(pDX, IDC_CHECK_LOOP, m_doLoop);
	DDX_Text(pDX, IDC_EDIT_SLIDE_NAME, m_stringSlideName);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSlideShowDlg, CDialog)
	//{{AFX_MSG_MAP(CSlideShowDlg)
	ON_BN_CLICKED(IDC_BUTTON_ADD, OnButtonAdd)
	ON_BN_CLICKED(IDC_BUTTON_REMOVE, OnButtonRemove)
	ON_LBN_SELCHANGE(IDC_LIST_SLIDES, OnSelChangeListSlides)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSlideShowDlg message handlers

/////////////////////////////////////////////////////////////////////////////
//
BOOL CSlideShowDlg::OnInitDialog() 
{
   CDialog::OnInitDialog();
   // Load the list box:
   for (int i = 0; i <= m_pSlideList->GetUpperBound(); i++)
   {  // Add the slide to the list
      m_listboxSlides.AddString(m_pSlideList->GetAt(i));
   }
   // TODO: Add extra initialization here
   return TRUE;  // return TRUE unless you set the focus to a control
                 // EXCEPTION: OCX Property Pages should return FALSE
}

/////////////////////////////////////////////////////////////////////////////
//
void CSlideShowDlg::OnOK() 
{
	CDialog::OnOK();
   // Empty the URL list
   m_pSlideList->RemoveAll();
   // Unload the list box:
   for (int i = 0; i < m_listboxSlides.GetCount(); i++)
   {  // Get the slide from the list
      CString stringText;
      m_listboxSlides.GetText(i, stringText);
      // Add the URL to the string array
      m_pSlideList->Add(stringText);
   }
}

/////////////////////////////////////////////////////////////////////////////
//
void CSlideShowDlg::OnButtonAdd() 
{  // Add the string in the edit control
   CString stringText;
   // Get the text
   m_editSlideName.GetWindowText(stringText);
   // Avoid empty strings
   if (!stringText.IsEmpty())
   {  // Add it to the list box
      m_listboxSlides.AddString(stringText);
   }
}

/////////////////////////////////////////////////////////////////////////////
//
void CSlideShowDlg::OnButtonRemove() 
{  // Remove the highlighted strings: how many ?
   int size = m_listboxSlides.GetCount();
   if (size)
   {  // Have some items to remove: allocate index space
      LPINT pIndices = new int[size];
      // Get the indices
      int countSel = m_listboxSlides.GetSelItems(size, pIndices);
      // Delete items backwards to avoid index perturbration
      while (--countSel >= 0)
      {  // Delete the selected item:
         m_listboxSlides.DeleteString(pIndices[countSel]);
      }
      // Done with the indices
      delete [] pIndices;
   }
   // Clear out the edit box, nothing selected any more ..
   m_editSlideName.SetWindowText(_T(""));
}

/////////////////////////////////////////////////////////////////////////////
//
void CSlideShowDlg::OnSelChangeListSlides() 
{  // Just get the first selected item
   int index;
   int countSel = m_listboxSlides.GetSelItems(1, &index);
   if (countSel)
   {  // Get the item
      CString stringText;
      m_listboxSlides.GetText(index, stringText);
      // Copy to the edit control
      m_editSlideName.SetWindowText(stringText);
   }
}
