
#include <InterViews/button.h>
#include <InterViews/world.h>
#include <stdio.h>
#include "fbrowser.h"

static PropertyData properties[] = {
    { "ifb*sample", "The quick brown fox..." },
    { "ifb*choice*font",
        "*-*-times-medium-r-normal-*-*-120-*-*-*-*-iso8859-1"
    },
    { "ifb*label*font",
        "*-*-times-bold-r-normal-*-*-120-*-*-*-*-iso8859-1"
    },
    { "ifb*PushButton*font",
        "*-*-times-medium-i-normal-*-*-140-*-*-*-*-iso8859-1"
    },
    { nil }
};

static OptionDesc options[] = {
    { "-sample", "ifb*sample", OptionValueNext },
    { nil }
};

int IVMain (int argc, char** argv) {
    World* world = new World("ifb", properties, options, argc, argv);
    ButtonState* quit = new ButtonState((int)false);
    FontBrowser* browser = new FontBrowser(
        quit, world->GetAttribute("sample")
    );

    browser->SetName("InterViews font browser");
    browser->SetIconName("ifb");

    world->InsertApplication(browser);
    browser->Accept();
    world->Remove(browser);

//    puts(browser->Fontname());

    delete browser;
    Unref(quit);
    delete world;
    return 0;
}
