/*
 *  MS-dependent painter interface.
 */

#ifndef painterrep_h
#define painterrep_h

#include <Interviews\painter.h>
#include <Interviews\paint.h>
#include <Interviews\canvas.h>
#include <Interviews\X11\worldrep.h>

class PainterRep {
private:
    friend class Painter;
    friend class Dash;
    friend class PixelDash;
    friend class BitmapDash;

    PainterRep();
    ~PainterRep();
    void Copy(PainterRep*);
    void Get_DC(Canvas*);
    void Release_DC(Canvas*);
    void SetClipRectangle (Coord, Coord, Coord, Coord);
    void SetClipOrigin(Coord, Coord);
    void SetClipAll ();
    void SetDCAttributes(HDC);

    Color*   foreground;
    Color*   background;
    Font *   font;
    Pattern* pattern;
    RECT     clip_rect;

    boolean fillbg;
    boolean overwrite;
    boolean xor;
    boolean clip;
    boolean fill_next_primitive;

    HDC     hDC;
    HBRUSH  hBrush, holdBrush;
    HPEN    hPen, holdPen;
    HFONT   hFont, holdFont;
    HRGN    hRgn, holdRgn;
};


void DrawTransformedImage(
    HBITMAP src, int sx0, int sy0, HBITMAP mask, int mx0, int my0,
    HBITMAP d, unsigned int height, int dx0, int dy0,
    boolean stencil, unsigned long fg, unsigned long bg,
    HDC gc, class Transformer* matrix,
    int src_width, int src_height,
    int d_width, int d_height
);
#endif

