/*
 * Copyright (c) 1987, 1988, 1989 Stanford University
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Stanford not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Stanford makes no representations about
 * the suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * STANFORD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * Implementation of GraphicConstruct object construction function.
 */

#include <InterViews/Graphic/base.h>
#include <InterViews/Graphic/ellipses.h>
#include <InterViews/Graphic/instance.h>
#include <InterViews/Graphic/grclasses.h>
#include <InterViews/Graphic/grconstruct.h>
#include <InterViews/Graphic/label.h>
#include <InterViews/Graphic/lines.h>
#include <InterViews/Graphic/picture.h>
#include <InterViews/Graphic/polygons.h>
#include <InterViews/Graphic/rasterrect.h>
#include <InterViews/Graphic/splines.h>
#include <InterViews/Graphic/stencil.h>

Persistent* GraphicConstruct (ClassId id) {
    switch (id) {
	case _BOXOBJ:		return new BoxObj;
	case _BSPLINE:		return new BSpline;
	case _CIRCLE:		return new Circle;
	case _CLOSEDBSPLINE:	return new ClosedBSpline;
	case _ELLIPSE:		return new GEllipse;
	case _FILLBSPLINE:	return new FillBSpline;
	case _FILLCIRCLE:	return new FillCircle;
	case _FILLELLIPSE:	return new FillEllipse;
	case _FILLPOLYGON:	return new FillPolygon;
	case _FILLPOLYGONOBJ:	return new FillPolygonObj;
	case _FILLRECT:		return new GFillRect;
	case _FULL_GRAPHIC:	return new FullGraphic;
	case _GRAPHIC:		return new Graphic;
	case _INSTANCE:		return new Instance;
	case _LABEL:		return new Label;
	case _LINE:		return new Line;
	case _LINEOBJ:		return new LineObj;
	case _MULTILINE:	return new MultiLine;
	case _MULTILINEOBJ:	return new MultiLineObj;
	case _PBRUSH:		return new PBrush;
	case _PCOLOR:		return new PColor;
	case _PFONT:		return new PFont;
	case _PICTURE:		return new Picture;
	case _POINT:		return new Point;
	case _POINTOBJ:		return new PointObj;
	case _POLYGON:		return new GPolygon;
	case _PPATTERN:		return new PPattern;
	case _RASTERRECT:       return new RasterRect;
	case _RECT:		return new Rect;
	case _STENCIL:          return new Stencil;

	default:		return nil;
    }
}
