#include <InterViews\X11\palette.h>

Palette::Palette () {
    max_entry = 1;
    logPal = new LOG_PALETTE;
    logPal->palNumEntries = PALETTESIZE;
    logPal->palVersion = 0x300;
    for (int i = 0; i < PALETTESIZE; i++) {
	logPal->palPalEntry[i].peRed = 0;
	logPal->palPalEntry[i].peGreen = 0;
	logPal->palPalEntry[i].peBlue = 0;
	logPal->palPalEntry[i].peFlags = PC_NOCOLLAPSE;
    }
    pal = CreatePalette((LPLOGPALETTE)logPal);
}

Palette::~Palette () {
    delete logPal;
			    // Palette noch lschen
}

void Palette::Realize (HDC hDC) {
    SelectPalette(hDC, pal, 0);
    RealizePalette(hDC);
}

int Palette::SetEntry (
    ColorIntensity r, ColorIntensity g, ColorIntensity b
) {
    PALETTEENTRY entry, nearestEntry;

 /* Falls das RGB Tripple bereits in der Farbpalette eingetragen ist,
    wird der Index dieses Eintrages zurckgeliefert */

    DWORD rgb = RGB(LOWORD(r), LOWORD(g), LOWORD(b));
    int nearestIndex = GetNearestPaletteIndex(pal, rgb);
    GetPaletteEntries(pal, nearestIndex, 1, &nearestEntry);
    if (LOWORD(r) == nearestEntry.peRed &&
	LOWORD(g) == nearestEntry.peGreen &&
	LOWORD(b) == nearestEntry.peBlue) {
	 return nearestIndex;
    }

 /* Ein neuer Eintrag erfolgt nur mit unbekannten RGB Werten. Falls der
    Eintrag aus irgendeinem Grund fehlschlgt, wird der Index 0 zurck-
    geliefert, der der Farbe Schwarz entspricht. */

    entry.peRed   = LOWORD(r);
    entry.peGreen = LOWORD(g);
    entry.peBlue  = LOWORD(b);
    entry.peFlags = PC_NOCOLLAPSE;

    if (SetPaletteEntries(pal, max_entry, 1, &entry)) {
	return max_entry++;
    } else {
	return 0;
    }
}

int Palette::GetPaletteIndex(DWORD rgb) {
    return GetNearestPaletteIndex(pal, rgb);
}
