(******************************************************************************
*                                   XExecD                                    *
*                                                                             *
* Interface unit to XEXEC.DLL.                                                *
*                                                                             *
* Written by Golan Yaniv (C) 1994                                             *
*                                                                             *
* This file is part of the XSpawn package.                                    *
*                                                                             *
******************************************************************************)
unit XExecD;

interface

uses WinTypes
    ;

const
    { options in WXSpawn's wOptions field. this values are also }
    { returned by WXGetFileOS : }
    WXO_OSTYPEMASK  = $000F;    { bits mask dedicated to os type }
    WXO_AUTO        = $0000;    { auto-detect os type from file }
    WXO_WIN         = $0001;    { force type = windows }
    WXO_DOS         = $0002;    { force type = dos }
    WXO_OS2         = $0003;    { force type = os2 }
    WXO_NT          = $0004;    { force type = nt }
    WXO_USESHELL    = $0010;    { use shell to execute }
    WXO_USEPIF      = $0020;    { use pif file - only for dos }

    { error codes (in low word) }
    { errors marked with * return additional info in high word }
    WX_APPEXEC      = $0001;    { application exec error (*) }
    WX_AGENTEXEC    = $0002;    { agent exec error (*) }
    WX_OUTOFMEM     = $0003;    { not enough memory }
    WX_AGENTCOMM    = $0004;    { unable to establish agent communication }
    WX_PIFFILE      = $0005;    { unable to create PIF file (*) }
    WX_NOAGENT      = $0006;    { agent not installed (*) }
    WX_UNKNOWNOS    = $0007;    { unknown os type }
    WX_BADVER       = $00F1;    { version mismatch (*) }
    WX_AGENTKILLED  = $00F2;    { agent was killed while waiting }
    WX_INVALIDHEXEC = $00F3;    { invalid hExec handle }

    { for WX_APPEXEC, high word contains WinExec error or : }
    WX_NOTFOUND     = $0101;    { path or file not found }
    WX_NOMEM        = $0102;    { not enough memory }
    WX_ARGLIST      = $0103;    { args list too long }
    WX_BADFORMAT    = $0104;    { bad exec format }
    WX_UNKNOWN      = $010F;    { unknown error }

    { returned by WXGetHostOS() : }
    WX_OS_WIN3X     = $0001;    { Windows 3.X }
    WX_OS_WINNT     = $0002;    { Windows NT }
    WX_OS_WINOS2    = $0003;    { Win-OS/2 }
    WX_OS_UNKNOWN   = $FFFF;    { Unknown Host OS }

function    WXSpawn(lpszFileName : pchar;
                    lpszArgs : pchar;
                    lpszDirectory : pchar;
                    nCmdShow : word;
                    wOptions : word;
                    var hExec : longint) : longint; 

function    WXIsDone(hExec: longint; 
                     lpdwErrorCode : PLongint;
                     lpdwExitCode : PLongint) : Bool; 

procedure   WXStopTracking(hExec: longint); 

procedure   WXSetDebugMode(bDebugFlag : Bool); 

function    WXGetVersion : word;

function    WXGetInstance(hExec : longint) : THandle; 

function    WXGetFileOs(lpszFileName : pchar) : word; 

procedure   WXGetError(dwErrorCode : longint; 
                       var wError : word; 
                       var wReason : word); 

function    WXGetHostOS : longint;

(******************************************************************************
*                               IMPLEMENTATION                                *
******************************************************************************)
IMPLEMENTATION
    

function    WXSpawn;        external 'XEXEC' index 1;

function    WXIsDone;       external 'XEXEC' index 2;

procedure   WXStopTracking; external 'XEXEC' index 3;

procedure   WXSetDebugMode; external 'XEXEC' index 4;

function    WXGetVersion;   external 'XEXEC' index 5;

function    WXGetInstance;  external 'XEXEC' index 6;

function    WXGetFileOs;    external 'XEXEC' index 7;

procedure   WXGetError;     external 'XEXEC' index 8;

function    WXGetHostOS;    external 'XEXEC' index 9;




end.
