#********************************************************************#
#**		      Microsoft GDK-LIBRARY			   **#
#**	       Copyright(c) Microsoft Corp., 1987, 1988, 1989,	   **#
#**					     1990, 1991		   **#
#**								   **#
#********************************************************************#


.SUFFIXES:
.SUFFIXES:	.src .dll .def .lnk .map .lib .c .asm

# Text for building copyright message in executable
#
COPYRIGHT = Copyright(c) Microsoft Corp., 1987,1988,1989,1990,1991
PRODUCT = SECURE_SAMPLE


# Where the components live

# drive for lanman
#
LANDRIVE = c:

# drive for c includes and libs
#
CDRIVE	 = c:

# drive for build files
#
DRIVE	 = c:

# lanman source path
#
LANROOT  = \lmptk\netsrc

# build dir
#
BUILDBAS = \samples\SECURE\build

# SECURE source base
#
SQLbase = \sql
GATEbase = \gdk

SRCDIR	 = \samples\SECURE\src
INCLBAS	 = \include
LANLIB	 = $(LANDRIVE)$(LANROOT)\lib
LANINC	 = $(LANDRIVE)$(LANROOT)\h
OBJDIR	 = $(DRIVE)$(GATEbase)$(BUILDBAS)\OBJ
SLOCATE  = $(DRIVE)$(GATEbase)$(SRCDIR)
BLDDIR	 = $(DRIVE)$(GATEbase)$(BUILDBAS)
EXEDIR	= $(DRIVE)$(SQLbase)\BINP

# debug switches for cl, link and masm
#
LDEBUG	 = /CO
DEBUG	 = i
MDEBUG	 =

INCDIR =  $(DRIVE)$(GATEbase)$(INCLBAS)
MNLIBS	= SECRCBSp.lib GDKp.lib pDBLIB.lib LAN.lib
CBLIBS	= LlibcDLL OS2 GDKp.lib pDBLIB.lib LAN.lib

# Definitions for new style linker
#
LINK	= link /SEGMENTS:255 $(LDEBUG)
IMPLIB	= implib

# What we call the final result.
#
DLLNAME  = SECRCBSp
GATELIB = $(DRIVE)$(GATEbase)\LIB
GATEDLL = $(DRIVE)$(SQLbase)\DLL

# Definitions for C compiler
#   - use Xenix style interface
#   - enable language extensions
#   - pack structures
#   - remove default library info from object files
#   - Maximum warnings
#   - enable 286 code generation
#   - disable stack checking
#   - small code pointers, near data pointers, SS != DS w/ DS autoload
#   - include debugging code
#   - typecheck library calls
#
CC	  = cl
M_CFLAGS  = $(COPTION) $(CDEFINE) $(COPTIMIZE) $(CMISC)
CFLAGS	  = $(M_CFLAGS) $(CMODEL) $(CSEGMENT)
COPTION   = -Zelp$(DEBUG) -G2
CMODEL	  = -Alfu -Lp
CDEFINE   = -DLINT_ARGS -D_MT -D_DLL -DDBMSOS2 -D_RPC
CSEGMENT  =
COPTIMIZE = -Op -Od
CMISC	  = -W3


# Definitions for assembler
#   - preserve case sensitivity
#   - suppress messages for successful assembly
#   - check for impure code
#
ASM	= masm
AFLAGS	= -ML -Mx -t -p $(MDEBUG)
AINC	=


# Object file for main routine
#
OBJS = \
    $(OBJDIR)\SECURE.obj

# Object files for callback DLL
#
OBJCBS = \
    $(OBJDIR)\SECRCBS.obj
    

# Header files for SECURE modules.
#
INCDEP = $(INCDIR)\srv.h


# Build the Dynamic Link Library, forces full build under nmake.
# This is the main dependency.
#
all : SECURE


# compile/assemble command lines for each source directory.
#
{$(SLOCATE)}.asm{$(OBJDIR)}.obj:
	$(ASM) $(AFLAGS) $(@B).asm, $(OBJDIR)\$(@B).obj;

{$(SLOCATE)}.c{$(OBJDIR)}.obj:
	$(CC) $(CFLAGS) -Fo$(OBJDIR)\$(@B).obj -c $(SLOCATE)\$(@B).c


# include dependencies
#
$(OBJDIR)\*.obj : $(INCDEP)


# Build the component object files
#
src :	$(OBJS) $(OBJCBS)


# Build the SECURE callback DLL
#
$(DLLNAME).def : 
	@echo Building $@...
	@echo LIBRARY $(DLLNAME) INITINSTANCE		>  $@
	@echo DESCRIPTION '$(PRODUCT) $(COPYRIGHT)'	>> $@
	@echo HEAPSIZE	 65536				>> $@
	@echo PROTMODE					>> $@
	@echo CODE LOADONCALL EXECUTEREAD NONCONFORMING >> $@
	@echo DATA PRELOAD READWRITE MULTIPLE NONSHARED >> $@
	@echo SEGMENTS					>> $@
	@echo	_TEXT					>> $@
	@echo	SECRCBS 				>> $@
	@echo EXPORTS					>> $@
	@echo	_init_server			@1	>> $@
	@echo	_set_remote_server_name		@2	>> $@
	@echo	_chk_err			@3	>> $@
	@echo	_set_security_options		@4	>> $@

# Additional export statements go here.


# Build linker response file.
#
$(DLLNAME).lnk: 
	@echo Building $@...
	@echo This line makes sure $@ file exists	    > $@
	@del $@
	@for %%i in ($(OBJDIR)\SECRCBS*.obj) do echo %%i + >> $@
	@echo.						   >> $@
	@echo $(GATEDLL)\$(DLLNAME).dll			   >> $@
	@echo.						   >> $@
	@echo /NOI /NOD $(CBLIBS)			   >> $@
	@echo $(DLLNAME).def				   >> $@

# Build import lib
#
$(GATELIB)\$(DLLNAME).lib: $(DLLNAME).def
	$(IMPLIB) $(GATELIB)\$(DLLNAME).lib $(DLLNAME).def
	@echo $(DLLNAME).lib built

# build DLL and all componets for it
#
$(GATEDLL)\$(DLLNAME).dll: $(DLLNAME).lnk $(OBJCBS)
	$(LINK) @$(DLLNAME).lnk
	@echo $(GATEDLL)\$(DLLNAME).dll built.


# Build the SECURE callback DLLs and executable
#
SECURE:  $(GATELIB)\$(DLLNAME).lib src $(GATEDLL)\$(DLLNAME).dll
	$(CC) $(CFLAGS) -Fm $(OBJDIR)\$(@B).obj -Fe$(EXEDIR)\$(@B).exe $(MNLIBS)
	exehdr /PMTYPE:WINDOWCOMPAT $(EXEDIR)\$(@B).exe

