
/* **********  SECURE Lan Manager security checking for SQL Server *******
*
* This program is an adaptation of the standard pass-through gateway.
* It implements a security integration layer between Lan Manager
* and SQL Server.  On as connection event (in SECURECBS.C) Lan Manager
* is queried for the name of the user on the other end of the pipe.
* This username is compared to the requested SQL Server login name,
* and the login is rejected if the two don't match.
*
* If the /F flag is given at startup, all language events will be written
* to the GDK log file prior to being passed on to SQL Server.
* The /N flag turns off userid checking.
*
* This application requires the LAN Manager 2.0 Programmer's Toolkit
* for compilation and linking.
*
***********************************************************************/



#include	<stdlib.h>
#include	<stdio.h>
#include	<string.h>

#define INCL_BASE
#include	<OS2.h>

#include	<sqlfront.h>
#include	<sqldb.h>

#include	<srv.h>


// Globals
//
DBCHAR	FAR *GDKsrvrname = "";  // The default remote server name
DBCHAR	FAR *GDKpipename = TDS34_CONNECT_NAME;	// Default pipe name

DBCHAR	FAR *GDKlogfile = "gateway.log";
BOOL fLogEnabled = FALSE;	 // request logging off by default
BOOL fConnectCheck = TRUE;	// LM connection verification on by default

// function prototypes
//
void getargs(int argc, char **argv );

void main( int argc, char **argv );

int	SRVAPI init_server	( SRV_SERVER FAR * server );

void	SRVAPI set_remote_server_name ( char FAR * name );

// New function for setting options
void	SRVAPI set_security_options ( BOOL logflag, BOOL checkflag );

int	chk_err      ( SRV_SERVER FAR * server,
		       SRV_PROC   FAR * srvproc,
		       int		srverror,
		       BYTE		severity,
		       BYTE		state,
		       int		oserrnum,
		       DBCHAR	  FAR * errtext,
		       int		errtextlen,
		       DBCHAR	  FAR * oserrtext,
		       int		oserrtextlen );

DBCHAR	FAR * getservername( int argc, char * argv[] );

DBCHAR FAR * getpipename(int argc, char* argv[]);

void main(argc, argv)
int	argc;
char	*argv[];
{
    SRV_CONFIG	FAR *config;	    // The GDK configuration structure
    SRV_SERVER	FAR *server;	    // The GDK service process

    //	Read any command line arguments.
    //
    getargs(argc, argv);

    //	Send the name retrieved to the gateway's DLL module
    //
    set_remote_server_name( GDKsrvrname );

    //	Set the logging and security checking flags
    //
    set_security_options( fLogEnabled, fConnectCheck );

    //	Allocate a configuration structure that is used to initialize
    //	the GDK application
    //
    config = srv_config_alloc();

    //	Allow 20 connections at a time.
    //
    srv_config( config, (DBINT)SRV_CONNECTIONS, "20", SRV_NULLTERM );

    //	Set the log file.
    //
    srv_config( config, (DBINT)SRV_LOGFILE, GDKlogfile, SRV_NULLTERM );

    //	Install the GDK error handler.
    //
    srv_errhandle( chk_err );

    //	Initialize the gateway GDK and save the server handle
    //	so it can be used in later functions.
    //
    server = srv_init( config, GDKpipename, SRV_NULLTERM );

    if( server == NULL )
    {
	printf( "Unable to initialize GDK.  Check log file.\n" );
	DosExit( EXIT_PROCESS, 1 );
    }

    // When starting the gateway, initialize the remote server structure.
    // This is done in the init_server() function.
    // All the other event handlers are also defined in the init_server()
    // function.
    //
    srv_handle(server, (DBINT)SRV_START, init_server);

    //	Now everything's ready to go with our GDK, so we
    //	start it and keep it going until we get a stop request.
    //
    srv_log( server, FALSE, " ", SRV_NULLTERM );    // insert blank line
    srv_log( server, TRUE,  "SECURE Starting", SRV_NULLTERM );

    printf( "\nSECURE Starting\n");

    srv_run(server);

}


//  GETARGS - getargs( argc, argv )
//
//  Read the command line arguments.
//
//  Inputs:
//	argc - int (from "main" entry)
//	argv - pointer to array of char pointers (from "main" entry)
//
//  Outputs:
//      VOID
//
void getargs( int argc, char *argv[] )
{
 
    int i;
    char *ptr;

	for (i = 1; i < argc; ++i)
	{
        if (argv[i][0] != '-' && argv[i][0] != '/')
        {
	    printf("Usage: secure [-S<server name> -p<pipe name> -F<log file> -N]\n");
            exit(1);
        }
        ptr = argv[i];
		switch (ptr[1])
		{
        case 'S':
            GDKsrvrname = ptr+2;
            break;
            
        case 'p':
            GDKpipename = ptr+2;
            break;

	case 'F':
	    fLogEnabled = TRUE;
	    if (argv[i][2] != NULL)
	    {
		 GDKlogfile = ptr+2;
	    }
            break;

	case 'N':
	    fConnectCheck = FALSE;
            break;

        default:
	    printf("Usage: secure [-S<server name> -p<pipe name> -F<log file> -N]\n");
            exit(1);
	}
    }
}
