#define _AFXWIN_INLINE  inline

//
// Include the MAGMAED header file. Has a list of messages & structures
//
#include "magmaed.h"
#include "magmaid.h"

////////////////////////////////////////////////////////////////////
// CMagmaEdit
//
// This header was taken from the CEdit declaration in mfc\include\afxwin.h
//
////////////////////////////////////////////////////////////////////
class CMagmaEdit : public CEdit
{
  DECLARE_DYNAMIC(CMagmaEdit)

// Constructors
public:
  CMagmaEdit();
  BOOL Create(DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID);
  BOOL GetStatus(MAGMAED_STATUS &meStatus)
  {
    return (BOOL) SendMessage(ME_QUERYSTATUS, 0, 
                              (LONG) (LPMAGMAED_STATUS) &meStatus);
  }

// Implementation
public:
  virtual ~CMagmaEdit();

// Misc
  int GetLastSearchPattern(LPSTR lpBuf = NULL);

protected:
  virtual WNDPROC* GetSuperWndProcAddr();
};


/////////////////////////////////////////////////////////////////////////////
//
// CMagmaEditView
//
//   Class declaration taken from mfc\include\afxext.h
//
//
/////////////////////////////////////////////////////////////////////////////

class CMagmaEditView : public CView
{
  DECLARE_DYNCREATE(CMagmaEditView)

// Construction
public:
  CMagmaEditView();
  static const DWORD dwStyleDefault;

// Attributes
public:
  // CEdit control access
  _AFXWIN_INLINE CMagmaEdit& GetEditCtrl() const;

  // presentation attributes
  CFont* GetPrinterFont() const;
  void SetPrinterFont(CFont* pFont);
  void SetTabStops(int nTabStops);

  // other attributes

// Operations
public:
  UINT  PrintInsideRect(CDC* pDC, RECT& rectLayout, UINT nIndexStart,
                       UINT nIndexStop);
  void SerializeRaw(CArchive& ar);

// Overrideables
protected:
  virtual void OnFindNext(LPCSTR lpszFind, BOOL bNext, BOOL bCase);
  virtual void OnReplaceSel(LPCSTR lpszFind, BOOL bNext, BOOL bCase,
                            LPCSTR lpszReplace);
  virtual void OnReplaceAll(LPCSTR lpszFind, LPCSTR lpszReplace,
                            BOOL bCase);
  virtual void OnTextNotFound(LPCSTR lpszFind = NULL);


// Implementation
public:
	virtual ~CMagmaEditView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
	virtual void OnDraw(CDC* pDC);
	virtual void Serialize(CArchive& ar);
	virtual void DeleteContents();
	void ReadFromArchive(CArchive& ar, DWORD nLen);
	void WriteToArchive(CArchive& ar);
	virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo);

        MAGMAED_STATUS &GetStatus()
        {
          MAGMAED_STATUS meStatus;
          GetEditCtrl().GetStatus(meStatus);
          return meStatus;
        }


	static const DWORD nMaxSize; // maximum number of characters supported


protected:
	int m_nTabStops;            // tab stops in dialog units

	CUIntArray m_aPageStart;    // array of starting pages
	HFONT m_hPrinterFont;       // if NULL, mirror display font
	HFONT m_hMirrorFont;        // font object used when mirroring

	// construction
	WNDPROC* GetSuperWndProcAddr();
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);

	// printing support
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo = NULL);
	BOOL PaginateTo(CDC* pDC, CPrintInfo* pInfo);

	// find & replace support
	void OnEditFindReplace(BOOL bFindOnly);

	// buffer access
	DWORD GetBufferLength() const;

	// special overrides for implementation
	virtual void CalcWindowRect(LPRECT lpClientRect,
		UINT nAdjustType = adjustBorder);

	//{{AFX_MSG(CMagmaEditView)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnPaint();
	afx_msg LRESULT OnSetFont(WPARAM wParam, LPARAM lParam);
	afx_msg void OnUpdateNeedSel(CCmdUI* pCmdUI);
	afx_msg void OnUpdateNeedClip(CCmdUI* pCmdUI);
	afx_msg void OnUpdateNeedText(CCmdUI* pCmdUI);
	afx_msg void OnUpdateNeedFind(CCmdUI* pCmdUI);
	afx_msg void OnUpdateEditUndo(CCmdUI* pCmdUI);
	afx_msg void OnEditChange();
	afx_msg void OnEditCut();
	afx_msg void OnEditCopy();
	afx_msg void OnEditPaste();
	afx_msg void OnEditClear();
	afx_msg void OnEditUndo();
	afx_msg void OnEditSelectAll();
	afx_msg void OnEditFind();
	afx_msg void OnEditReplace();
	afx_msg void OnEditRepeat();
	afx_msg LRESULT OnFindReplaceCmd(WPARAM wParam, LPARAM lParam);

	// MagmaEd extensions
	afx_msg void OnEditMarkLine();
	afx_msg void OnEditMarkLineRange();
	afx_msg void OnEditMarkStream();
	afx_msg void OnEditMarkRect();
	afx_msg void OnEditMarkReset();

	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

_AFXWIN_INLINE CMagmaEdit& CMagmaEditView::GetEditCtrl() const
	{ return * (CMagmaEdit*) this; }


