/*============================================================================
  testclik -- Demo program for ClickBar.DLL and ClickDlg.DLL

  File      : testclik.c

  Prototype : 

  Call      : 

  Library   : 

  7 February 1992 - dlcampbell
  (c) 1991 Campbell SoftWare
----------------------------------------------------------------------------*/
#define WINVER 0x0300
#include <windows.h>
#include <string.h>
#include <clickdlg.h>
#include <clickbar.h>

#include "testclik.h"

/*----------------------------------------------------------------------------
  Prototypes
----------------------------------------------------------------------------*/
BOOL FAR PASCAL AboutDlgProc(HWND, WORD, WORD, LONG);
BOOL FAR PASCAL PickDlgProc(HWND, WORD, WORD, LONG);
void MakeHelpPathName(char *);
long FAR PASCAL WndProc(HWND, WORD, WORD, LONG);

short   cxClient, cyClient;
int     InitSettings, OldInitSettings;

char    szAppName[] = "testclik";
HANDLE  hInst;
HANDLE  hClickBar, hClickDlg;
HWND    hWndMain;
HWND    hWndDlg = NULL;
HWND    hWndDlg2 = NULL;
HWND    hDlgModeLess;
FARPROC lpfnDisplayDlg, lpfnDlgMove, lpfnDlgSetup, lpfnDlgPlus;
FARPROC lpfnClickBarSetup;
static  FARPROC lpfnPickDlgProc;

char    szHelpFileName[EXE_NAME_MAX_SIZE+1];    /* Help file name*/

/*============================================================================
  WinMain -- main window procedure for TestClik

  File      : testclik.C

  Prototype : int PASCAL WinMain (HANDLE, HANDLE, LPSTR, int);

  Call      : WinMain (hInstance, hPrevInstance, lpszCmdParam, nCmdShow);

  Library   : 

  7 February 1992 - dlcampbell
  (c) 1991 Campbell SoftWare
----------------------------------------------------------------------------*/
#pragma warn -par                       /* nCmdShow, lpszCmdParam not used */
int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                                             LPSTR lpszCmdParam, int nCmdShow)
{
MSG         msg;
WNDCLASS    WndClass;
HDC         hdc;
TEXTMETRIC  tm;
HMENU       hMenu;
GLOBALHANDLE   MyStructHandle;
FPWYNAPSESTRUCT MyStruct;
static char szMenuTitle[21 + 1];

if (hPrevInstance)
   return FALSE;

WndClass.style         = CS_HREDRAW | CS_VREDRAW;
WndClass.lpfnWndProc   = (WNDPROC)WndProc;
WndClass.cbClsExtra    = 0;
WndClass.cbWndExtra    = 0;
WndClass.hInstance     = hInstance;
WndClass.hIcon         = LoadIcon(hInstance, szAppName);
WndClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
WndClass.hbrBackground = GetStockObject(WHITE_BRUSH);
WndClass.lpszMenuName  = szAppName;
WndClass.lpszClassName = szAppName;

RegisterClass(&WndClass);

hdc = CreateIC("DISPLAY", NULL, NULL, NULL);
   GetTextMetrics(hdc, &tm);
DeleteDC(hdc);

cxClient = GetSystemMetrics(SM_CXSCREEN);
cyClient = GetSystemMetrics(SM_CYSCREEN);

hClickBar = LoadLibrary("CLICKBAR.DLL");
if (hClickBar < 32)
   {
   FreeLibrary(hClickBar);
   MessageBox(GetFocus(),"Dynamic Link Library CLICKBAR.DLL must be present",
                                       szAppName, MB_ICONEXCLAMATION | MB_OK);
   return 0;
   }

hClickDlg = LoadLibrary("CLICKDLG.DLL");
if (hClickDlg < 32)
	{
   FreeLibrary(hClickDlg);
	MessageBox(GetFocus(),"Dynamic Link Library CLICKDLG.DLL must be present",
                                       szAppName, MB_ICONEXCLAMATION | MB_OK);
   return 0;
	}

lpfnDlgSetup      = GetProcAddress(hClickDlg,  "ClickBarDialogSetup");
lpfnDlgMove       = GetProcAddress(hClickDlg,  "ClickBarDialogMove");
lpfnDisplayDlg    = GetProcAddress(hClickDlg,  "ClickBarDialogProc");

lpfnClickBarSetup = GetProcAddress(hClickBar,  "ClickBarSetup");

MyStructHandle = GlobalAlloc(GHND, sizeof(WYNAPSE_STRUCT));
MyStruct = (FPWYNAPSESTRUCT)GlobalLock(MyStructHandle);
   lstrcpy(MyStruct->RegName, (LPSTR)"Your Name");  /* ClickBar RegName */
   MyStruct->RegNumber = 0;                         /* ClickBar RegNumber */
GlobalUnlock(MyStructHandle);

(*lpfnClickBarSetup)(MyStructHandle);

GlobalFree(MyStructHandle);

hWndMain = CreateWindow(szAppName,   /* window class name */
			               szAppName,  /* window caption */
			               WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
			               CW_USEDEFAULT,      /* initial x pos */
			               CW_USEDEFAULT,      /* initial y pos */
                        CW_USEDEFAULT, /* initial x size */
                        CW_USEDEFAULT, /* initial y size */
                        NULL,               /* parent window handle */
                        NULL,               /* window menu handle */
                        hInstance,          /* program instance handle */
			               NULL);              /* creation parameters */

hMenu = GetSystemMenu(hWndMain, FALSE);
AppendMenu(hMenu, MF_SEPARATOR, 0, NULL);
AppendMenu(hMenu, MF_STRING,    IDM_ABOUT, "About...");
AppendMenu(hMenu, MF_STRING,    IDM_Pick, "Pick...");
AppendMenu(hMenu, MF_STRING,    IDWHELP,  "Help....");

hInst = hInstance;

MakeHelpPathName(szHelpFileName);

ShowWindow(hWndMain, nCmdShow);
UpdateWindow(hWndMain);

hWndDlg = CreateDialog(hInst, "CLICK", hWndMain,
                                  MakeProcInstance((*lpfnDisplayDlg), hInst));

lstrcpy(szMenuTitle, "AbNormal");
SendDlgItemMessage(hWndDlg, IDXCOMBO, CB_ADDSTRING, 0, (LONG)(LPSTR)szMenuTitle);
lstrcpy(szMenuTitle, "AsNormal");
SendDlgItemMessage(hWndDlg, IDXCOMBO, CB_ADDSTRING, 0, (LONG)(LPSTR)szMenuTitle);
lstrcpy(szMenuTitle, "ProNormal");
SendDlgItemMessage(hWndDlg, IDXCOMBO, CB_ADDSTRING, 0, (LONG)(LPSTR)szMenuTitle);
lstrcpy(szMenuTitle, "Not Normal");
SendDlgItemMessage(hWndDlg, IDXCOMBO, CB_ADDSTRING, 0, (LONG)(LPSTR)szMenuTitle);
lstrcpy(szMenuTitle, "Huh?");
SendDlgItemMessage(hWndDlg, IDXCOMBO, CB_ADDSTRING, 0, (LONG)(LPSTR)szMenuTitle);
lstrcpy((LPSTR)szMenuTitle, "Normal");
SendDlgItemMessage(hWndDlg, IDXCOMBO, CB_ADDSTRING, 0, (LONG)(LPSTR)szMenuTitle);

SendDlgItemMessage(hWndDlg, IDXCOMBO, CB_SELECTSTRING, -1, (LONG)(LPSTR)szMenuTitle);

SendMessage(hWndMain, WM_NCACTIVATE, 1, 0L);

while (GetMessage(&msg, NULL, 0, 0))
   {
   if ((hWndDlg == 0 || !IsDialogMessage(hWndDlg, &msg)) && (hDlgModeLess == 0 || !IsDialogMessage(hDlgModeLess, &msg)))
      {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
      }
   }


/*----------------------------------------------------------------------------
  Now free the DLLs used in the application...
----------------------------------------------------------------------------*/
FreeLibrary(hClickBar);
FreeLibrary(hClickDlg);

return msg.wParam;
}                                       /* int PASCAL WinMain */
#pragma warn .par

/*============================================================================
  AboutDlgProc -- Displays the EGO box for the application

  File      : ExitWin.C

  Prototype : BOOL FAR PASCAL AboutDlgProc (HWND, WORD, WORD, LONG)

  Call      : AboutDlgProc (hDlg, message, wParam, lParam)

  Library   : 

  7 February 1992 - dlcampbell
  (c) 1991 Campbell SoftWare
----------------------------------------------------------------------------*/
BOOL FAR PASCAL AboutDlgProc (HWND hDlg, WORD message, WORD wParam,
                                                                  LONG lParam)
{
char szBuffer[100];

switch (message)
   {
   case WM_INITDIALOG :
      wsprintf(szBuffer, "%s at %s", (LPSTR) __DATE__, (LPSTR) __TIME__);
      SetWindowText(GetDlgItem(hDlg, ID_VERSION), szBuffer);
      return TRUE;

   case WM_COMMAND :
      switch (wParam)
         {
         case IDOK :
         case IDCANCEL :
            if (HIWORD(lParam) == BN_CLICKED)
               EndDialog(hDlg, wParam);
            return TRUE;

         default :
            return TRUE;
         }

   default :
      return FALSE;
   }
}                                       /* AboutDlgProc */

/*============================================================================
  PickDlgProc -- Displays the EGO box for the application

  File      : ExitWin.C

  Prototype : BOOL FAR PASCAL PickDlgProc (HWND, WORD, WORD, LONG)

  Call      : PickDlgProc (hDlg, message, wParam, lParam)

  Library   : 

  7 February 1992 - dlcampbell
  (c) 1991 Campbell SoftWare
----------------------------------------------------------------------------*/
BOOL FAR PASCAL PickDlgProc (HWND hDlg, WORD message, WORD wParam,
                                                                  LONG lParam)
{
char szBuffer[100];
static char szType[30 + 1];

switch (message)
   {
   case WM_COMMAND :
      switch (wParam)
         {
         case IDRWLRARROW :
            if (HIWORD(lParam) == BN_CLICKED)
               DestroyWindow(hDlg);
            return TRUE;

         case IDRWBRUSH : 
            strcpy(szType, "IDRWBRUSH");
            break;

         case IDRWCUT : 
            strcpy(szType, "IDRWCUT");
            break;

         case IDRWDARROW : 
            strcpy(szType, "IDRWDARROW");
            break;

         case IDRWERASE : 
            strcpy(szType, "IDRWERASE");
            break;

         case IDRWKEY : 
            strcpy(szType, "IDRWKEY");
            break;

         case IDRWLARROW : 
            strcpy(szType, "IDRWLARROW");
            break;

         case IDRWLRMARGIN : 
            strcpy(szType, "IDRWLRMARGIN");
            break;

         default :
            return TRUE;
         }

      MessageBox(GetFocus(), szType, szAppName, MB_ICONEXCLAMATION | MB_OK);
      return 0;

   case WM_CLOSE : 
      DestroyWindow(hDlg);
      hDlgModeLess = 0;
      break;

   default :
      return FALSE;
   }
}                                       /* PickDlgProc */

/*============================================================================
  WndProc -- handles all Windows functions for the application

  File      : testclik.C

  Prototype : long FAR PASCAL WndProc(HWND, WORD, WORD, LONG);

  Call      : WndProc(hWnd, message, wParam, lParam);

  Library   :

  7 February 1992 - dlcampbell
  (c) 1991 Campbell SoftWare
----------------------------------------------------------------------------*/
long FAR PASCAL WndProc (HWND hWnd, WORD message, WORD wParam, LONG lParam)
{
static FARPROC lpfnAboutDlgProc;
static char szType[30 + 1];
HMENU  hMainMenu;

switch (message)
   {
   case WM_NCCREATE:
      (*lpfnDlgSetup)(hWnd);

/*----------------------------------------------------------------------------
  Allow Windows to allocate memory for window.
----------------------------------------------------------------------------*/
      if (!((BOOL) DefWindowProc(hWnd, message, wParam, lParam)))
         return 0;

      return TRUE;

   case WM_SYSCOMMAND :
      switch (wParam)
         {
         case IDM_ABOUT :
            lpfnAboutDlgProc = MakeProcInstance(AboutDlgProc, hInst);
            DialogBox(hInst, "About", hWnd, lpfnAboutDlgProc);
            FreeProcInstance(lpfnAboutDlgProc);
            return 0;

         case IDM_Pick :
            lpfnPickDlgProc = MakeProcInstance(PickDlgProc, hInst);
            hDlgModeLess = CreateDialog(hInst, "Pick", hWnd, lpfnPickDlgProc);
            return 0;

         case IDWHELP :
            WinHelp(hWnd, szHelpFileName, HELP_INDEX, 0L);
            return 0;

         }

      break;

   case WM_SIZE :
   case WM_MOVE :
     (*lpfnDlgMove)();
      break;

   case WM_COMMAND :
      hMainMenu = GetMenu(hWnd);

      switch (wParam)
         {
         case IDM_ABOUT :
            lpfnAboutDlgProc = MakeProcInstance(AboutDlgProc, hInst);
            DialogBox(hInst, "About", hWnd, lpfnAboutDlgProc);
            FreeProcInstance(lpfnAboutDlgProc);
            return 0;

         case IDWHELP :
            WinHelp(hWnd, szHelpFileName, HELP_INDEX, 0L);
            return 0;

         case IDXLARROW : 
            strcpy(szType, "IDXLARROW");
            break;

         case IDXRARROW : 
            strcpy(szType, "IDXRARROW");
            break;

         case IDXOUTLINE :
            strcpy(szType, "IDXOUTLINE");
            break;

         case IDXVISIBLE :
            strcpy(szType, "IDXVISIBLE");
            break;

         case IDXSUM     :
            strcpy(szType, "IDXSUM");
            break;

         case IDXBOLD    :
            strcpy(szType, "IDXBOLD");
            break;

         case IDXITALIC  :
            strcpy(szType, "IDXITALIC");
            break;

         case IDXLJUST   :
            strcpy(szType, "IDXLJUST");
            break;

         case IDXCENTER  :
            strcpy(szType, "IDXCENTER");
            break;

         case IDXRJUST   :
            strcpy(szType, "IDXRJUST");
            break;

         case IDXSELECT  :
            strcpy(szType, "IDXSELECT");
            break;

         case IDXLINE    :
            strcpy(szType, "IDXLINE");
            break;

         case IDXRECT    :
            strcpy(szType, "IDXRECT");
            break;

         case IDXOVAL    :
            strcpy(szType, "IDXOVAL");
            break;

         case IDXARC     :
            strcpy(szType, "IDXARC");
            break;

         case IDXCHART   :
            strcpy(szType, "IDXCHART");
            break;

         case IDXTEXT    :
            strcpy(szType, "IDXTEXT");
            break;

         case IDXBTN     :
            strcpy(szType, "IDXBTN");
            break;

         case IDXCAMERA  :
            strcpy(szType, "IDXCAMERA");
            break;

         default :
            return 0;
         }

      MessageBox(hWnd, szType, szAppName, MB_ICONEXCLAMATION | MB_OK);
      return 0;


   case WM_DESTROY :
      PostQuitMessage(0);
      return 0;
   }
return DefWindowProc(hWnd, message, wParam, lParam);
}                                       /* long FAR PASCAL WndProc */

/*============================================================================
  MakeHelpPathName -- sets up the path-spec for the help function

  File      : testclik.C

  Prototype : void MakeHelpPathName(char *);

  Call      : MakeHelpPathName(szFileName);

  Library   : 

  7 February 1992 - dlcampbell
  (c) 1991 Campbell SoftWare
----------------------------------------------------------------------------*/
void MakeHelpPathName (char * szFileName)
{
char *pcFileName;
int  nFileNameLen;

nFileNameLen = GetModuleFileName(hInst,szFileName,EXE_NAME_MAX_SIZE);
pcFileName = szFileName + nFileNameLen;

while (pcFileName > szFileName)
   {
   if (*pcFileName == '\\' || *pcFileName == ':')
      {
      *(++pcFileName) = '\0';
      break;
      }
   nFileNameLen--;
   pcFileName--;
   }

if ((nFileNameLen+13) < EXE_NAME_MAX_SIZE)
   lstrcat(szFileName, "testclik.hlp");
else
   lstrcat(szFileName, "?");
return;
}                                       /* MakeHelpPathName */
