;
; DPMI10.ASM (c) Rainer Schnitker  '93
;

;
; 16bit library for DPMI 0.9 calls
;
; define 'HAVE386' to use 32bit DPMI mode
;

	.286
	.model SMALL, C

; macro to call dpmi in ax
;
DPMI MACRO function
	mov ax,function
	int 31h
	ENDM

getdword MACRO high,low,address
	mov low,word ptr address
	mov high,word ptr address.2
	ENDM

setdword MACRO address,high,low
	mov word ptr address,low
	mov word ptr address.2,high
	ENDM


	.data

	.code

   ;
   ;	int GetMultipleDescriptors(WORD anzahl,WORD *buffer)
   ;
	public	C GetMultipleDescriptors
GetMultipleDescriptors PROC C USES DI, \
	anzahl	:WORD, \
	buffer	:PTR

	mov	cx, anzahl
	push	ds
	pop	es
ifdef HAVE386
	.386
	movzx	edi, word ptr buffer
	.286
else
	mov	di, word ptr buffer
endif
	DPMI 000Eh
	jc	short @@end
	xor	ax,ax
@@end:
	ret
GetMultipleDescriptors endp

   ;
   ;	int SetMultipleDescriptors(WORD anzahl,WORD *buffer)
   ;
	public	C SetMultipleDescriptors
SetMultipleDescriptors PROC C USES DI, \
	anzahl	:WORD, \
	buffer	:PTR

	mov	cx, anzahl
	push	ds
	pop	es
ifdef HAVE386
	.386
	movzx	edi, word ptr buffer
	.286
else
	mov	di, word ptr buffer
endif
	DPMI 000Fh
	jc	short @@end
	xor	ax,ax
@@end:
	ret
SetMultipleDescriptors endp

   ;
   ;	int GetProtModeExceptionVector32(BYTE no,WORD *sel,DWORD *off)
   ;
	public	C GetProtModeExceptionVector32
GetProtModeExceptionVector32 PROC C \
	no	:BYTE , \
	segm	:PTR , \
	offs	:PTR

	mov	bl,no
	DPMI 0210h
	jc	short @@end

	mov	bx,segm
	mov	word ptr [bx],cx
	mov	bx,offs
	mov	word ptr [bx],dx
	.386
	shr	edx,16
	.286
	mov	word ptr [bx].2,dx

	xor	ax,ax
@@end:
	ret
GetProtModeExceptionVector32   endp

   ;
   ;	int GetRealModeExceptionVector32(BYTE no,WORD *sel,DWORD *off)
   ;
	public	C GetRealModeExceptionVector32
GetRealModeExceptionVector32 PROC C \
	no	:BYTE , \
	segm	:PTR , \
	offs	:PTR

	mov	bl,no
	DPMI 0211h
	jc	short @@end

	mov	bx,segm
	mov	word ptr [bx],cx
	mov	bx,offs
	mov	word ptr [bx],dx
	.386
	shr	edx,16
	.286
	mov	word ptr [bx].2,dx
	xor	ax,ax
@@end:
	ret
GetRealModeExceptionVector32   endp

   ;
   ;	int SetProtModeExceptionVector32(BYTE b,WORD sel,DWORD off)
   ;
	public	C SetProtModeExceptionVector32
SetProtModeExceptionVector32 PROC C \
	b	:BYTE , \
	segm	:WORD , \
	offs	:DWORD

	mov	bl,b
	mov	cx,segm
	.386
	mov	edx,offs
	.286
	DPMI 0212h
	jc	short @@end

	xor	ax,ax
@@end:
	.386
	xor	edx,edx
	.286
	ret
SetProtModeExceptionVector32   endp

   ;
   ;	int SetRealModeExceptionVector32(BYTE b,WORD sel,DWORD off)
   ;
	public	C SetRealModeExceptionVector32
SetRealModeExceptionVector32 PROC C \
	b	:BYTE , \
	segm	:WORD , \
	offs	:DWORD

	mov	bl,b
	mov	cx,segm
	.386
	mov	edx,offs
	.286
	DPMI 0213h
	jc	short @@end

	xor	ax,ax
@@end:
	.386
	xor	edx,edx
	.286
	ret
SetRealModeExceptionVector32   endp


   ;
   ;	void GetDPMICapabilities(DPMICAP *v,BYTE *buffer)
   ;
	public	C GetDPMICapabilities
GetDPMICapabilities PROC C USES DI, \
	cap	:WORD, \
	buffer	:WORD

	push	ds
	pop	es
ifdef HAVE386
	.386
	movzx	edi, word ptr buffer
	.286
else
	mov	di, word ptr buffer
endif
	DPMI 0401h
	jc	short @@end
	mov	bx, word ptr cap
	mov	word ptr [bx  ],ax
	mov	word ptr [bx+2],cx
	mov	word ptr [bx+4],dx
	xor	ax,ax
@@end:
	ret
GetDPMICapabilities endp


ifdef HAVE386
   ;
   ;	int AllocLinearMemory(DWORD bytes,DWORD linaddress,DWORD flags,
   ;			      DWORD *handle,DWORD *memaddress)
   ;
	public	C AllocLinearMemory
AllocLinearMemory PROC C \
	nbytes	:DWORD , \
	linaddr :DWORD , \
	flags	:DWORD , \
	handle	:PTR , \
	memadr	:PTR

	.386
	push	esi
	mov	ecx, nbytes
	mov	ebx, linaddr
	mov	edx, flags
	DPMI 0504h
	jc	short @@end

	movzx	edx, word ptr handle
	mov	dword ptr [edx], esi
	movzx	edx, word ptr memadr
	mov	dword ptr [edx], ebx
	xor	ax, ax
@@end:
	xor	ecx, ecx
	xor	edx, edx
	xor	ebx, ebx
	pop	esi
	.286

	ret
AllocLinearMemory  endp

   ;
   ;	int ResizeLinearMemory(DWORD bytes,DWORD handle,DWORD flags
   ;			      DWORD *newhandle,DWORD *newmemaddress)
   ;
	public	C ResizeLinearMemory
ResizeLinearMemory PROC C \
	nbytes	:DWORD , \
	handle	:DWORD , \
	flags	:DWORD , \
	new_handle:PTR , \
	new_memadr:PTR

	.386
	push	esi
	mov	esi, handle
	mov	ecx, nbytes
	mov	edx, flags
	DPMI 0505h
	jc	short @@end

	movzx	edx, word ptr new_handle
	mov	[edx], esi
	movzx	edx, word ptr new_memadr
	mov	[edx], ebx
	xor	ax, ax
@@end:
	xor	ebx, ebx
	xor	ecx, ecx
	pop	esi
	.286

	ret
ResizeLinearMemory  endp

   ;
   ;	int GetPageAttributes(DWORD handle,DWORD offs,DWORD pages,WORD *attr)
   ;
	public	C GetPageAttributes
GetPageAttributes PROC C \
	handle	:DWORD , \
	offs	:DWORD , \
	pages	:DWORD , \
	attr	:PTR

	.386
	push	esi
	push	ebx
	push	ds
	pop	es
	mov	esi, handle
	mov	ebx, offs
	mov	ecx, pages
	movzx	edx, attr
	DPMI 0506h
	jc	short @@end

	xor	ax, ax
@@end:
	xor	ecx, ecx
	xor	edx, edx
	pop	ebx
	pop	esi
	.286

	ret
GetPageAttributes  endp

   ;
   ;	int ModifyPageAttributes(DWORD handle,DWORD offs,DWORD pages,WORD *attr)
   ;
	public	C ModifyPageAttributes
ModifyPageAttributes PROC C \
	handle	:DWORD , \
	offs	:DWORD , \
	npages	:DWORD , \
	attr	:PTR

	.386
	push	esi
	push	ebx
	push	ds
	pop	es
	mov	esi, handle
	mov	ebx, offs
	mov	ecx, npages
	movzx	edx, word ptr attr
	DPMI 0507h
	jc	short @@end

	xor	ax, ax
@@end:
	xor	ecx, ecx
	xor	edx, edx
	pop	ebx
	pop	esi
	.286

	ret
ModifyPageAttributes  endp

   ;
   ;	int MapDeviceInMemoryBlock(DWORD handle,DWORD offs,
   ;				   DWORD pages,DWORD device)
   ;
	public	C MapDeviceInMemoryBlock
MapDeviceInMemoryBlock PROC C \
	handle	:DWORD , \
	offs	:DWORD , \
	pages	:DWORD , \
	device	:DWORD

	.386
	push	esi
	push	ebx
	mov	esi, handle
	mov	ebx, offs
	mov	ecx, pages
	mov	edx, device
	DPMI 0508h
	jc	short @@end

	xor	ax, ax
@@end:
	xor	ecx, ecx
	xor	edx, edx
	pop	ebx
	pop	esi
	.286

	ret
MapDeviceInMemoryBlock	endp

   ;
   ;	int MapDOSMemInMemoryBlock(DWORD handle,DWORD offs,
   ;				   DWORD pages,DWORD dosmem)
   ;
	public	C MapDOSMemInMemoryBlock
MapDOSMemInMemoryBlock PROC C \
	handle	:DWORD , \
	offs	:DWORD , \
	pages	:DWORD , \
	dosmem	:DWORD

	.386
	push	esi
	push	ebx
	mov	esi, handle
	mov	ebx, offs
	mov	ecx, pages
	mov	edx, dosmem
	DPMI 0509h
	jc	short @@end

	xor	ax, ax
@@end:
	xor	ecx, ecx
	xor	edx, edx
	pop	ebx
	pop	esi
	.286
	ret
MapDOSMemInMemoryBlock	endp

endif	;HAVE386


   ;
   ;	int GetMemoryBlockData(DWORD handle,DWORD *addr,DWORD *bytes)
   ;
	public	C GetMemoryBlockData
GetMemoryBlockData PROC C USES DI SI, \
	handle	:DWORD , \
	addr	:PTR , \
	bytes	:PTR

	getdword si,di,handle
	DPMI 050Ah
	jc	short @@end
	mov	bx, addr
	setdword [bx],bx,dx
	mov	bx, bytes
	setdword [bx],si,di
	xor	ax, ax
@@end:

	ret
GetMemoryBlockData  endp

   ;
   ;	int GetMemoryInfo(INFO *info)
   ;
	public	C GetMemoryInfo
GetMemoryInfo PROC C USES DI, \
	info	:WORD

	push	ds
	pop	es
; ifdef HAVE386
	.386
	movzx	edi, word ptr info
	.286
; endif
	DPMI 050Bh
	jc	short @@end
	xor	ax, ax
@@end:
	ret
GetMemoryInfo  endp

   ;
   ;	int FreePhysicalMapping(DWORD address)
   ;
	public	C FreePhysicalMapping
FreePhysicalMapping PROC C \
	address :DWORD

	getdword bx,cx,address
	DPMI 0801h
	jc	short @@end
	xor	ax, ax
@@end:
	ret
FreePhysicalMapping  endp

   ;
   ;	int DpmiGetCoproStatus(WORD *status)
   ;
	public DpmiGetCoproStatus
DpmiGetCoproStatus PROC C \
	status	:PTR
	DPMI 0E00h
	jc	short @@end
	mov	bx, status
	mov	word ptr [bx], ax
	xor	ax, ax
@@end:
	ret
DpmiGetCoproStatus endp

	end
