/*****************************************************************************
 * FILE: DPMI10.S							     *
 *									     *
 * DESC:								     *
 *	- DPMI 1.0 functions / for GNU-C (386)				     *
 *									     *
 * Copyright (C) 1993,1994						     *
 *	Rainer Schnitker, Heeper Str. 283, 33607 Bielefeld		     *
 *	email: rainer@mathematik.uni-bielefeld.de			     *
 *									     *
 *****************************************************************************/

.text

#define CFUNC(x)    .align 2,144 ; .globl _##x ;
#define BEGIN	    pushl %ebp ; movl %esp,%ebp
#define END	    leave; ret
#define DPMI(V)     movw V , %ax ; int $0x31
#define CHKERR	    jnc 1f; movl $-1, %eax; jmp 2f; 1:
#define OKEAX0	    xorl %eax, %eax; 2:
#define PAR1	    8(%ebp)
#define PAR2	    12(%ebp)
#define PAR3	    16(%ebp)
#define PAR4	    20(%ebp)
#define PAR5	    24(%ebp)

/*
int GetMultipleDescriptors(UINT count, DESCRIPTOR *buffer)
*/
CFUNC(GetMultipleDescriptors) _GetMultipleDescriptors:
BEGIN
	pushl	%edi
	movl	PAR1, %ecx	// number sel
	movl	PAR2, %edi	// buffer
	DPMI	($0x00E)
	CHKERR
	OKEAX0
	popl	%edi
END

/*
int SetMultipleDescriptors(UINT count, DESCRIPTOR *buffer)
*/
CFUNC(SetMultipleDescriptors) _SetMultipleDescriptors:
BEGIN
	pushl	%edi
	movl	PAR1, %ecx	// number sel
	movl	PAR2, %edi	// buffer
	DPMI	($0x00F)
	CHKERR
	OKEAX0
	popl	%edi
END

/*
int GetProtModeExceptionVector32(BYTE no, UINT *sel, DWORD *offset)
*/
CFUNC(GetProtModeExceptionVector32) _GetProtModeExceptionVector32:
BEGIN
	pushl	%ebx
	movb	PAR1, %bl	// exception no
	DPMI	($0x210)
	CHKERR
	movl	PAR2, %ebx	// *sel
	movl	%ecx, (%ebx)
	movl	PAR3, %ebx	// *off
	movl	%edx, (%ebx)
	OKEAX0
	popl	%ebx
END

/*
int GetRealModeExceptionVector32(BYTE no, UINT *sel, DWORD *offset)
*/
CFUNC(GetRealModeExceptionVector32) _GetRealModeExceptionVector32:
BEGIN
	pushl	%ebx
	movb	PAR1, %bl	// exception no
	DPMI	($0x211)
	CHKERR
	movl	PAR2, %ebx	// *sel
	movl	%ecx, (%ebx)
	movl	PAR3, %ebx	// *off
	movl	%edx, (%ebx)
	OKEAX0
	popl	%ebx
END

/*
int SetProtModeExceptionVector32(BYTE no, UINT sel, DWORD offset)
*/
CFUNC(SetProtModeExceptionVector32) _SetProtModeExceptionVector32:
BEGIN
	movb	PAR1, %bl	// exception no
	movw	PAR2, %cx	// sel
	movl	PAR3, %edx	// off
	DPMI	($0x212)
	CHKERR
	OKEAX0
END

/*
int SetRealModeExceptionVector32(BYTE no, UINT sel, DWORD offset)
*/
CFUNC(SetRealModeExceptionVector32) _SetRealModeExceptionVector32:
BEGIN
	movb	PAR1, %bl	// exception no
	movw	PAR2, %cx	// sel
	movl	PAR3, %edx	// off
	DPMI	($0x213)
	CHKERR
	OKEAX0
END

/*
** typedef struct {
**    WORD    bits;
**    WORD    res1;
**    WORD    res2;
**    } DPMICAP ;
**
** int GetDPMICapabilities(DPMICAP *cap, BYTE *buffer)
*/
CFUNC(GetDPMICapabilities) _GetDPMICapabilities:
BEGIN
	pushl	%ebx
	pushl	%edi
	movl	PAR2, %edi	// buffer
	DPMI	($0x401)
	CHKERR
	movl	PAR1, %ebx	// cap
	movw	%ax, (%ebx)
	movw	%cx, 2(%ebx)
	movw	%dx, 4(%ebx)
	OKEAX0
	popl	%edi
	popl	%ebx
END

/*
int AllocLinearMemory(DWORD bytes,DWORD linaddress,DWORD flags,DWORD *handle,DWORD *memaddress)
*/
CFUNC(AllocLinearMemory) _AllocLinearMemory:
BEGIN
	pushl	%ebx
	pushl	%esi
	movl	PAR1, %ecx	// size
	movl	PAR2, %ebx	// linaddress
	movl	PAR3, %edx	// flags
	DPMI	($0x504)
	CHKERR
	movl	PAR4, %edx	// *handle
	movl	%esi, (%edx)
	movl	PAR5, %edx	// *memaddress
	movl	%ebx, (%edx)
	OKEAX0
	popl	%esi
	popl	%ebx
END

/*
int ResizeLinearMemory(DWORD bytes,DWORD handle,DWORD flags,DWORD *newhandle,DWORD *newmemaddress)
*/
CFUNC(ResizeLinearMemory) _ResizeLinearMemory:
BEGIN
	pushl	%ebx
	pushl	%esi
	pushl	%edi
	movl	PAR1, %ecx	// new size
	movl	PAR2, %esi	// handle
	movl	PAR3, %edx	// flags
	xorl	%edi, %edi
	DPMI	($0x505)
	CHKERR
	movl	PAR4, %edx	// *new handle
	movl	%esi, (%edx)
	movl	PAR5, %edx	// *new memaddress
	movl	%ebx, (%edx)
	OKEAX0
	popl	%edi
	popl	%esi
	popl	%ebx
END

/*
int GetPageAttributes(DWORD handle,DWORD offs,DWORD pages,WORD *attr)
*/
CFUNC(GetPageAttributes) _GetPageAttributes:
BEGIN
	pushl	%ebx
	pushl	%esi
	movl	PAR1, %esi	// handle
	movl	PAR2, %ebx	// offs
	movl	PAR3, %ecx	// pages
	movl	PAR4, %edx	// pages
	DPMI	($0x506)
	CHKERR
	OKEAX0
	popl	%esi
	popl	%ebx
END

/*
int ModifyPageAttributes(DWORD handle,DWORD offs,DWORD pages,WORD *attr)
*/
CFUNC(ModifyPageAttributes) _ModifyPageAttributes:
BEGIN
	pushl	%ebx
	pushl	%esi
	movl	PAR1, %esi	// handle
	movl	PAR2, %ebx	// offs
	movl	PAR3, %ecx	// pages
	movl	PAR4, %edx	// pages
	DPMI	($0x507)
	CHKERR
	OKEAX0
	popl	%esi
	popl	%ebx
END

/*
int MapDeviceInMemoryBlock(DWORD handle,DWORD offs,DWORD pages,DWORD device)
*/
CFUNC(MapDeviceInMemoryBlock) _MapDeviceInMemoryBlock:
BEGIN
	pushl	%ebx
	pushl	%esi
	movl	PAR1, %esi	// handle
	movl	PAR2, %ebx	// offs
	movl	PAR3, %ecx	// pages
	movl	PAR4, %edx	// pages
	DPMI	($0x508)
	CHKERR
	OKEAX0
	popl	%esi
	popl	%ebx
END

/*
int MapDOSMemInMemoryBlock(DWORD handle,DWORD offs,DWORD pages,DWORD dosmem)
*/
CFUNC(MapDOSMemInMemoryBlock) _MapDOSMemInMemoryBlock:
BEGIN
	pushl	%ebx
	pushl	%esi
	movl	PAR1, %esi	// handle
	movl	PAR2, %ebx	// offs
	movl	PAR3, %ecx	// pages
	movl	PAR4, %edx	// pages
	DPMI	($0x509)
	CHKERR
	OKEAX0
	popl	%esi
	popl	%ebx
END

/*
int GetMemoryBlockData(DWORD handle,DWORD *addr,DWORD *bytes)
*/
CFUNC(GetMemoryBlockData) _GetMemoryBlockData:
BEGIN
	pushl	%ebx
	pushl	%edi
	pushl	%esi
	movl	PAR1, %esi	// handle high
	movl	%esi, %edi	// handle low
	shrl	$16, %esi
	DPMI	($0x50A)
	CHKERR
	movl	PAR2, %edx	// addr
	movw	%si, 2(%edx)
	movw	%di, (%edx)
	movl	PAR3, %edx	// bytes
	movw	%bx, 2(%edx)
	movw	%cx, (%edx)
	OKEAX0
	popl	%esi
	popl	%edi
	popl	%ebx
END


/*
int GetMemoryInfo(DPMI10INFO *info)
*/
CFUNC(GetMemoryInfo) _GetMemoryInfo:
BEGIN
	pushl	%edi
	movl	PAR1, %edi	// info
	DPMI	($0x50B)
	CHKERR
	OKEAX0
	popl	%edi
END

/*
int FreePhysicalMapping(DWORD address)
*/
CFUNC(FreePhysicalMapping) _FreePhysicalMapping:
BEGIN
	pushl	%ebx
	movl	PAR1, %ebx	// addr high
	movl	%ebx, %ecx	// addr low
	shrl	$16, %ecx
	DPMI	($0x801)
	CHKERR
	OKEAX0
	popl	%ebx
END

/*
int DpmiGetCoproStatus(UINT *status)
*/
CFUNC(DpmiGetCoproStatus) _DpmiGetCoproStatus:
BEGIN
	pushl	%ebx
	DPMI	($0xE00)
	CHKERR
	movzwl	%ax, %eax
	movl	PAR1, %edx	// addr high
	movl	%eax, (%edx)
	OKEAX0
	popl	%ebx
END
