/*****************************************************************************
 * FILE: cdosx32.c                                                           *
 *									     *
 * DESC:								     *
 *      - int 0x21 dos call handler                                          *
 *									     *
 * Copyright (C) 1993,1994                                                   *
 *	Rainer Schnitker, Heeper Str. 283, 33607 Bielefeld		     *
 *	email: rainer@mathematik.uni-bielefeld.de			     *
 *									     *
 *****************************************************************************/

#include "DPMI.H"
#include "PRINTF.H"
#include "RMLIB.H"
#include "PROCESS.H"
#include "FS.H"
#include "SIGNALS.H"
#include "START32.H"
#include "CDOSX32.H"
#include "COPY32.H"
#include "TERMIO.H"
#include "DOSERRNO.H"
#include "DJIO.H"

/* define segment offset usage */
#ifdef __EMX__
#define SET_SEG_OFF(pointer, seg, off) \
    { seg = (((unsigned) (pointer) & ~0xFFF) >> 4) + ds16real; \
	off = (unsigned) (pointer) & 0xFFF; }

#else				/* 16 bit compiler */
#define SET_SEG_OFF(pointer, seg, off) \
    { seg = ds16real; (WORD) off = (WORD) (pointer) ;}
#endif

#ifdef __EMX__
#define SET_SEG_OFF_64(pointer, seg, off) \
    { seg = (((unsigned) (pointer) & ~0xFFFF) >> 4) + ds16real; \
	off = (unsigned) (pointer) & 0xFFFF; }

#else				/* 16 bit compiler */
#define SET_SEG_OFF_64(pointer, seg, off) \
    { seg = ds16real; (WORD) off = (WORD) (pointer) ;}
#endif


static char iobuffer[IOBUF_SIZE + 3];

char *iobuf = iobuffer; 	/* I/O buffer for real-mode operations */
TRANSLATION tr; 		/* registers set for mode-switching */
static DWORD user_dta;		/* prot-mode DTA address */
extern WORD _psp;		/* PSP after protected mode switch */

void align_iobuf(void)
{
    iobuf = (char *) ((unsigned) (iobuf + 3) & ~3);
}


#define CONVERT_BX_DOSHANDLE {	\
    int h = get_dos_handle(BX); \
    if (h < 0) {		\
	EAX = EMX_EBADF;	\
	return CARRY_ON;	\
    }				\
    else BX = h; }


static void put_regs(void)
{
    tr.eax = EAX;
    tr.ebx = EBX;
    tr.ecx = ECX;
    tr.edx = EDX;
}

static void get_regs(void)
{
    EAX = tr.eax;
    EBX = tr.ebx;
    ECX = tr.ecx;
    EDX = tr.edx;
    FLAGS = tr.flags;
}

static char rm_stack[512];
unsigned real_mode_stack = (unsigned) (rm_stack + 510);

/* call Real-Mode INT0x21 */
int realdos(void)
{
    /*
    int stack;
    tr.ss = ds16real;  tr.sp = (unsigned) &stack - 1024;
    */
    SET_SEG_OFF_64(real_mode_stack, tr.ss, tr.sp);

    tr.flags = 0x3200;
    tr.eax &= 0xFFFF;
    tr.cs = cs16real;
    tr.es = tr.ds;

    /* DPMI-Call to Real-Mode DOS */
    SimulateRMint(0x21, 0, 0, &tr);

    /* return Carry-bit */
    return (tr.flags & 1);
}

static int illegal_syscall()
{
    puts("Illegal Parameter in syscall");
    send_signal(npz, SIGSEGV);
    EAX = EMX_EINTR;
    return CARRY_ON;
}

#define TEST_ILLEGAL( OFFSET, LENGHT ) \
if (verify_illegal(npz, OFFSET, LENGHT)) return illegal_syscall();

#define TEST_ILLEGAL_WRITE( OFFSET, LENGHT ) \
if (verify_illegal_write(npz, OFFSET, LENGHT)) return illegal_syscall();

/*
** INT 0x21 handler returns:
**
** CARRY_ON :	error, set carry-bit, errno in eax
** CARRY_OFF:	no error, clear carry-bit
** CARRY_NON:	carry-bit set by realdos -> dos error code in ax,
**		translate ax to errno
*/
int int21normal(void)
{
    int err, new_handle;
    char rAH, rAL;

    rAH = (BYTE) (AX >> 8);
    rAL = (BYTE) EAX;

    switch (rAH) {
	/*
	** register based functions
	** no changes needed - only ax,dx,flags (bx,cx) used
	*/
    case 0x01:			/* read char */
    case 0x02:			/* write char */
    case 0x03:			/* read char stdaux */
    case 0x04:			/* write char stdaux */
    case 0x05:			/* read char prn */
    case 0x06:			/* con output&input */
    case 0x07:			/* char input & echo */
    case 0x08:			/* char output & echo */
    case 0x0b:			/* get stdin stat */
    case 0x0c:			/* flush buffer & read std input */
    case 0x0d:			/* disk reset */
    case 0x0e:			/* select drive */
    case 0x19:			/* get drive */
    case 0x2a:			/* get system date (cx) */
    case 0x2b:			/* set system date (cx) */
    case 0x2c:			/* get time (cx) */
    case 0x2d:			/* set time (cx) */
    case 0x2e:			/* set verify */
    case 0x30:			/* get DOS version (bx,cx) */
    case 0x33:			/* extended break check */
    case 0x36:			/* get free disk space (bx,cx) */
    case 0x37:			/* get&set switch char */
    case 0x4d:			/* get return code */
    case 0x54:			/* get verify flag */
    case 0x58:			/* get/set UMB link state */
    case 0x5c:			/* un-&lock file */
    case 0x66:			/* code page */
	put_regs();
	realdos();
	get_regs();
	return CARRY_NON;
    case 0x44:			/* IOCTL */
	switch (rAL) {
	case 0x00:		/* get device info */
	case 0x01:		/* set device info */
	case 0x06:		/* get input status */
	case 0x07:		/* get output status */
	case 0x0a:		/* check handle remote */
	    CONVERT_BX_DOSHANDLE;
	    /* fall through */
	case 0x08:		/* check block device remove */
	case 0x09:		/* check block device remote */
	case 0x0b:		/* set sharing */
	case 0x0e:		/* get log drive map */
	case 0x0f:		/* set log drive map */
	case 0x10:		/* query ioctl handle */
	case 0x11:		/* query ioctl drive */
	    put_regs();
	    realdos();
	    get_regs();
	    return CARRY_NON;
	default:
	    EAX = EMX_EIO;
	    return CARRY_ON;
	}

	/*
	** simple file handle functions
	** convert handle
	*/
    case 0x57:			/* get file state (bx,cx) */
    case 0x68:			/* fflush file (bx) */
	CONVERT_BX_DOSHANDLE;
	put_regs();
	realdos();
	get_regs();
	return CARRY_NON;

    case 0x3e:			/* close file (bx) */
	err = sys_close(BX);
	if (err < 0) {
	    EAX = emx_errno;
	    return CARRY_ON;
	} else {
	    EAX = 0;
	    return CARRY_OFF;
	}

    case 0x42:			/* lseek file */
	{
	    long pos;

	    if (npz->p_flags & PF_EMX_FILE)
		pos = EDX;
	    else
		pos = (ECX << 16) | (EDX & 0xFFFF);

	    if ((EAX = sys_lseek(BX, pos, rAL))== -1L) {
		EAX = emx_errno;
		return CARRY_ON;
	    }
	    if (npz->p_flags & PF_DJGPP_FILE) {
		EDX = EAX >> 16;
	    }
	    return CARRY_OFF;
	}

    case 0x45:			/* dup file (bx) */
	if ((new_handle = sys_dup(BX)) < 0) {
	    EAX = (long) -new_handle;
	    return CARRY_ON;
	}
	EAX = (long) new_handle;
	return CARRY_OFF;

    case 0x46:			/* dup2 file (bx,cx) */
	if ((new_handle = sys_dup2(BX, CX)) < 0) {
	    EAX = (long) -new_handle;
	    return CARRY_ON;
	}
	EAX = (long) new_handle;
	return CARRY_OFF;

	/*
	** ASCiiZero functions
	**
	** copy name -> real_buffer , call realdos
	*/

    case 0x09:			/* string to output */
	TEST_ILLEGAL(EDX, 2);
	getstr32_16(DS, EDX, iobuf, '$');
	tr.eax = EAX;
	SET_SEG_OFF(iobuf, tr.ds, tr.edx);
	realdos();
	return CARRY_NON;

    case 0x39:			/* MKDIR name */
    case 0x3a:			/* RMDIR name */
    case 0x3b:			/* CHDIR name */
    case 0x41:			/* UNLINK name */
    case 0x43:			/* ATTRIB name */
	TEST_ILLEGAL(EDX, 2);
	if (rAH == 0x3c)	/* fix umask bug */
	    ECX &= ~1L;
	put_regs();
	strcpy32_16(DS, EDX, iobuf);
	SET_SEG_OFF(iobuf, tr.ds, tr.edx);
	realdos();
	get_regs();
	return CARRY_NON;

    case 0x3c:			/* CREATE name */
    case 0x3d:			/* OPEN name */
    case 0x5b:			/* CREATE New file */
	/*
	** only DOS handles !!
	** others with EMX: 0x7F ; DJGPP 0xFF
	*/
	if (rAH == 0x3c)	/* fix umask bug */
	    ECX &= ~1L;
	TEST_ILLEGAL(EDX, 2);
	strcpy32_16(DS, EDX, iobuf);
	put_regs();
	SET_SEG_OFF(iobuf, tr.ds, tr.edx);
	if (!realdos()) {
	    new_handle = get_empty_proc_filp();
	    npz->filp[new_handle]->f_mode = FMODE_READ | FMODE_WRITE;
	    npz->filp[new_handle]->f_doshandle = (BYTE) tr.eax;
	    npz->filp[new_handle]->f_op = & msdos_fop;
	    tr.eax = (long) new_handle;
	}
	get_regs();
	return CARRY_NON;

    case 0x56:			/* RENAME oldname name (strlen < 1024) */
	TEST_ILLEGAL(EDX, 2);
	TEST_ILLEGAL(EDI, 2);
	strcpy32_16(DS, EDX, iobuf);
	strcpy32_16(DS, EDI, iobuf + 1024);
	put_regs();
	SET_SEG_OFF(iobuf, tr.ds, tr.edx);
	tr.es = tr.ds; tr.esi = tr.edx + 1024;
	realdos();
	get_regs();
	return CARRY_NON;

    case 0x5a:			/* CREATE TEMP name */
	TEST_ILLEGAL_WRITE(EDX, 2);
	put_regs();
	strcpy32_16(DS, EDX, iobuf);
	SET_SEG_OFF(iobuf, tr.ds, tr.edx);
	if (!realdos()) {
	    strcpy16_32(DS, EDX, iobuf);
	    new_handle = get_empty_proc_filp();
	    npz->filp[new_handle]->f_mode = FMODE_READ | FMODE_WRITE;
	    npz->filp[new_handle]->f_doshandle = (BYTE) tr.eax;
	    npz->filp[new_handle]->f_op = & msdos_fop;
	    tr.eax = (long) new_handle;
	}
	get_regs();
	return CARRY_NON;

    case 0x6c:			/* EXTENDED OPEN/CREATE file */
	TEST_ILLEGAL(ESI, 2);
	strcpy32_16(DS, ESI, iobuf);
	put_regs();
	SET_SEG_OFF(iobuf, tr.ds, tr.esi);
	if (!realdos()) {
	    new_handle = get_empty_proc_filp();
	    npz->filp[new_handle]->f_mode = FMODE_READ | FMODE_WRITE;
	    npz->filp[new_handle]->f_doshandle = (BYTE) tr.eax;
	    npz->filp[new_handle]->f_op = & msdos_fop;
	    tr.eax = (long) new_handle;
	}
	get_regs();
	return CARRY_NON;

	/*
	** buffer functions
	**
	** copy data before or after realdos
	*/
    case 0x0a:			/* BUFFERED INPUT */
	{
	    BYTE no_chars;

	    TEST_ILLEGAL_WRITE(EDX, 4);
	    put_regs();
	    no_chars = (BYTE) read32(DS, EDX);
	    iobuf[0] = no_chars;/* no of chars */
	    SET_SEG_OFF(iobuf, tr.ds, tr.edx);
	    realdos();
	    cpy16_32(DS, EDX, iobuf, (DWORD) no_chars + 2);	/* copy of chars */
	    return CARRY_OFF;
	}

    case 0x3f:			/* READ from file */
	TEST_ILLEGAL(EDX, ECX);

	if (ECX == 0) {
	    EAX = 0;
	    return CARRY_OFF;
	}
	if ((npz->p_flags & PF_DJGPP_FILE) && EDX == 0) {
	    printf("read.o not ok ; run DPMIFIX from DJGPP 1.10\n");
	    EAX = EMX_EIO;
	    return CARRY_ON;
	}
	EAX = sys_read(BX, EDX, ECX);
	if (EAX == -1) {
	    EAX = emx_errno;
	    return CARRY_ON;
	} else
	    return CARRY_OFF;

    case 0x40:			/* WRITE to file */
	TEST_ILLEGAL_WRITE(EDX, ECX);
	EAX = sys_write(BX, EDX, ECX);
	if (EAX == -1) {
	    EAX = emx_errno;
	    return CARRY_ON;
	} else
	    return CARRY_OFF;

    case 0x38:			/* GET COUNTRY INFO */
	if (DX != 0xFFFF) {
	    TEST_ILLEGAL_WRITE(EDX, 34);
	    put_regs();
	    SET_SEG_OFF(iobuf, tr.ds, tr.edx);
	    if (!realdos())
		cpy16_32(DS, EDX, iobuf, 34L);
	    get_regs();
	} else {
	    put_regs();
	    realdos();
	    get_regs();
	}
	return CARRY_NON;

    case 0x47:			/* GET CURR DIRECTORY */
	TEST_ILLEGAL_WRITE(ESI, 64);
	put_regs();
	SET_SEG_OFF(iobuf, tr.ds, tr.esi);
	if (!realdos())
	    cpy16_32(DS, ESI, iobuf, 64L);
	get_regs();
	return CARRY_NON;

    case 0x4e:			/* FINDFIRST */
	/* DTA: iobuf byte 0-42 , wild _string: iobuf + 64 */
	if (npz->p_flags & PF_EMX_FILE) {
	    /* set dta address to iobuf */
	    user_dta = ESI;
	    SET_SEG_OFF(iobuf, tr.ds, tr.edx);
	    tr.eax = 0x1a00;
	    realdos();
	}
	TEST_ILLEGAL(EDX, 2);
	TEST_ILLEGAL_WRITE(user_dta, 43);
	strcpy32_16(DS, EDX, iobuf + 64);
	tr.eax = EAX;
	tr.ecx = ECX;
	SET_SEG_OFF((iobuf+64), tr.ds, tr.edx);
	if (realdos())
	    EAX = tr.eax;
	else
	    cpy16_32(DS, user_dta, iobuf, 43);
	FLAGS = tr.flags;
	return CARRY_NON;

    case 0x4f:			/* FINDNEXT */
	/* DTA: iobuf byte 0-42 */
	if (npz->p_flags & PF_EMX_FILE) {
	    user_dta = ESI;
	    SET_SEG_OFF(iobuf, tr.ds, tr.edx);
	    tr.eax = 0x1a00;
	    /* set dta address */
	    realdos();
	}
	TEST_ILLEGAL_WRITE(user_dta, 43);
	/* put user dta in iobuf */
	cpy32_16(DS, user_dta, iobuf, 43);
	tr.eax = EAX;
	if (realdos())
	    EAX = tr.eax;
	else
	    cpy16_32(DS, user_dta, iobuf, 43);
	FLAGS = tr.flags;
	return CARRY_NON;

	/*
	** some special handling
	*/
    case 0x1a:			/* SET DTA */
	TEST_ILLEGAL(EDX, 2);
	user_dta = EDX;
	tr.eax = 0x1a00;
	SET_SEG_OFF(iobuf, tr.ds, tr.edx);
	realdos();
	return CARRY_OFF;

    case 0x2f:			/* GET DTA */
	EBX = user_dta;
	return CARRY_OFF;

    case 0x62:			/* GET PSP */
	EBX = (DWORD) _psp;
	return CARRY_OFF;

	/*
	** functions complete changed
	** need to call DPMI-functions
	*/
    case 0x48:			/* ALLOC MEM */
    case 0x49:			/* FREE MEM */
	EAX = EMX_EIO;
	return CARRY_ON;

    case 0x4a:			/* RESIZE MEM */
	if (npz->p_flags & PF_EMX_FILE) {
	    EAX = EMX_EIO;
	    return CARRY_ON;
	} else {
	    if (EAX & 0xff)
		EAX = getmem(EBX, npz);
	    else
		EAX = npz->brk_value;
	    if (EAX == -1)
		EAX = 0;
	    return CARRY_OFF;	/* sbrk.s didn't check carry */
	}

    case 0x4c:
	return do_exit4c(0);

    default:
	printf("Warning: Not implemented DOS function ah=%02X\n", rAH);
	EAX = EMX_EIO;
	return CARRY_ON;

    }				/* switch R_AH */
}

#include "DJIO.H"

/*
** -1 on error, emx_errno set;
*/
ARGUSER cdosx_read(int handle, ARGUSER buf, ARGUSER count)
{
    long org_bytes;
    int iob_bytes;
    int ret_bytes;

    /* termio check */
    if ((npz->p_flags & PF_TERMIO) && rm_isatty(handle)) {
	if ((ret_bytes = termio_read(DS, buf, (int)count)) < 0) {
	    emx_errno = -ret_bytes;
	    return -1;
	} else
	    return ret_bytes;
    }

    org_bytes = count;
    while (count > 0) {
	iob_bytes = (count <= IOBUF_SIZE) ? (int) count : IOBUF_SIZE;

	if (npz->p_flags & PF_DJGPP_FILE) {
	    if ((ret_bytes = dj_read(handle, iobuf, iob_bytes)) == -1)
		return -1;
	} else {
	    if ((ret_bytes = rm_read(handle, iobuf, iob_bytes)) == -1)
		return -1;
	}
	cpy16_32(DS, buf, iobuf, (long) ret_bytes);
	count -= (long) ret_bytes;
	if (ret_bytes < iob_bytes)
	    break;
	buf += ret_bytes;
    }
    return (org_bytes - count);
}

/*
** -1 on error, emx_errno set;
*/
ARGUSER cdosx_write(int handle, ARGUSER buf, ARGUSER count)
{
    long org_bytes;
    int iob_bytes;
    int ret_bytes;

    if (!count)
	return (ARGUSER) rm_write(handle, &iobuf, 0);

    org_bytes = count;
    while (count > 0) {
	iob_bytes = (count <= IOBUF_SIZE) ? (int) count : IOBUF_SIZE;
	cpy32_16(DS, buf, iobuf, (long)iob_bytes);

	if (npz->p_flags & PF_DJGPP_FILE) {
	    if ((ret_bytes = dj_write(handle, iobuf, iob_bytes)) == -1)
		return -1;
	} else {
	    if ((ret_bytes = rm_write(handle, iobuf, iob_bytes)) == -1)
		return -1;
	}
	count -= (long) ret_bytes;
	if (iob_bytes < ret_bytes)
	    break;
	buf += ret_bytes;
    }
    return (org_bytes - count);
}

