#ifndef _FS_H
#define _FS_H

#define FMODE_READ  1
#define FMODE_WRITE 2

union file_info {
    int empty;
    int pipe_etc;
};

struct file {
    unsigned short	    f_mode;	    /* 1=RD, 2=WR */
    unsigned short	    f_flags;	    /* NDELAY etc */
    unsigned short	    f_count;	    /* no processes */
    short		    f_doshandle;    /* real dos handle or -1 */
    unsigned long	    f_offset;	    /* seek pos */
    struct file_operations *f_op;	    /* file ops */
    union file_info *	    f_info;	    /* extra information */
};

typedef long ARGUSER;

struct file_operations {
    long (*lseek) (struct file *, long, int);
    ARGUSER (*read) (struct file *, ARGUSER, ARGUSER);
    ARGUSER (*write) (struct file *, ARGUSER, ARGUSER);
    int (*select) (struct file *, ARGUSER);
    int (*ioctl) (struct file *, ARGUSER, ARGUSER);
    int (*open) (struct file *, ARGUSER);
    void (*release) (struct file *);
};

extern struct file rsx_filetab[RSX_NFILES];

void init_rsx_filetab(void);
int get_empty_proc_filp(void);
int get_dos_handle(int);
int sys_close(int);
int sys_dup2(unsigned int, unsigned int);
int sys_dup(unsigned int);
ARGUSER sys_read(int fd, ARGUSER buf, ARGUSER bytes);
ARGUSER sys_write(int fd, ARGUSER buf, ARGUSER bytes);
long sys_lseek(int fd, long off, int orgin);

extern struct file_operations msdos_fop;
#endif /* _FS_H */
