#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "DPMI.H"
#include "DPMI10.H"

char file_desc[] =
"**************************************************************************\n"
"* FILE: dpmifun                                                          *\n"
"*                                                                        *\n"
"* DESC: shell for calling Dpmi functions                                 *\n"
"*                                                                        *\n"
"* Copyright (C) 1994                                                     *\n"
"*      Rainer Schnitker, Heeper Str. 283, 33607 Bielefeld                *\n"
"*      email: rainer@mathematik.uni-bielefeld.de                         *\n"
"*                                                                        *\n"
"* This program is distributed in the hope that it will be useful,        *\n"
"* but WITHOUT ANY WARRANTY; without even the implied warranty of         *\n"
"* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *\n"
"* GNU General Public License for more details.                           *\n"
"*                                                                        *\n"
"**************************************************************************\n";

/* input function from input.c */
int get_input(char *str, int size, int opt_newline);

typedef struct dpmifnct {
    char *name;
    int fnct;
    int args;
    char *help_text;
} DPMIFNCT;

DPMIFNCT dpmif[] = {
    #include "dpmifun.h"
};

#define N_REGS 10
int regs[N_REGS];

/* emx/gcc need this */
int __os_version(void);

int is_emx_exe(void)
{
    register int ver;

#ifdef __EMX__
    __asm__ __volatile__(
	"call   ___os_version"
	: "=a" (ver)
	:
	: "ax","bx");
#else
    __asm__ __volatile__(
	"movb   $0x30, %%ah \n\t"
	"int    $0x21 \n\t"
	: "=a" (ver)
	:
	: "ax","bx");
#endif

    /* EMX set high eax to "em" */
    if (ver >> 16 == 0x6d65)
	return 1;
    else
	return 0;
}

void do_help(char *s)
{
    int i;
    for (i = 0; dpmif[i].name ; i++)
	if (stricmp(dpmif[i].name, s) == 0) {
	    puts(dpmif[i].help_text);
	    return;
	}
    for (i = 0; dpmif[i].name ; i++)
	if (strstr(dpmif[i].name, s))
	    puts(dpmif[i].help_text);
}

static int make_tokens(char *argmem, char **argp)
{
    int i;
    int args=0;

    argp[args++] = argmem;
    for (i = 0; *(argmem + i) != 0; i++)
	if (*(argmem + i) == ' ') {
	    *(argmem + i) = 0;
	    if (*(argmem + i + 1) == ' ')
		continue;
	    if (*(argmem + i + 1) == 0)
		break;
	    argp[args++] = (argmem + i + 1);
	}
    argp[args] = 0;

    return args;
}

static int get_function(char *s, int *argc)
{
    int i;

    for (i = 0; dpmif[i].name ; i++)
	if (strcmp(dpmif[i].name, s) == 0) {
	    *argc = dpmif[i].args;
	    return (int) dpmif[i].fnct;
	}
    return 0;
}

static int my_atoi(char *s)
{
    int c;
    if ( (*s) < '0' || (*s) > '9')
	return -1;
    return ((c=atoi(s)) > N_REGS) ? -1 : c;
}

static int hex_atoi(char *s)
{
    int c;
    if ( (*s) < '0' || (*s) > '9')
	return 0;
    if (*(s+1)=='x')
	sscanf(s+2,"%x\n", &c);
    else
	sscanf(s,"%d\n", &c);
    return c;
}

static int push_args(int begin, int end, char **argv, int pushv[])
{
    int i;

    for (i = begin; i <= end; i++) {
	if (argv[i][0] == 'r') {
	    int n = my_atoi(& argv[i][1]);
	    if (n<0)
		return n;
	    pushv[i] = regs[n];
	}
	else if (argv[i][0] == '&' && argv[i][1] == 'r') {
	    int n = my_atoi(& argv[i][2]);
	    if (n<0)
		return n;
	    pushv[i] = (int) & regs[n];
	}
	else
	    pushv[i] = hex_atoi(argv[i]);
    }
    return 0;
}

int execute_dpmi(int fnct, int p1, int p2, int p3, int p4, int p5);

int main(void)
{
    char cmd[80];	    /* cmd line */
    char * argvec[20];	    /* cmd tokens */
    int push[20];	    /* pushed args for dpmi */
    unsigned fnct;	    /* dpmi function */
    int n,p,ret;

    puts(file_desc);
    puts("help command: help or h");

    if (is_emx_exe()) {
	puts("sorry, run rsx not emx");
	puts("emx does not support DPMI");
	return 1;
    }

    for (;;) {
	printf("dpmi:");
	get_input(cmd, sizeof(cmd), 1);
	n = make_tokens(cmd, argvec);

	switch (*cmd) {
	    case '0':
	    case 'q':
		printf("bye\n");
		return 0;

	    case '\n':
	    case '\r':
		continue;

	    case 'h':
		if (argvec[1])
		    do_help(argvec[1]);
		else {
		    putchar('\n');
		    puts("(h)elp <function> - get help");
		    puts("c[0-9]            - clear regs 0-9");
		    puts("r[0-9]            - print regs 0-9");
		    puts("s[0-9] <value>    - set regs 0-9 to v");
		    puts("DPMIFUNCTION args - execute dpmifuncion");
		    puts("(q)uit            - quit");
		    puts("Arrow keys <up>,<down>,<left>,<right>");

		    puts("\nExample:");
		    puts("dpmi:help DpmiGet                 // list all functions with DpmiGet");
		    puts("int DpmiGetCoproStatus (UNIT *)   // answer");
		    puts("dpmi:DpmiGetCoproStatus &r1       // call function with address r1");
		    puts("dpmi:r1                           // display register 1");
		    putchar('\n');
		}
		continue;

	    case 'c':
		n = my_atoi(& argvec[0][1]);
		if (n < 0)
		    puts("What?");
		else
		    regs[n] = 0;
		continue;

	    case 'r':
		n = my_atoi(& argvec[0][1]);
		if (n < 0)
		    puts("What?");
		else
		    printf("Reg%d: %d = 0x%X\n", n, regs[n], regs[n]);
		continue;

	    case 's':
		n = my_atoi(& argvec[0][1]);
		if (n < 0)
		    puts("What?");
		else {
		    p = hex_atoi(argvec[1]);
		    regs[n] = p;
		    printf("Reg%d: %d = 0x%X\n", n, regs[n], regs[n]);
		}
		continue;

	    default:
		fnct = get_function(argvec[0], &p);
		if (!fnct) {
		    printf("not a dpmi function\n");
		    continue;
		}
		if (n-1 != p) {
		    printf("Illegal argument count\n");
		    continue;
		}
		push[0] = fnct;
		if (push_args(1, n-1, argvec, push)<0) {
		    printf("bad parameter\n");
		    continue;
		}
		ret=execute_dpmi(push[0],push[1],push[2],push[3],push[4],push[5]);
		printf("return %d = 0x%X\n", ret, ret);
	}   /* switch */
    }
}
