#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "DPMI.H"
#include "DPMI10.H"

#define INFO_BITS 7
char * info_text[INFO_BITS] = {
    "page access/dirty" ,
    "exceptions restartability" ,
    "device mapping" ,
    "conventional mapping" ,
    "demand zero fill" ,
    "write-protect client" ,
    "write-protect host" };

char * memo_text[] = {
    "HostPhysicalMemory        " ,
    "HostVirtuelMemory         " ,
    "HostFreeVirtuelMemory     " ,
    "VMVirtuelMemory           " ,
    "VMFreeVirtuelMemory       " ,
    "ClientVirtuelMemory       " ,
    "ClientFreeVirtuelMemory   " ,
    "LockedMemory              " ,
    "ClientMaxLockedMemory     " ,
    "ClientHighestLinearAddress" ,
    "LargestMemoryBlock        " ,
    "MinimumUnitValue          " ,
    "MemoryAlignValue          "
    } ;

char Yes[] = "yes";
char No[] = "no";

void PrintFreeMemInfo(NPFREEMEMINFO fm)
{
    printf("Largest available block           : %lu Bytes = %lu KB\n",
	   fm->LargestFree, fm->LargestFree >> 10);
    printf("Number free pages                 : %8lu = %8lu KB\n"
	   ,fm->MaxUnlockedPages, fm->MaxUnlockedPages * 4);
    printf("Number free pages to lock         : %8lu = %8lu KB\n"
	   ,fm->MaxLockedPages, fm->MaxLockedPages * 4);
    printf("Number pages of linear addr space : %8lu = %8lu KB\n"
	   ,fm->AddressSpacePages, fm->AddressSpacePages * 4);
    printf("Number pages not locked           : %8lu = %8lu KB\n"
	   ,fm->UnlockedPages, fm->UnlockedPages * 4);
    printf("Number pages not used             : %8lu = %8lu KB\n"
	   ,fm->UnusedPages, fm->UnusedPages * 4);
    printf("Number pages managed by the Dpmi  : %8lu = %8lu KB\n"
	   ,fm->PhysicalPages, fm->PhysicalPages * 4);
    printf("Number pages free addr space      : %8lu = %8lu KB\n"
	   ,fm->FreeAddressSpacePages, fm->FreeAddressSpacePages * 4);

    if (fm->PagingFilePages <= 0xFFFFFL)
	printf("Number pages in swapfile          : %8lu = %8lu KB\n"
	       ,fm->PagingFilePages, fm->PagingFilePages * 4);
    else
	printf("DPMI host paging partition        : %lu Bytes = %lu MB\n"
	       ,fm->PagingFilePages, fm->PagingFilePages >> 20);
}

DPMI10INFO info;

static void print_dpmi10_meminfo(void)
{
    int i;
    DWORD *p;

    if (GetMemoryInfo(&info)) {
	puts("no dpmi 1.0 meminfo");
	return;
    }
    printf("\nDPMI 1.0 Linear Memory\n");
    printf("Host free %lX\n", info.HostPhysicalMemory);
    p = (DWORD *) & info;
    for (i = 0; i < 13; ++i)
	printf("%s = %8lu KB\n", memo_text[i], *(p+i)/1024);
    fflush(stdout);
}

char hostbuf[128];
DPMICAP cap;

static void print_dpmi10_cap(void)
{
    int i;

    if (GetDPMICapabilities(&cap, hostbuf)) {
	puts("no dpmi 1.0 capabilities");
	return;
    }
    printf("\nDPMI 1.0 Capabilities\n");
    printf("host %s %d.%d\n", hostbuf+2, hostbuf[0], hostbuf[1]);
    for (i = 0; i <= 6; ++i) {
	printf("%s supported: %s \n", info_text[i], (cap.bits & 1) ? Yes : No);
	cap.bits >>= 1;
    }
    putchar('\n');
    fflush(stdout);
}


int main(int argc, char **argv, char **env)
{
    FREEMEMINFO freeinfo;
    DPMIVERSION dpmi_ver;
    int i;

    if (argc > 1 && strcmp(argv[1],"-?") == 0) {
	printf("usage: %s [-c -m]\n", argv[0]);
	printf("-c : Print DPMI 1.0 Capabilities\n");
	printf("-m : Print DPMI 1.0 Memory Info\n");
	return 0;
    }

    GetDPMIVersion(&dpmi_ver);
    printf("\nDPMI version %d.%d\n", dpmi_ver.major, dpmi_ver.minor);
    printf("32bit supported: %s\n", (dpmi_ver.flags & 1) ? Yes : No);
    printf("CPU detected %d86\n", dpmi_ver.cpu);

    printf("\nDpmi Memory\n");
    GetFreeMemInfo(&freeinfo);
    PrintFreeMemInfo(&freeinfo);
    fflush(stdout);

    for (i = 1; argv[i]; i++) {
	if (strcmp(argv[i],"-m") == 0)
	    print_dpmi10_meminfo();
	else if (strcmp(argv[i],"-c") == 0)
	    print_dpmi10_cap();
    }
    if (argc == 1)
	printf("\nGet help with '-?'\n");
    return 0;
}
