#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <process.h>

static void my_dup2 (int from, int to)
{
  int rc;

  close (to);
  rc = dup (from);
  if (rc == -1)
    {
      perror ("dup");
      exit (2);
    }
  if (rc != to)
    {
      fputs ("dup failed\n", stderr);
      exit (2);
    }
  close (from);
}

int main (int argc, char *argv[])
{
    int org_stdin;
    int org_file;
    int f;
    char s[80];

    if (argc <= 1) {
	puts("missing argument file");
	return 1;
    }

    puts("more program ?:");
    gets(s);

    org_stdin = dup(fileno(stdin));
    if (org_stdin < 0)
    {
	perror ("dup stdin");
	return (2);
    }

    f = open(argv[1], O_RDONLY);
    if (f < 0) {
	perror("open");
	exit(1);
    }
    org_file = dup (f);

    my_dup2( f, fileno(stdin));
    spawnlp(P_WAIT, s, s, NULL);
    my_dup2( org_stdin, fileno(stdin));

    close(org_file);

    return 0;
}
