/*****************************************************************************
 *                                                                           *
 * Projeto:  Winspector -> Ferramenta para programacao                       *
 *                         HEADER FILE                                       *
 * Modulo :  WINSPECTOR.H                                                    *
 *                                                                           *
 * Autor  : Noriel Chang Reissig                                             *
 *                                                                           *
 * Criacao : 20/04/93                                                        *
 * Revisao : 04/08/93                                                        *
 * Modific : 04/08/93                                                        *
 *                                                                           *
 *****************************************************************************
 Obs.:
     - Quando for header de uma DLL todas as funcoes que podem ser chamadas
       por outras aplicacoes DEVEM SER "FAR PASCAL"

     - Requer WINDOWS.H no programa chamador
       Ex.:
             #include  <windows.h>
             #include  "winspect.h"
*/

#ifndef    __WINSPECTOR_H__
  #define  __WINSPECTOR_H__


#define  ON    1
#define  OFF   0


    BOOL StartWinspector( void);                         // Executa WINSPECT.EXE
    BOOL CloseWinspector( void);                         // Fecha o WINSPECTOR, se estiver na memoria.
    BOOL WinspectorAutoSave( BOOL OnOff);                // Ativa/Desativa o autosave.
    BOOL TellWinspector( LPSTR szMessage);               // Envia a mensagem szMessage para Winspector.

#ifndef   __WINSPECTOR_DLL__
    BOOL  cdecl TellWinspectorFmt( LPSTR szFormat, ...); // Envia a mensagem para Winpector, funciona como printf().
#endif   // __WINSPECTOR_DLL__

#endif   // __WINSPECTOR_H__
