library Example;

{$H- to improve speed}

uses CalcPlug, StdMath;

//----------------------
var
  Error: LongBool;
  ErrorMsg: ShortString;

procedure SetError(const Msg: String);
begin
  Error:= True;
  ErrorMsg:= Msg;
end;

//----------------------

{$I Example1.inc}
{$I Example2.inc}
{$I Example3.inc}

function CalculateFunc(const func: String; const x: Real): Real;
begin
  if func='cube' then begin Result:= _Cube(x); Exit end;
  if func='log2' then begin Result:= _Log2(x); Exit end;
  if func='fib'  then begin Result:= _Fib(x);  Exit end;
  SetError(ERR_UNKNOWN_FUNC);
  Result:= 1;
end;

function CalculateList(const func: String; const x: TArgList): Real;
begin
  if func='gauss' then begin Result:= _Gauss(x); Exit end;
  if func='norm'  then begin Result:= _Norm(x);  Exit end;
  if func='disp'  then begin Result:= _Disp(x);  Exit end;
  if (func='rol') or
     (func='ror') then begin Result:= IntOp2(func, x); Exit end;
  SetError(ERR_UNKNOWN_FUNC);
  Result:= 1;
end;

//----------------------

procedure CalcFunc(
  const FuncName: ShortString;
  const FuncArgs: TArgList;
  var ResultValue: Real;
  var ResultError: LongBool;
  var ResultErrorMsg: ShortString); stdcall;
begin
  if ResultError then begin ResultValue:= 1; Exit end;
  Error:= False;
  ErrorMsg:= '';

  if FuncArgs.Num=1
    then ResultValue:= CalculateFunc(FuncName, FuncArgs.Val[1])
    else ResultValue:= CalculateList(FuncName, FuncArgs);

  ResultError:= Error;
  ResultErrorMsg:= ErrorMsg;
end;

exports
  CalcFunc;

begin
  InitStdErrorAddr(@Error, @ErrorMsg);

end.
