//-----------------
function _Cube(const x: Real): Real; { x**3 }
begin
  Result:= _pow(x, 3);
end;

//-----------------
function _Log2(const x: Real): Real; { log(2,x) }
begin
  Result:= _ln(x)/ln(2);
end;

//-----------------
function IsReal(const x: Real): Boolean;
begin
  Result:= Abs(Frac(x)) > 1e-18;
end;

function IsDWord(const x: Real): Boolean;
begin
  Result:= (Int(x) >= -MaxLongInt-1) and (Int(x) <= MaxLongInt);
end;

//-----------------
function _Fib(const x: Real): Real; { Fibonacci numbers }
var
  n, i: LongInt;
  n1, n2, n0: Real;
begin
  Result:= 1;
  if x<0            then begin SetError('illegal arg<0');    Exit end;
  if IsReal(x)      then begin SetError('illegal real arg'); Exit end;
  if not IsDWord(x) then begin SetError(ERR_OVERFLOW);       Exit end;

  n:= Trunc(x);
  if n=0 then begin Result:= 0; Exit end;
  if n=1 then begin Result:= 1; Exit end;

  n1:= 0;
  n2:= 1;
  for i:= 2 to n do
    begin
    n0:= _add(n1, n2);  if Error then Exit;
    n1:= n2;
    n2:= n0;
    end;
  Result:= n0;
end;
