//-----------------------------------------------
{
                      1               sqr(x-a)
  Gauss(a,d,x) = ------------ * exp(- --------)
                 d*sqrt(2*pi)         2*sqr(d)
}
function _Gauss(const l: TArgList): Real;
var
  a, d, x: Real;
  t1, t2: Real;
begin
  Result:= 1;
  if l.num<>3   then begin SetError('invalid arg list'); Exit end;
  if l.val[2]<0 then begin SetError('illegal arg2<0');   Exit end;
  a:= l.val[1];
  d:= l.val[2];
  x:= l.val[3];

  t1:= _div(1, d) / sqrt(2*pi);    if Error then Exit;
  t2:= _sqr(_div(_sub(x, a), d));  if Error then Exit;
  Result:= _mul(t1, _exp(-0.5*t2));
end;

//-----------------------------------------------
{
                           N
  Norm(x1,...,xN) = sqrt( Sum(x[i]**2) )
                          i=1
}
function _Norm(const x: TArgList): Real;
var
  r: Real;
  i: Integer;
begin
  Result:= 1;

  for i:= 1 to x.num do
    if x.val[i]<0 then
      begin SetError('illegal arg<0'); Exit end;

  r:= 0;
  for i:= 1 to x.num do
    begin
    r:= _add(r, _sqr(x.val[i]));  if Error then Exit;
    end;
  Result:= _sqrt(r);
end;

//-----------------------------------------------
{
       1    N                       1    N
  Dx = - * Sum((x[i]-Mx)**2) ; Mx = - * Sum(x[i])
       N   i=1                      N   i=1
}
function _Disp(const x: TArgList): Real;
var
  r, Mx: Real;
  i: Integer;
begin
  Result:= 1;

  Mx:= _avg(x);  if Error then Exit;

  r:= 0;
  for i:= 1 to x.num do
    begin
    r:= _add(r, _sqr(_sub(x.val[i], Mx)));  if Error then Exit;
    end;
  Result:= r/x.num;
end;
