//------------------------
function _rol(a, count: Longint): Longint; { cyclic shift left }
asm
  mov  eax,a
  mov  ecx,count
  rol  eax,cl
end;

function _ror(a, count: Longint): Longint; { cyclic shift right }
asm
  mov  eax,a
  mov  ecx,count
  ror  eax,cl
end;

//------------------------
function IntOp2(const func: String; const l: TArgList): Real;
var
  x1, x2: Real;
  n1, n2: Longint;
begin
  Result:= 1;
  if l.num<>2 then begin SetError('invalid arg list'); Exit end;
  x1:= l.val[1];
  x2:= l.val[2];
  if IsReal(x1)      then begin SetError('illegal real arg1');    Exit end;
  if IsReal(x2)      then begin SetError('illegal real arg2');    Exit end;
  if not IsDWord(x1) then begin SetError('overflow in int arg1'); Exit end;
  if not IsDWord(x2) then begin SetError('overflow in int arg2'); Exit end;
  n1:= Trunc(x1);
  n2:= Trunc(x2);

  if n2<0       then begin SetError('illegal arg2<0');   Exit end;
  if func='rol' then begin Result:= _rol(n1, n2 mod 32); Exit end;
  if func='ror' then begin Result:= _ror(n1, n2 mod 32); Exit end;
end;
