/****************************************************************************
 *  This file is part of PPMD project                                       *
 *  Written and distributed to public domain by Dmitry Shkarin 1997,        *
 *  1999-2000                                                               *
 *  Contents: compilation parameters and miscelaneous definitions           *
 *  Comments: system & compiler dependent file                              *
 ****************************************************************************/
#if !defined(__PPMDTYPE_H)
#define __PPMDTYPE_H

const int MAX_O=16; /* maximum allowed model order */

//#define __I_LIKE_FAST_AND_DIRTY_PROGRAMS

#define __WIN32_ENVIRONMENT
//#define __DOS32_ENVIRONMENT
//#define __UNKNOWN_ENVIRONMENT
#if defined(__WIN32_ENVIRONMENT)+defined(__DOS32_ENVIRONMENT)+defined(__UNKNOWN_ENVIRONMENT) != 1
#error Only one environment must be defined
#endif /* defined(__WIN32_ENVIRONMENT)+defined(__DOS32_ENVIRONMENT)+defined(__UNKNOWN_ENVIRONMENT) != 1 */

#if defined(__WIN32_ENVIRONMENT)
#include <wtypes.h>
#else /* __DOS32_ENVIRONMENT || __UNKNOWN_ENVIRONMENT */
typedef int   BOOL;
#define FALSE 0
#define TRUE  1
typedef unsigned char  BYTE;
typedef unsigned short WORD;
typedef unsigned long  DWORD;
typedef unsigned int   UINT;
typedef signed long    LONG;
#endif /* defined(__WIN32_ENVIRONMENT)  */

#if !defined(__UNKNOWN_ENVIRONMENT) && !defined(__GNUC__)
#define _FASTCALL __fastcall
#define _STDCALL  __stdcall
#else
#define _FASTCALL
#define _STDCALL
#endif /* !defined(__UNKNOWN_ENVIRONMENT) && !defined(__GNUC__) */

#if defined(__BORLANDC__) || defined(__WATCOMC__) || defined(__GNUC__)
#define _BIG_INLINE
#else
#define _BIG_INLINE inline
#endif /* defined(__BORLANDC__) || defined(__WATCOMC__) || defined(__GNUC__) */

template <class TMP_TYPE>
inline TMP_TYPE CLAMP(const TMP_TYPE& X,const TMP_TYPE& LoX,const TMP_TYPE& HiX) { return (X >= LoX)?((X <= HiX)?(X):(HiX)):(LoX); }
template <class TMP_TYPE>
inline void SWAP(TMP_TYPE& t1,TMP_TYPE& t2) { TMP_TYPE tmp=t1; t1=t2; t2=tmp; }

#endif /* !defined(__PPMDTYPE_H) */
