// ------------------------------------------------------------------------
// System       : MS-DOS
// Program      : newfiles.c
// Description  : create a list of file names modified on or since
//                the date entered on the command line
//                use to build lists for selected back-ups, etc.
// Written by   : Bill Buckels
// Date Written : 1994
// Revision     : 1.1 First Release
//                2.0 Added Support For Long FileNames - Feb 2000
// ------------------------------------------------------------------------


#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#include <string.h>
#include <direct.h>
#include <time.h>

int D_day,D_month,D_year;  // globals from command line

int isdirectory(char *filename, unsigned attribute)
{
  if(strcmpi(filename, ".") == 0)return  0;
  if(strcmpi(filename, "..") == 0)return 0;
  if((attribute & _A_SUBDIR) != 0)return - 1;
  return 0;
  
}


int isdot(char *filename)
{
  if(strcmpi(filename, ".") == 0)return  1;
  if(strcmpi(filename, "..") == 0)return 1;
  return 0;
  
}

unsigned absolute_date = 0;

int checkfiledate(unsigned month, unsigned day, unsigned year)
{
  if(absolute_date == 1)
  {
    if(year != D_year)return 1;
    if(month != D_month)return 1;
    if(day != D_day)return 1;
    return 0;
  }
  
  if(year < D_year)return 1;
  if(year > D_year)return 0;
  
  if(month < D_month)return 1;
  if(month > D_month)return 0;
  
  if(day < D_day)return 1;
  return 0;
}



void listfiles(char *pathname)
{
  long findhandle;
  struct _finddata_t wild_card;
  struct tm *today;
  
  char filename[_MAX_PATH];
  int status = 1, pathlength = strlen(pathname) - 3;
  
  strcpy(filename, "*.*");
  
  if((findhandle = _findfirst(filename, &wild_card)) > 0l)
  {
    today = localtime(&wild_card.time_write);
    status = checkfiledate(today->tm_mon + 1, today->tm_mday, today->tm_year + 1900);
    if(!status && !isdot(wild_card.name))
    {
      printf("%4d.%002d.%002d.%002d.%002d.%002d ", 
        today->tm_year + 1900, today->tm_mon + 1, today->tm_mday, 
        today->tm_hour, today->tm_min, today->tm_sec);
      if(pathlength)
        printf("%s\\%s\n", pathname, wild_card.name);
      else
        printf("%s%s\n", pathname, wild_card.name);
    }
    
    while(_findnext(findhandle, &wild_card) == 0) 
    {
      today = localtime(&wild_card.time_write);
      status = checkfiledate(today->tm_mon + 1, today->tm_mday, today->tm_year + 1900);
      if(!status && !isdot(wild_card.name))
      {
        printf("%4d.%002d.%002d.%002d.%002d.%002d ", 
          today->tm_year + 1900, today->tm_mon + 1, today->tm_mday, 
          today->tm_hour, today->tm_min, today->tm_sec);
        if(pathlength)
          printf("%s\\%s\n", pathname, wild_card.name);
        else
          printf("%s%s\n", pathname, wild_card.name);
      }
      
    }
    _findclose(findhandle);
  }
}

void treewalker(void)
{
  long findhandle;
  struct _finddata_t wild_card;
  
  char filename[_MAX_PATH];
  char buffer[_MAX_PATH];
  
  strcpy(filename, "*.*");
  
  /* we must walk each directory tree          */
  /* beneath us and call ourselves recursively */
  /* until we are done                         */
  
  getcwd(buffer, _MAX_DIR);
  
  if((findhandle = _findfirst(filename, &wild_card)) > 0l)
  {
    /* descend into the subdirectory */
    if((isdirectory(wild_card.name, wild_card.attrib)))
    {
      chdir(wild_card.name);
      treewalker();
      chdir(buffer);
    }
    while(_findnext(findhandle, &wild_card) == 0) 
    {
      if((isdirectory(wild_card.name, wild_card.attrib)))
      {
        chdir(wild_card.name);
        treewalker();
        chdir(buffer);
      }
    }
    _findclose(findhandle);
    
  }
  listfiles(buffer);
  
}

void main(int argc, char **argv)
{
  char buffer[_MAX_PATH];

  switch(argc)
  {
    case 5:     if(strcmpi("ABSOLUTE", argv[4]) == 0)absolute_date = 1;
    case 4:     D_month = atoi(argv[1]);
    if(D_month < 1 || D_month > 12)break;
    
    D_day = atoi(argv[2]);
    if(D_day < 1 || D_day > 31)break;
    
    D_year = atoi(argv[3]);
    if(D_year < 1980 || D_year > 2099)break;

    getcwd(buffer, _MAX_DIR);
    treewalker();
    chdir(buffer);
    break;
    
    default:
    puts("NewFiles(C) CopyLeft Bill Buckels 1994-2000. All Rights Reversed.");
    puts("Usage is : \"newfiles mm dd yyyy [ABSOLUTE-optional]\"");
    puts("Purpose  : Print names of files modified since mm dd yyyy");
    
  }
  exit(0);
  
}
