#!/usr/local/bin/perl
use Dislin;

@xray  = (2., 4., 6., 8., 10.);
@y1ray = (0., 0., 0., 0., 0.);
@y2ray = (3.2, 1.5, 2.0, 1.0, 3.0);

@ic1ray  = (50, 150, 100, 200, 175);
@ic2ray  = (50, 150, 100, 200, 175);

Dislin::metafl ('cons');
Dislin::setpag ('da4p');
Dislin::disini ();
Dislin::pagera ();
Dislin::hwfont ();

Dislin::titlin ('3-D Bar Graph / 3-D Pie Chart', 2);
Dislin::htitle (40);

Dislin::shdpat (16);
Dislin::axslen (1500, 1000);
Dislin::axspos (300, 1400);

Dislin::barwth (0.5);
Dislin::bartyp ('3dvert');
Dislin::labels ('second', 'bars');
Dislin::labpos ('outside', 'bars');
Dislin::labclr (255, 'bars');
Dislin::graf   (0., 12., 0., 2., 0., 5., 0., 1.);
Dislin::title  ();
Dislin::color  ('red');
Dislin::bars   (\@xray, \@y1ray, \@y2ray, 5);
Dislin::endgrf ();

Dislin::shdpat (16);
Dislin::labels ('data', 'pie');
Dislin::labclr (255, 'pie');
Dislin::chnpie ('none');
Dislin::pieclr (\@ic1ray, \@ic2ray, 5);
Dislin::pietyp ('3d');
Dislin::axspos (300, 2700);
Dislin::piegrf ($cbuf, 0, \@y2ray, 5);  
Dislin::disfin ();

