/*
 * Decompiled with CFR 0.152.
 */
package sun.beanbox;

import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import sun.beanbox.MessageHeader;
import sun.beanbox.ObjectInputStreamWithLoader;
import sun.beanbox.SimpleClassLoader;

public class JarInfo {
    private SimpleClassLoader classLoader;
    private String[] beanNames;
    private BeanInfo[] beanInfos;
    private boolean[] fromPrototype;
    private MessageHeader[] manifestData;
    private String jarName;
    private static Hashtable beanToJar = new Hashtable();
    private static boolean debug;

    public JarInfo(String string, SimpleClassLoader simpleClassLoader, String[] stringArray, boolean[] blArray, MessageHeader[] messageHeaderArray) {
        if (stringArray.length != blArray.length) {
            throw new Error("beanNames and fromPrototype need to have the same length");
        }
        this.jarName = string;
        this.classLoader = simpleClassLoader;
        this.beanNames = stringArray;
        this.fromPrototype = blArray;
        this.manifestData = messageHeaderArray;
        this.beanInfos = new BeanInfo[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            block7: {
                beanToJar.put(stringArray[n], string);
                if (!blArray[n]) {
                    BeanInfo beanInfo;
                    Class clazz;
                    try {
                        clazz = simpleClassLoader.loadClass(stringArray[n]);
                    }
                    catch (Exception exception) {
                        break block7;
                    }
                    try {
                        beanInfo = Introspector.getBeanInfo(clazz);
                    }
                    catch (Exception exception) {
                        System.err.println("JarInfo: couldn't find BeanInfo for " + clazz + "; caught " + exception);
                        break block7;
                    }
                    this.beanInfos[n] = beanInfo;
                    JarInfo.debug("JarInfo:: @ " + n + "; beanName: " + stringArray[n] + "; fromPrototype: " + blArray[n]);
                }
            }
            ++n;
        }
    }

    public static String getJarName(String string) {
        return (String)beanToJar.get(string);
    }

    public String getJarName() {
        return this.jarName;
    }

    public int getCount() {
        return this.beanNames.length;
    }

    public BeanInfo getBeanInfo(int n) {
        if (this.beanInfos[n] != null) {
            return this.beanInfos[n];
        }
        Object object = this.getInstance(this.beanNames[n]);
        if (object != null) {
            BeanInfo beanInfo;
            Class<?> clazz = object.getClass();
            try {
                beanInfo = Introspector.getBeanInfo(clazz);
            }
            catch (Exception exception) {
                System.err.println("JarInfo: couldn't find BeanInfo for " + clazz + "; caught " + exception);
                return null;
            }
            this.beanInfos[n] = beanInfo;
            return beanInfo;
        }
        return null;
    }

    public String getName(int n) {
        return this.beanNames[n];
    }

    public boolean isFromPrototype(String string) {
        return this.fromPrototype[this.indexForName(string)];
    }

    public MessageHeader getManifestData(String string) {
        return this.manifestData[this.indexForName(string)];
    }

    public Object getInstance(String string) {
        try {
            return Beans.instantiate(this.classLoader, string);
        }
        catch (Throwable throwable) {
            this.diagnoseInstantiationException(this.classLoader, string, throwable);
            System.err.println("");
            if (string.indexOf(92) >= 0) {
                System.err.println("    Note that file names in manifests must use forward slashes \"/\" \n    rather than back-slashes \"\\\"");
            }
            return null;
        }
    }

    void diagnoseInstantiationException(SimpleClassLoader simpleClassLoader, String string, Throwable throwable) {
        Class clazz;
        String string2;
        System.err.print("\nWARNING: Could not instantiate bean \"" + string + "\"");
        if (simpleClassLoader == null) {
            System.err.println(" from the system class-loader");
            return;
        }
        System.err.println(" from JAR \"" + this.jarName + "\"");
        String string3 = string.replace('.', '/').concat(".ser");
        InputStream inputStream = simpleClassLoader.getResourceAsStream(string3);
        if (inputStream != null) {
            System.err.println("    We found a serialized template file \"" + string3 + "\"");
            try {
                ObjectInputStreamWithLoader objectInputStreamWithLoader = new ObjectInputStreamWithLoader(inputStream, simpleClassLoader);
                objectInputStreamWithLoader.readObject();
                System.err.println("    An object could be read from the serialized template OK.");
                System.err.println("    But an exception was generated in Beans.instantiate:");
                System.err.println("        " + throwable);
            }
            catch (ObjectStreamException objectStreamException) {
                System.err.println("    But caught an ObjectStreamException while reading the serialized object:");
                System.err.println("        " + objectStreamException);
                System.err.println("    This indicates there is a problem with the contents of the template file.");
            }
            catch (IOException iOException) {
                System.err.println("    But caught an IOException while reading the serialized object:");
                System.err.println("        " + iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("    But caught a ClassNotFoundException while reading the serialized object:");
                System.err.println("        " + classNotFoundException);
                System.err.println("    This indicates that there was a problem finding a .class file for one");
                System.err.println("    of the serialized objects");
            }
            catch (Throwable throwable2) {
                System.err.println("    But caught an unexpected exception while reading the serialized object:");
                System.err.println("        " + throwable2);
            }
            try {
                inputStream.close();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        try {
            string2 = string.replace('.', '/').concat(".class");
            inputStream = simpleClassLoader.getResourceAsStream(string2);
            if (inputStream == null) {
                System.err.println("    We couldn't open the class file \"" + string2 + "\" in the JAR");
                return;
            }
            System.err.println("    We found the class file \"" + string2 + "\"");
        }
        catch (SecurityException securityException) {}
        string2 = "the default package";
        String string4 = string;
        if (string.lastIndexOf(46) > 0) {
            string2 = "the package \"" + string.substring(0, string.lastIndexOf(46)) + "\"";
            string4 = string.substring(string.lastIndexOf(46) + 1);
        }
        try {
            clazz = simpleClassLoader.loadClass(string);
        }
        catch (Exception exception) {
            System.err.println("    But were unable to load the class \"" + string + "\" because of");
            System.err.println("        " + exception);
            System.err.println("    Common reasons for this failure include:");
            System.err.println("    (1) The class is not defined in the correct package");
            System.err.println("        it should be in " + string2);
            System.err.println("    (2) The class has not been given the correct name");
            System.err.println("    it should be called \"" + string4 + "\"");
            System.err.println("    (3) The class file contains the wrong class or no class at all");
            return;
        }
        catch (Throwable throwable3) {
            System.err.println("    But were unable to load the class \"" + string + "\" because of");
            System.err.println("        " + throwable3);
            if (throwable3 instanceof ClassFormatError && throwable3.getMessage().equals("Duplicate name")) {
                System.err.println("    This particular error is often caused by having a mismatch between the name of");
                System.err.println("    the .class file and the name of the contained class.");
                System.err.println("    In this case make sure that class file contains a class");
                System.err.println("    called \"" + string4 + "\" in " + string2 + ".");
                return;
            }
            throwable3.printStackTrace();
            return;
        }
        System.err.println("    We located the class \"" + string + "\" OK");
        int n = clazz.getModifiers();
        if (!Modifier.isPublic(n)) {
            System.err.println("    But the class was not declared public, so we could not create a bean");
            return;
        }
        try {
            Class[] classArray = new Class[]{};
            Constructor constructor = clazz.getConstructor(classArray);
            if (constructor == null) {
                System.err.println("    But the class did not have a zero-arg constructor.");
                System.err.println("    All beans must provide public zero-arg constructors.");
                return;
            }
            n = constructor.getModifiers();
            if (!Modifier.isPublic(n)) {
                System.err.println("    But the class's zero-arg constructor was not declared public");
                System.err.println("    All beans must provide public zero-arg constructors.");
                return;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println("    But the class did not have a zero-arg constructor.");
            System.err.println("    All beans must provide public zero-arg constructors.");
            return;
        }
        catch (Throwable throwable4) {
            System.err.println("    Unexpected exception in disgnoseInstantiationException");
            System.err.println("    " + throwable4);
            throwable4.printStackTrace();
            return;
        }
        System.err.println("    The class provides a public zero-arg constructor");
        try {
            clazz.newInstance();
        }
        catch (Throwable throwable5) {
            System.err.println("    But were unable to create an instance of the class because we");
            System.err.println("    got an exception while doing Class.newInstance() :");
            System.err.println("       " + throwable5);
            System.err.println("    The stack backtrace at the time of this exception is");
            throwable5.printStackTrace();
            return;
        }
        System.err.println("    But an exception was generated in Beans.instantiate:");
        System.err.println("        " + throwable);
        throwable.printStackTrace();
    }

    private int indexForName(String string) {
        int n = 0;
        while (n < this.beanNames.length) {
            if (this.beanNames[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private static void debug(String string) {
        if (debug) {
            System.err.println("JarInfo:: " + string);
        }
    }
}

