/*
 * Decompiled with CFR 0.152.
 */
package sun.beans.ole;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import sun.beanbox.JarInfo;
import sun.beanbox.JarLoader;
import sun.beans.ole.InformationDialog;
import sun.beans.ole.OleBeanInfo;
import sun.beans.ole.StubInformation;
import sun.beans.ole.TextFeedback;
import sun.beans.ole.UserFeedback;
import sun.beans.ole.VisualFeedback;

class Packager
implements ActionListener,
WindowListener {
    private Frame frame;
    private Panel centerPanel;
    private Button nextButton;
    private Button previousButton;
    private Button browseButton;
    private List beanList;
    private Button startButton;
    private int currentStep;
    private TextField targetDir;
    private TextField jarName;
    private TextField beanName;
    private Checkbox registerCheckbox;
    private TextField infoLabel;
    private UserFeedback userFeedback;
    private boolean isCompleted;
    private ResourceBundle rb;

    public static void main(String[] stringArray) {
        new Packager(stringArray, true);
        System.exit(0);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Packager(String[] var1_1, boolean var2_2) {
        block1: {
            super();
            this.targetDir = new TextField(String.valueOf(this.getJavaPluginInstallationDirectory()) + "\\classes");
            this.jarName = new TextField("c:\\bdk\\jars\\buttons.jar");
            this.rb = ResourceBundle.getBundle("sun.beans.ole.resources.Packager");
            if (var1_1.length != 0) break block1;
            this.frame = new Frame(this.getMessage("frame.title"));
            this.frame.addWindowListener(this);
            this.isCompleted = false;
            this.openWizard();
            if (true) ** GOTO lbl13
            do {
                Thread.yield();
lbl13:
                // 2 sources

                if (!var2_2) return;
            } while (!this.isCompleted);
            return;
        }
        this.userFeedback = new TextFeedback(System.out);
        var3_3 = this.extractArguments(var1_1);
        if (!this.isValidStubInfo(var3_3)) return;
        this.generate(var3_3);
    }

    private boolean isValidStubInfo(StubInformation stubInformation) {
        Serializable serializable;
        String string;
        OleBeanInfo oleBeanInfo;
        JarInfo jarInfo;
        if (stubInformation == null) {
            return false;
        }
        String string2 = stubInformation.getJarFileName();
        if (string2 == null) {
            this.userFeedback.printText(this.getMessage("error.jarnotfound"));
            return false;
        }
        JarLoader jarLoader = this.loadJar(string2);
        if (jarLoader == null) {
            this.userFeedback.printText(this.getMessage("error.invalidjar"));
            return false;
        }
        try {
            jarInfo = jarLoader.loadJar();
        }
        catch (IOException iOException) {
            this.userFeedback.printText(String.valueOf(this.getMessage("error.jarunreadeable")) + string2);
            return false;
        }
        String string3 = stubInformation.getSourceBeanName();
        if (string3 == null) {
            if (jarInfo.getCount() == 0) {
                this.userFeedback.printText(String.valueOf(this.getMessage("error.nobeansinjar")) + string2);
                return false;
            }
            string3 = jarInfo.getName(0);
            stubInformation.setSourceBeanName(string3);
        }
        if ((oleBeanInfo = this.loadBean(string2, string3)) == null) {
            this.userFeedback.printText(String.valueOf(string3) + this.getMessage("error.beannotfound") + string2);
            return false;
        }
        stubInformation.setOleBeanInfo(oleBeanInfo);
        if (stubInformation.getActiveXName() == null) {
            stubInformation.setActiveXName(this.getActiveXNameFromJavaBeans(string3));
        }
        if ((string = stubInformation.getTargetDir()) == null) {
            serializable = System.getProperties();
            string = ((Properties)serializable).getProperty("user.dir", null);
        }
        stubInformation.setTargetDir(string);
        serializable = new File(string);
        if (((File)serializable).exists()) {
            return true;
        }
        this.userFeedback.printText(String.valueOf(this.getMessage("error.directory")) + string);
        return false;
    }

    private String getActiveXNameFromJavaBeans(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1, string.length());
    }

    public StubInformation extractArguments(String[] stringArray) {
        int n = stringArray.length;
        StubInformation stubInformation = new StubInformation();
        stubInformation.setEventGeneration(true);
        stubInformation.setRegister(true);
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string.equalsIgnoreCase("-help") || string.equalsIgnoreCase("-?")) {
                this.displayHelp();
                return null;
            }
            try {
                if (stringArray[n2].equalsIgnoreCase("-jar")) {
                    stubInformation.setJarFileName(stringArray[++n2]);
                }
                if (stringArray[n2].equalsIgnoreCase("-n")) {
                    stubInformation.setSourceBeanName(stringArray[++n2]);
                }
                if (stringArray[n2].equalsIgnoreCase("-ax")) {
                    stubInformation.setActiveXName(stringArray[++n2]);
                }
                if (stringArray[n2].equalsIgnoreCase("-o")) {
                    stubInformation.setTargetDir(stringArray[++n2]);
                }
                if (stringArray[n2].equalsIgnoreCase("-awt")) {
                    stubInformation.setEventGeneration(false);
                }
                if (stringArray[n2].equalsIgnoreCase("-noreg")) {
                    stubInformation.setRegister(false);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println(this.getMessage("error.badparameters"));
                this.displayHelp();
                return null;
            }
            ++n2;
        }
        return stubInformation;
    }

    private void displayHelp() {
        System.out.println(String.valueOf(this.getMessage("packager.title")) + this.getMessage("packager.version"));
        System.out.println(this.getMessage("parms.title"));
        System.out.println("        -jar " + this.getMessage("parms.file"));
        System.out.println("         " + this.getMessage("parms.fileex"));
        System.out.println("        -n " + this.getMessage("parms.string"));
        System.out.println("         " + this.getMessage("parms.stringex"));
        System.out.println("        -ax " + this.getMessage("parms.string"));
        System.out.println("         " + this.getMessage("parms.activex"));
        System.out.println("        -o " + this.getMessage("parms.directory"));
        System.out.println("         " + this.getMessage("parms.directoryex"));
        System.out.println("        -noreg");
        System.out.println("         " + this.getMessage("parms.noregex"));
    }

    public void openWizard() {
        this.centerPanel = new Panel();
        this.frame.setLayout(new BorderLayout());
        ((Component)this.frame).setBackground(Color.lightGray);
        Font font = new Font("TimesRoman", 3, 20);
        Label label = new Label(String.valueOf(this.getMessage("packager.title")) + this.getMessage("packager.version"), 1);
        label.setFont(font);
        this.frame.add((Component)label, "North");
        Panel panel = new Panel();
        Font font2 = new Font("TimesRoman", 0, 14);
        this.nextButton = new Button(this.getMessage("panel1.next"));
        this.nextButton.setFont(font2);
        this.nextButton.addActionListener(this);
        this.previousButton = new Button(this.getMessage("panel1.back"));
        this.previousButton.setFont(font2);
        this.previousButton.addActionListener(this);
        panel.add(this.previousButton);
        panel.add(this.nextButton);
        this.currentStep = 1;
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)this.centerPanel, "Center");
        panel2.add((Component)panel, "South");
        this.updateCenterPanel();
        this.frame.add((Component)panel2, "Center");
        this.frame.add((Component)new Label(this.getMessage("panel1.copyright"), 1), "South");
        this.frame.pack();
        ((Component)this.frame).setBounds(200, 200, 500, 260);
        this.frame.show();
    }

    private void updateCenterPanel() {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 1, 10, 10));
        Font font = new Font("TimesRoman", 1, 14);
        Label label = new Label(String.valueOf(this.getMessage("panel1.beforeStep")) + this.currentStep + this.getMessage("panel1.afterStep"), 1);
        label.setFont(font);
        panel.add(label);
        Panel panel2 = new Panel();
        switch (this.currentStep) {
            case 1: {
                panel.add(new Label(this.getMessage("panel1.description"), 1));
                panel2.setLayout(new GridLayout(2, 1, 0, 0));
                Panel panel3 = new Panel();
                panel3.setLayout(new BorderLayout());
                this.browseButton = new Button(this.getMessage("panel1.browse"));
                this.browseButton.addActionListener(this);
                panel3.add((Component)this.browseButton, "East");
                panel2.add(this.jarName);
                panel2.add(panel3);
                this.previousButton.disable();
                break;
            }
            case 2: {
                panel.add(new Label(this.getMessage("panel2.description"), 1));
                this.previousButton.enable();
                try {
                    JarLoader jarLoader = this.loadJar(this.jarName.getText());
                    JarInfo jarInfo = jarLoader.loadJar();
                    this.beanList = jarInfo.getCount() > 5 ? new List(5, false) : new List(jarInfo.getCount(), false);
                    int n = 0;
                    while (n < jarInfo.getCount()) {
                        this.beanList.addItem(jarInfo.getName(n));
                        ++n;
                    }
                }
                catch (Throwable throwable) {
                    System.err.println("->" + throwable.toString());
                    throwable.printStackTrace();
                }
                this.beanList.select(0);
                panel2.removeAll();
                panel2.setLayout(new GridLayout(1, 1, 0, 0));
                panel2.add(this.beanList);
                break;
            }
            case 3: {
                panel.add(new Label(String.valueOf(this.getMessage("panel3.description")) + this.beanList.getSelectedItem(), 1));
                this.beanName = new TextField(this.getActiveXNameFromJavaBeans(this.beanList.getSelectedItem()));
                panel2.setLayout(new GridLayout(1, 1, 0, 0));
                panel2.add(this.beanName);
                break;
            }
            case 4: {
                panel.add(new Label(this.getMessage("panel4.description"), 1));
                panel2.setLayout(new GridLayout(1, 1, 0, 0));
                panel2.add(this.targetDir);
                this.nextButton.enable();
                break;
            }
            case 5: {
                panel.add(new Label(this.getMessage("panel5.description"), 1));
                panel2.setLayout(new GridLayout(3, 1, 0, 0));
                this.startButton = new Button(this.getMessage("panel5.start"));
                this.startButton.addActionListener(this);
                this.registerCheckbox = new Checkbox(this.getMessage("panel5.register"));
                this.registerCheckbox.setState(true);
                panel2.add(this.registerCheckbox);
                panel2.add(this.startButton);
                this.nextButton.disable();
                break;
            }
        }
        this.centerPanel.removeAll();
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.add((Component)panel, "North");
        this.centerPanel.add((Component)panel2, "South");
        this.centerPanel.validate();
    }

    private boolean checkInvariant() {
        switch (this.currentStep) {
            case 1: {
                if (this.loadJar(this.jarName.getText()) != null) break;
                new InformationDialog(this.frame, this.getMessage("packager.error"), this.getMessage("error.nulljarfile"));
                return false;
            }
            case 2: {
                if (this.beanList.getSelectedItem() != null) break;
                new InformationDialog(this.frame, this.getMessage("packager.error"), this.getMessage("error.nullbeanname"));
                return false;
            }
            case 3: {
                if (this.beanName.getText().length() != 0) break;
                new InformationDialog(this.frame, this.getMessage("packager.error"), this.getMessage("error.nullactivexname"));
                return false;
            }
            case 4: {
                if (this.targetDir.getText().length() == 0) {
                    new InformationDialog(this.frame, this.getMessage("packager.error"), this.getMessage("error.directory"));
                    return false;
                }
                File file = new File(this.targetDir.getText());
                if (file.exists()) {
                    return true;
                }
                new InformationDialog(this.frame, this.getMessage("packager.error"), this.getMessage("error.directory"));
                return false;
            }
        }
        return true;
    }

    private JarLoader loadJar(String string) {
        JarLoader jarLoader = null;
        try {
            jarLoader = new JarLoader(string);
            if (jarLoader == null) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return jarLoader;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        if (actionEvent.getSource() == this.nextButton && this.checkInvariant()) {
            ++this.currentStep;
            this.updateCenterPanel();
        }
        if (actionEvent.getSource() == this.previousButton) {
            --this.currentStep;
            this.updateCenterPanel();
        }
        if (actionEvent.getSource() == this.browseButton && (string = this.getJarFileName()) != null) {
            ((TextComponent)this.jarName).setText(string);
        }
        if (actionEvent.getSource() == this.startButton) {
            this.generate();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.isCompleted = true;
        this.frame.removeWindowListener(this);
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.frame.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public String getJarFileName() {
        FileDialog fileDialog = new FileDialog(this.frame, this.getMessage("packager.loadfile"), 0);
        fileDialog.setFile(this.jarName.getText());
        fileDialog.show();
        String string = fileDialog.getFile();
        if (string == null) {
            return null;
        }
        String string2 = fileDialog.getDirectory();
        File file = new File(string2, string);
        if (file.exists()) {
            return String.valueOf(string2) + string;
        }
        return null;
    }

    private OleBeanInfo loadBean(String string, String string2) {
        JarInfo jarInfo;
        JarLoader jarLoader = this.loadJar(string);
        if (jarLoader == null) {
            return null;
        }
        try {
            jarInfo = jarLoader.loadJar();
        }
        catch (IOException iOException) {
            this.userFeedback.printText(String.valueOf(this.getMessage("error.jarunreadeable")) + string);
            return null;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < jarInfo.getCount()) {
            if (jarInfo.getName(n2).equals(string2)) {
                n = n2;
            }
            ++n2;
        }
        if (n != -1) {
            try {
                Object object = jarInfo.getInstance(string2);
                if (object != null) {
                    Class<?> clazz = object.getClass();
                    return new OleBeanInfo(clazz);
                }
            }
            catch (Throwable throwable) {
                String[] stringArray = new String[]{throwable.toString(), this.getMessage("packager.statustitle")};
                this.userFeedback.warn(this.getMessage("error.introspection"), stringArray);
                this.userFeedback.printText(String.valueOf(this.getMessage("error.introspectionex")) + string2);
                return null;
            }
        }
        return null;
    }

    private void generate() {
        this.centerPanel.removeAll();
        this.centerPanel.setLayout(new GridLayout(2, 1, 0, 0));
        this.centerPanel.add(new Label(this.getMessage("packager.statustitle")));
        this.infoLabel = new TextField(" ", 80);
        this.infoLabel.setEditable(false);
        this.centerPanel.add(this.infoLabel);
        this.centerPanel.validate();
        this.userFeedback = new VisualFeedback(this.frame, this.infoLabel);
        this.loadBean(this.jarName.getText(), this.beanList.getSelectedItem());
        StubInformation stubInformation = new StubInformation();
        stubInformation.setSourceBeanName(this.beanList.getSelectedItem());
        stubInformation.setJarFileName(this.jarName.getText());
        stubInformation.setOleBeanInfo(this.loadBean(this.jarName.getText(), this.beanList.getSelectedItem()));
        stubInformation.setActiveXName(this.beanName.getText());
        stubInformation.setTargetDir(this.targetDir.getText());
        stubInformation.setRegister(this.registerCheckbox.getState());
        this.generate(stubInformation);
    }

    private void generate(StubInformation stubInformation) {
        boolean bl = false;
        stubInformation.getTargetDir();
        if (stubInformation.getOleBeanInfo() != null) {
            this.userFeedback.printText(this.getMessage("packager.statusbegin"));
            bl = this.generateTypeLib(stubInformation);
            this.userFeedback.printText(this.getMessage("packager.statusend"));
        }
        this.userFeedback.warn(this.getMessage("packager.statustitle"), bl ? this.getMessage("packager.statussuccess") : this.getMessage("packager.statusfailed"));
        if (this.frame != null) {
            this.frame.dispose();
        }
    }

    public String getMessage(String string) {
        try {
            return this.rb.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    private native boolean generateTypeLib(StubInformation var1);

    private native String getJavaPluginInstallationDirectory();

    static {
        System.loadLibrary("packager");
    }
}

