/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.classfile;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import sun.beans.ole.event.EncapsulatedEventAdaptorGenerator;
import sunw.demo.classfile.Attribute;
import sunw.demo.classfile.ClassConstant;
import sunw.demo.classfile.ClassFile;
import sunw.demo.classfile.Code;
import sunw.demo.classfile.Exceptions;
import sunw.demo.classfile.FieldConstant;
import sunw.demo.classfile.FieldDesc;
import sunw.demo.classfile.MethodConstant;
import sunw.demo.classfile.MethodDesc;
import sunw.demo.classfile.StringConstant;

public final class EncapsulatedEventAdaptorClassFile {
    private static String superClassName = "sun.beans.ole.event.EncapsulatedEventAdaptor";
    private String listenerName;
    private Class listenerClass;
    private String adaptorName;
    private ClassFile classFile;
    private Method[] listenerMethods;
    private StringConstant listenerNameConst;
    private FieldConstant methodsField;
    private FieldConstant clazzField;
    private MethodConstant fireMethod;
    private MethodConstant crackedFireMethod;
    private MethodConstant forNameMethod;
    private MethodConstant getMethodsMethod;
    static /* synthetic */ Class class$java$util$EventObject;

    public EncapsulatedEventAdaptorClassFile(String string, OutputStream outputStream) throws IOException, ClassNotFoundException {
        this.adaptorName = string;
        this.listenerName = EncapsulatedEventAdaptorGenerator.getBaseNameFromAdaptorName(string);
        this.listenerClass = Class.forName(this.listenerName);
        this.listenerMethods = this.listenerClass.getMethods();
        this.classFile = new ClassFile(string, superClassName);
        this.generateClassSundries();
        this.generateInitializer();
        this.generateConstructor();
        this.generateListenerMethods();
        this.write(outputStream);
    }

    public EncapsulatedEventAdaptorClassFile(String string, Class clazz, OutputStream outputStream) throws IOException, ClassNotFoundException {
        this.adaptorName = string;
        this.listenerName = clazz.getName();
        this.listenerClass = clazz;
        this.listenerMethods = clazz.getMethods();
        this.classFile = new ClassFile(string, superClassName);
        this.generateClassSundries();
        this.generateInitializer();
        this.generateConstructor();
        this.generateListenerMethods();
        this.write(outputStream);
    }

    private boolean debug() {
        return false;
    }

    private void generateClassSundries() {
        this.classFile.addInterface(ClassFile.fullyQualifiedForm(this.listenerName));
        this.listenerNameConst = this.classFile.addStringConstant(this.listenerName);
        this.classFile.addFieldDesc(new FieldDesc("methods", "[Ljava/lang/reflect/Method;", 10, this.classFile, null));
        this.methodsField = this.classFile.addFieldConstant(this.adaptorName, "methods", "[Ljava/lang/reflect/Method;");
        this.getMethodsMethod = this.classFile.addMethodConstant("java/lang/Class", "getMethods", "()[Ljava/lang/reflect/Method;");
        this.forNameMethod = this.classFile.addMethodConstant("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;");
        this.classFile.addFieldDesc(new FieldDesc("clazz", "Ljava/lang/Class;", 10, this.classFile, null));
        this.clazzField = this.classFile.addFieldConstant(this.adaptorName, "clazz", "Ljava/lang/Class;");
        this.fireMethod = this.classFile.addMethodConstant(this.adaptorName, "fire", "(Ljava/util/EventObject;Ljava/lang/reflect/Method;)V");
        this.crackedFireMethod = this.classFile.addMethodConstant(this.adaptorName, "fire", "([Ljava/lang/Object;Ljava/lang/reflect/Method;)V");
        Code code = new Code(this.classFile, 1, 2);
        code.addOpShort((byte)-78, this.clazzField.getConstantPoolIndex());
        code.addOp((byte)-80);
        Attribute[] attributeArray = new Code[]{code};
        this.classFile.addMethodDesc(new MethodDesc("getListenerClass", "()Ljava/lang/Class;", 1, this.classFile, attributeArray));
    }

    private void generateInitializer() {
        Code code = new Code(this.classFile, 0, 3);
        Attribute[] attributeArray = new Code[]{code};
        short s = this.listenerNameConst.getConstantPoolIndex();
        if (s <= 255) {
            code.addOp1((byte)18, (byte)s);
        } else {
            code.addOpShort((byte)19, s);
        }
        code.addOpShort((byte)-72, this.forNameMethod.getConstantPoolIndex());
        code.addOp((byte)89);
        code.addOpShort((byte)-77, this.clazzField.getConstantPoolIndex());
        code.addOpShort((byte)-74, this.getMethodsMethod.getConstantPoolIndex());
        code.addOpShort((byte)-77, this.methodsField.getConstantPoolIndex());
        code.addOp((byte)-79);
        this.classFile.addMethodDesc(new MethodDesc("<clinit>", "()V", 10, this.classFile, attributeArray));
    }

    private void generateConstructor() {
        Code code = new Code(this.classFile, 1, 2);
        Attribute[] attributeArray = new Code[]{code};
        MethodConstant methodConstant = this.classFile.addMethodConstant(ClassFile.fullyQualifiedForm(superClassName), "<init>", "()V");
        code.addOp((byte)42);
        code.addOpShort((byte)-73, methodConstant.getConstantPoolIndex());
        code.addOp((byte)-79);
        this.classFile.addMethodDesc(new MethodDesc("<init>", "()V", 1, this.classFile, attributeArray));
    }

    private void generateListenerMethods() {
        int n = 0;
        while (n < this.listenerMethods.length) {
            if (!Void.TYPE.equals(this.listenerMethods[n].getReturnType())) {
                System.err.println("Detected unexpected method signature: " + this.listenerMethods[n] + " in interface: " + this.listenerName);
            } else {
                Class[] classArray = this.listenerMethods[n].getParameterTypes();
                Class[] classArray2 = this.listenerMethods[n].getExceptionTypes();
                if (classArray != null && classArray.length == 1 && (class$java$util$EventObject != null ? class$java$util$EventObject : EncapsulatedEventAdaptorClassFile.class$("java.util.EventObject")).isAssignableFrom(classArray[0])) {
                    this.generateSimpleListenerMethodStub(this.listenerMethods[n], classArray[0], classArray2, n);
                } else {
                    this.generateCrackedListenerMethodStub(this.listenerMethods[n], classArray, classArray2, n);
                }
            }
            ++n;
        }
    }

    private void generateSimpleListenerMethodStub(Method method, Class clazz, Class[] classArray, int n) {
        Attribute[] attributeArray;
        Code code = new Code(this.classFile, 2, 4);
        code.addOp((byte)42);
        code.addOp((byte)43);
        code.addOpShort((byte)-78, this.methodsField.getConstantPoolIndex());
        if (n <= 255) {
            code.addOp1((byte)16, (byte)n);
        } else {
            short s = this.classFile.addIntegerConstant(n).getConstantPoolIndex();
            if (s <= 255) {
                code.addOp1((byte)18, (byte)s);
            } else {
                code.addOpShort((byte)19, s);
            }
        }
        code.addOp((byte)50);
        code.addOpShort((byte)-74, this.fireMethod.getConstantPoolIndex());
        code.addOp((byte)-79);
        if (classArray != null && classArray.length > 0) {
            attributeArray = new Attribute[2];
            attributeArray[1] = new Exceptions(classArray, this.classFile);
        } else {
            attributeArray = new Attribute[]{code};
        }
        this.classFile.addMethodDesc(new MethodDesc(method.getName(), "(" + ClassFile.fieldType(clazz.getName()) + ")V", (short)(method.getModifiers() & 0xFFFFFBFF), this.classFile, attributeArray));
    }

    private void generateCrackedListenerMethodStub(Method method, Class[] classArray, Class[] classArray2, int n) {
        Attribute[] attributeArray;
        int n2;
        Code code = new Code(this.classFile, (short)(classArray.length * 2 + 1), 9);
        String string = "";
        code.addOp((byte)42);
        if (classArray.length <= 255) {
            code.addOp1((byte)16, (byte)classArray.length);
        } else {
            n2 = this.classFile.addIntegerConstant(classArray.length).getConstantPoolIndex();
            if (n2 <= 255) {
                code.addOp1((byte)18, (byte)n2);
            } else {
                code.addOpShort((byte)19, (short)n2);
            }
        }
        code.addOpShort((byte)-67, this.classFile.addClassConstant("java.lang.Object").getConstantPoolIndex());
        n2 = 1;
        int n3 = 0;
        while (n3 < classArray.length) {
            code.addOp((byte)89);
            if (n2 <= 255) {
                code.addOp1((byte)16, (byte)n3);
            } else {
                short s = this.classFile.addIntegerConstant(n3).getConstantPoolIndex();
                if (s < 255) {
                    code.addOp1((byte)18, (byte)s);
                } else {
                    code.addOpShort((byte)19, s);
                }
            }
            String string2 = this.processParam(code, classArray[n3], n2);
            code.addOp((byte)83);
            boolean bl = string2.equals("J") || string2.equals("D");
            string = String.valueOf(string) + string2;
            ++n3;
            n2 += bl ? 2 : 1;
        }
        code.addOpShort((byte)-78, this.methodsField.getConstantPoolIndex());
        if (n <= 255) {
            code.addOp1((byte)16, (byte)n);
        } else {
            short s = this.classFile.addIntegerConstant(n).getConstantPoolIndex();
            if (s <= 255) {
                code.addOp1((byte)18, (byte)s);
            } else {
                code.addOpShort((byte)19, s);
            }
        }
        code.addOp((byte)50);
        code.addOpShort((byte)-74, this.crackedFireMethod.getConstantPoolIndex());
        code.addOp((byte)-79);
        if (classArray2 != null && classArray2.length > 0) {
            attributeArray = new Attribute[2];
            attributeArray[1] = new Exceptions(classArray2, this.classFile);
        } else {
            attributeArray = new Attribute[]{code};
        }
        this.classFile.addMethodDesc(new MethodDesc(method.getName(), "(" + string + ")V", (short)(method.getModifiers() & 0xFFFFFBFF), this.classFile, attributeArray));
    }

    private String processParam(Code code, Class clazz, int n) {
        ClassConstant classConstant = null;
        MethodConstant methodConstant = null;
        int n2 = 25;
        int n3 = 0;
        boolean bl = true;
        Class<?> clazz2 = clazz;
        String string = "";
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
            string = String.valueOf(string) + "[";
        }
        boolean bl2 = clazz2.isPrimitive();
        boolean bl3 = clazz.isArray();
        if (bl2) {
            if (clazz2.equals(Long.TYPE)) {
                string = String.valueOf(string) + "J";
                if (!bl3) {
                    classConstant = this.classFile.addClassConstant("java/lang/Long");
                    methodConstant = this.classFile.addMethodConstant("java/lang/Long", "<init>", "(J)V");
                    n2 = 22;
                    bl = false;
                }
            } else if (clazz2.equals(Float.TYPE)) {
                string = String.valueOf(string) + "F";
                if (!bl3) {
                    classConstant = this.classFile.addClassConstant("java/lang/Float");
                    methodConstant = this.classFile.addMethodConstant("java/lang/Float", "<init>", "(F)V");
                    n2 = 23;
                }
            } else if (clazz2.equals(Double.TYPE)) {
                string = String.valueOf(string) + "D";
                if (!bl3) {
                    classConstant = this.classFile.addClassConstant("java/lang/Double");
                    methodConstant = this.classFile.addMethodConstant("java/lang/Double", "<init>", "(D)V");
                    n2 = 24;
                    bl = false;
                }
            } else {
                n2 = 21;
                if (clazz2.equals(Boolean.TYPE)) {
                    string = String.valueOf(string) + "Z";
                    if (!bl3) {
                        classConstant = this.classFile.addClassConstant("java/lang/Boolean");
                        methodConstant = this.classFile.addMethodConstant("java/lang/Boolean", "<init>", "(Z)V");
                        n3 = -111;
                    }
                } else if (clazz2.equals(Character.TYPE)) {
                    string = String.valueOf(string) + "C";
                    if (!bl3) {
                        classConstant = this.classFile.addClassConstant("java/lang/Character");
                        methodConstant = this.classFile.addMethodConstant("java/lang/Character", "<init>", "(C)V");
                        n3 = -110;
                    }
                } else if (clazz2.equals(Byte.TYPE)) {
                    string = String.valueOf(string) + "B";
                    if (!bl3) {
                        classConstant = this.classFile.addClassConstant("java/lang/Byte");
                        methodConstant = this.classFile.addMethodConstant("java/lang/Character", "<init>", "(C)V");
                        n3 = -111;
                    }
                } else if (clazz2.equals(Short.TYPE)) {
                    string = String.valueOf(string) + "S";
                    if (!bl3) {
                        classConstant = this.classFile.addClassConstant("java/lang/Short");
                        methodConstant = this.classFile.addMethodConstant("java/lang/Short", "<init>", "(S)V");
                        n3 = -109;
                    }
                } else if (clazz2.equals(Integer.TYPE)) {
                    string = String.valueOf(string) + "I";
                    if (!bl3) {
                        classConstant = this.classFile.addClassConstant("java/lang/Integer");
                        methodConstant = this.classFile.addMethodConstant("java/lang/Integer", "<init>", "(I)V");
                    }
                }
            }
        } else {
            string = String.valueOf(string) + ClassFile.fieldType(clazz2.getName());
        }
        if (n < 255) {
            code.addOp1((byte)n2, (byte)n);
        } else {
            code.addOp((byte)-60);
            code.addOpShort((byte)n2, (short)n);
        }
        if (bl2 && !bl3) {
            if (n3 != 0) {
                code.addOp((byte)n3);
            }
            code.addOpShort((byte)-69, classConstant.getConstantPoolIndex());
            if (bl) {
                code.addOp((byte)90);
                code.addOp((byte)95);
            } else {
                code.addOp((byte)91);
                code.addOp((byte)91);
                code.addOp((byte)87);
            }
            code.addOpShort((byte)-73, methodConstant.getConstantPoolIndex());
        }
        return string;
    }

    private void write(OutputStream outputStream) throws IOException {
        this.classFile.write(outputStream);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

